/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.PigVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.world.entity.animal.pig.PigVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.Pig;
import org.jspecify.annotations.Nullable;

public class PaperPigVariantRegistryEntry
implements PigVariantRegistryEntry {
    protected @Nullable PigVariant.a model;
    protected  @Nullable ClientAsset.b clientTextureAsset;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperPigVariantRegistryEntry(Conversions conversions, @Nullable PigVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.a;
            return;
        }
        this.clientTextureAsset = internal.b().b();
        this.model = internal.b().a();
        this.spawnConditions = internal.c();
    }

    public ClientTextureAsset clientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset"));
    }

    public PigVariantRegistryEntry.Model model() {
        return switch (Checks.asConfigured(this.model, "model")) {
            default -> throw new MatchException(null, null);
            case PigVariant.a.a -> PigVariantRegistryEntry.Model.NORMAL;
            case PigVariant.a.b -> PigVariantRegistryEntry.Model.COLD;
        };
    }

    public static final class PaperBuilder
    extends PaperPigVariantRegistryEntry
    implements PigVariantRegistryEntry.Builder,
    PaperRegistryBuilder<PigVariant, Pig.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable PigVariant internal) {
            super(conversions, internal);
        }

        public PigVariantRegistryEntry.Builder clientTextureAsset(ClientTextureAsset clientTextureAsset) {
            this.clientTextureAsset = this.conversions.asVanilla(Checks.asArgument(clientTextureAsset, "clientTextureAsset"));
            return this;
        }

        public PigVariantRegistryEntry.Builder model(PigVariantRegistryEntry.Model model) {
            this.model = switch (Checks.asArgument(model, "model")) {
                default -> throw new MatchException(null, null);
                case PigVariantRegistryEntry.Model.NORMAL -> PigVariant.a.a;
                case PigVariantRegistryEntry.Model.COLD -> PigVariant.a.b;
            };
            return this;
        }

        @Override
        public PigVariant build() {
            return new PigVariant(new ModelAndTexture<PigVariant.a>(Checks.asConfigured(this.model, "model"), Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset")), Checks.asConfigured(this.spawnConditions, "spawnConditions"));
        }
    }
}

