/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.WolfVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.Wolf;
import org.jspecify.annotations.Nullable;

public class PaperWolfVariantRegistryEntry
implements WolfVariantRegistryEntry {
    protected  @Nullable ClientAsset.b angryClientTextureAsset;
    protected  @Nullable ClientAsset.b wildClientTextureAsset;
    protected  @Nullable ClientAsset.b tameClientTextureAsset;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperWolfVariantRegistryEntry(Conversions conversions, @Nullable WolfVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.a;
            return;
        }
        this.angryClientTextureAsset = internal.b().c();
        this.wildClientTextureAsset = internal.b().a();
        this.tameClientTextureAsset = internal.b().b();
        this.spawnConditions = internal.c();
    }

    public ClientTextureAsset angryClientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.angryClientTextureAsset, "angryClientTextureAsset"));
    }

    public ClientTextureAsset wildClientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.wildClientTextureAsset, "wildClientTextureAsset"));
    }

    public ClientTextureAsset tameClientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.tameClientTextureAsset, "tameClientTextureAsset"));
    }

    public static final class PaperBuilder
    extends PaperWolfVariantRegistryEntry
    implements WolfVariantRegistryEntry.Builder,
    PaperRegistryBuilder<WolfVariant, Wolf.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable WolfVariant internal) {
            super(conversions, internal);
        }

        public WolfVariantRegistryEntry.Builder angryClientTextureAsset(ClientTextureAsset angryClientTextureAsset) {
            this.angryClientTextureAsset = this.conversions.asVanilla(Checks.asArgument(angryClientTextureAsset, "angryClientTextureAsset"));
            return this;
        }

        public WolfVariantRegistryEntry.Builder wildClientTextureAsset(ClientTextureAsset wildClientTextureAsset) {
            this.wildClientTextureAsset = this.conversions.asVanilla(Checks.asArgument(wildClientTextureAsset, "wildClientTextureAsset"));
            return this;
        }

        public WolfVariantRegistryEntry.Builder tameClientTextureAsset(ClientTextureAsset tameClientTextureAsset) {
            this.tameClientTextureAsset = this.conversions.asVanilla(Checks.asArgument(tameClientTextureAsset, "tameClientTextureAsset"));
            return this;
        }

        @Override
        public WolfVariant build() {
            return new WolfVariant(new WolfVariant.a(Checks.asConfigured(this.wildClientTextureAsset, "wildClientTextureAsset"), Checks.asConfigured(this.tameClientTextureAsset, "tameClientTextureAsset"), Checks.asConfigured(this.angryClientTextureAsset, "angryClientTextureAsset")), Checks.asConfigured(this.spawnConditions, "spawnConditions"));
        }
    }
}

