/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.ZombieNautilusVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.ZombieNautilus;
import org.jspecify.annotations.Nullable;

public class PaperZombieNautilusVariantRegistryEntry
implements ZombieNautilusVariantRegistryEntry {
    protected @Nullable ZombieNautilusVariant.a model;
    protected  @Nullable ClientAsset.b clientTextureAsset;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperZombieNautilusVariantRegistryEntry(Conversions conversions, @Nullable ZombieNautilusVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.a;
            return;
        }
        this.clientTextureAsset = internal.b().b();
        this.model = internal.b().a();
        this.spawnConditions = internal.c();
    }

    public ClientTextureAsset clientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset"));
    }

    public ZombieNautilusVariantRegistryEntry.Model model() {
        return switch (Checks.asConfigured(this.model, "model")) {
            default -> throw new MatchException(null, null);
            case ZombieNautilusVariant.a.a -> ZombieNautilusVariantRegistryEntry.Model.NORMAL;
            case ZombieNautilusVariant.a.b -> ZombieNautilusVariantRegistryEntry.Model.WARM;
        };
    }

    public static final class PaperBuilder
    extends PaperZombieNautilusVariantRegistryEntry
    implements ZombieNautilusVariantRegistryEntry.Builder,
    PaperRegistryBuilder<ZombieNautilusVariant, ZombieNautilus.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable ZombieNautilusVariant internal) {
            super(conversions, internal);
        }

        public ZombieNautilusVariantRegistryEntry.Builder clientTextureAsset(ClientTextureAsset clientTextureAsset) {
            this.clientTextureAsset = this.conversions.asVanilla(Checks.asArgument(clientTextureAsset, "clientTextureAsset"));
            return this;
        }

        public ZombieNautilusVariantRegistryEntry.Builder model(ZombieNautilusVariantRegistryEntry.Model model) {
            this.model = switch (Checks.asArgument(model, "model")) {
                default -> throw new MatchException(null, null);
                case ZombieNautilusVariantRegistryEntry.Model.NORMAL -> ZombieNautilusVariant.a.a;
                case ZombieNautilusVariantRegistryEntry.Model.WARM -> ZombieNautilusVariant.a.b;
            };
            return this;
        }

        @Override
        public ZombieNautilusVariant build() {
            return new ZombieNautilusVariant(new ModelAndTexture<ZombieNautilusVariant.a>(Checks.asConfigured(this.model, "model"), Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset")), Checks.asConfigured(this.spawnConditions, "spawnConditions"));
        }
    }
}

