/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.Nullable;

public record DialogBaseImpl(Component title, @Nullable Component externalTitle, boolean canCloseWithEscape, boolean pause, DialogBase.DialogAfterAction afterAction, @Unmodifiable List<DialogBody> body, @Unmodifiable List<DialogInput> inputs) implements DialogBase
{
    public DialogBaseImpl(Component title, @Nullable Component externalTitle, boolean canCloseWithEscape, boolean pause, DialogBase.DialogAfterAction afterAction, @Unmodifiable List<DialogBody> body, @Unmodifiable List<DialogInput> inputs) {
        Preconditions.checkArgument((!pause || afterAction != DialogBase.DialogAfterAction.NONE ? 1 : 0) != 0, (Object)"Dialogs that pause the game must use after_action values that unpause it after user action!");
        body = List.copyOf(body);
        inputs = List.copyOf(inputs);
    }

    public static final class BuilderImpl
    implements DialogBase.Builder {
        private final Component title;
        private @Nullable Component externalTitle;
        private boolean canCloseWithEscape = true;
        private boolean pause = true;
        private DialogBase.DialogAfterAction afterAction = DialogBase.DialogAfterAction.CLOSE;
        private List<DialogBody> body = Collections.emptyList();
        private List<DialogInput> inputs = Collections.emptyList();

        public BuilderImpl(Component title) {
            this.title = title;
        }

        public BuilderImpl externalTitle(@Nullable Component externalTitle) {
            this.externalTitle = externalTitle;
            return this;
        }

        public BuilderImpl canCloseWithEscape(boolean canCloseWithEscape) {
            this.canCloseWithEscape = canCloseWithEscape;
            return this;
        }

        public BuilderImpl pause(boolean pause) {
            this.pause = pause;
            return this;
        }

        public BuilderImpl afterAction(DialogBase.DialogAfterAction afterAction) {
            this.afterAction = afterAction;
            return this;
        }

        public BuilderImpl body(List<? extends DialogBody> body) {
            this.body = List.copyOf(body);
            return this;
        }

        public BuilderImpl inputs(List<? extends DialogInput> inputs) {
            this.inputs = List.copyOf(inputs);
            return this;
        }

        public DialogBase build() {
            return new DialogBaseImpl(this.title, this.externalTitle, this.canCloseWithEscape, this.pause, this.afterAction, this.body, this.inputs);
        }
    }
}

