/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog;

import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.PaperDialogCodecs;
import io.papermc.paper.registry.data.dialog.PaperDialogs;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.RegistryValueSetBuilder;
import io.papermc.paper.registry.set.RegistryValueSetBuilderImpl;
import net.minecraft.server.dialog.CommonDialogData;
import org.jspecify.annotations.Nullable;

public class PaperDialogRegistryEntry
implements DialogRegistryEntry {
    protected @Nullable DialogBase dialogBase;
    protected @Nullable DialogType dialogType;
    protected final Conversions conversions;

    public PaperDialogRegistryEntry(Conversions conversions, @Nullable net.minecraft.server.dialog.Dialog internal) {
        this.conversions = conversions;
        if (internal == null) {
            return;
        }
        CommonDialogData common = internal.A_();
        this.dialogBase = conversions.convert(common, PaperDialogCodecs.DIALOG_BASE_CODEC, CommonDialogData.a.codec());
        this.dialogType = PaperDialogs.extractType(internal, conversions);
    }

    public DialogBase base() {
        return Checks.asConfigured(this.dialogBase, "dialogBase");
    }

    public DialogType type() {
        return Checks.asConfigured(this.dialogType, "dialogType");
    }

    public static final class PaperBuilder
    extends PaperDialogRegistryEntry
    implements DialogRegistryEntry.Builder,
    PaperRegistryBuilder<net.minecraft.server.dialog.Dialog, Dialog> {
        public PaperBuilder(Conversions conversions, @Nullable net.minecraft.server.dialog.Dialog internal) {
            super(conversions, internal);
        }

        public RegistryValueSetBuilder<Dialog, DialogRegistryEntry.Builder> registryValueSet() {
            return new RegistryValueSetBuilderImpl(RegistryKey.DIALOG, this.conversions);
        }

        public DialogRegistryEntry.Builder base(DialogBase dialogBase) {
            this.dialogBase = Checks.asArgument(dialogBase, "dialogBase");
            return this;
        }

        public DialogRegistryEntry.Builder type(DialogType dialogType) {
            this.dialogType = Checks.asArgument(dialogType, "dialogType");
            return this;
        }

        @Override
        public net.minecraft.server.dialog.Dialog build() {
            return PaperDialogs.constructDialog(this.base(), this.type(), this.conversions);
        }
    }
}

