/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.input;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.data.dialog.input.NumberRangeDialogInput;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.functions.StringTemplate;
import org.jspecify.annotations.Nullable;

public record NumberRangeDialogInputImpl(String key, int width, Component label, String labelFormat, float start, float end, @Nullable Float initial, @Nullable Float step) implements NumberRangeDialogInput
{

    public static final class BuilderImpl
    implements NumberRangeDialogInput.Builder {
        private final String key;
        private final Component label;
        private final float start;
        private final float end;
        private int width = 200;
        private String labelFormat = "options.generic_value";
        private @Nullable Float initial = null;
        private @Nullable Float step = null;

        public BuilderImpl(String key, Component label, float start, float end) {
            Preconditions.checkArgument((boolean)StringTemplate.b(key), (Object)"key must be a valid input name");
            this.key = key;
            this.label = label;
            this.start = start;
            this.end = end;
        }

        public BuilderImpl width(int width) {
            Preconditions.checkArgument((width >= 1 && width <= 1024 ? 1 : 0) != 0, (Object)"width must be between 1 and 1024");
            this.width = width;
            return this;
        }

        public BuilderImpl labelFormat(String labelFormat) {
            this.labelFormat = labelFormat;
            return this;
        }

        public BuilderImpl initial(@Nullable Float initial) {
            if (initial != null) {
                Preconditions.checkArgument((initial.floatValue() >= this.start && initial.floatValue() <= this.end ? 1 : 0) != 0, (Object)"initial must be within the range");
            }
            this.initial = initial;
            return this;
        }

        public BuilderImpl step(@Nullable Float step) {
            Preconditions.checkArgument((step == null || step.floatValue() > 0.0f ? 1 : 0) != 0, (Object)"step must be null or greater than 0");
            this.step = step;
            return this;
        }

        public NumberRangeDialogInput build() {
            return new NumberRangeDialogInputImpl(this.key, this.width, this.label, this.labelFormat, this.start, this.end, this.initial, this.step);
        }
    }
}

