/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.input;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.data.dialog.input.TextDialogInput;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.functions.StringTemplate;
import org.jspecify.annotations.Nullable;

public record TextDialogInputImpl(String key, int width, Component label, boolean labelVisible, String initial, int maxLength, // Could not load outer class - annotation placement on inner may be incorrect
@Nullable TextDialogInput.MultilineOptions multiline) implements TextDialogInput
{

    public static final class BuilderImpl
    implements TextDialogInput.Builder {
        private final String key;
        private int width = 200;
        private final Component label;
        private boolean labelVisible = true;
        private String initial = "";
        private int maxLength = 32;
        private // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable TextDialogInput.MultilineOptions multiline = null;

        public BuilderImpl(String key, Component label) {
            Preconditions.checkArgument((boolean)StringTemplate.b(key), (Object)"key must be a valid input name");
            this.key = key;
            this.label = label;
        }

        public TextDialogInput.Builder width(int width) {
            Preconditions.checkArgument((width >= 1 && width <= 1024 ? 1 : 0) != 0, (Object)"width must be between 1 and 1024");
            this.width = width;
            return this;
        }

        public TextDialogInput.Builder labelVisible(boolean labelVisible) {
            this.labelVisible = labelVisible;
            return this;
        }

        public TextDialogInput.Builder initial(String initial) {
            this.initial = initial;
            return this;
        }

        public TextDialogInput.Builder maxLength(int maxLength) {
            Preconditions.checkArgument((maxLength > 0 ? 1 : 0) != 0, (Object)"maxLength must be greater than 0");
            this.maxLength = maxLength;
            return this;
        }

        public TextDialogInput.Builder multiline(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable TextDialogInput.MultilineOptions multiline) {
            this.multiline = multiline;
            return this;
        }

        public TextDialogInput build() {
            Preconditions.checkState((this.initial.length() <= this.maxLength ? 1 : 0) != 0, (Object)"The initial value must be less than or equal to the maximum length.");
            return new TextDialogInputImpl(this.key, this.width, this.label, this.labelVisible, this.initial, this.maxLength, this.multiline);
        }
    }

    public record MultilineOptionsImpl(@Nullable Integer maxLines, @Nullable Integer height) implements TextDialogInput.MultilineOptions
    {
        public MultilineOptionsImpl(@Nullable Integer maxLines, @Nullable Integer height) {
            Preconditions.checkArgument((maxLines == null || maxLines > 0 ? 1 : 0) != 0, (Object)"maxLines must be null or greater than 0");
            Preconditions.checkArgument((height == null || height >= 1 && height <= 512 ? 1 : 0) != 0, (Object)"height must be null or between 1 and 512");
        }
    }
}

