/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.util;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.WrapperAwareSerializer;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.PaperRegistryBuilderFactory;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import java.util.function.Consumer;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class Conversions {
    private static @Nullable Conversions globalInstance;
    private final RegistryOps.c lookup;
    private final WrapperAwareSerializer serializer;
    private final RegistryOps<Object> javaOps;

    public static Conversions global() {
        if (globalInstance == null) {
            IRegistryCustom globalAccess = CraftRegistry.getMinecraftRegistry();
            Preconditions.checkState((globalAccess != null ? 1 : 0) != 0, (Object)"Global registry access is not available");
            globalInstance = new Conversions(new RegistryOps.a(globalAccess));
        }
        return globalInstance;
    }

    public Conversions(RegistryOps.c lookup) {
        this.lookup = lookup;
        this.serializer = new WrapperAwareSerializer(() -> RegistryOps.a(JavaOps.INSTANCE, lookup));
        this.javaOps = RegistryOps.a(JavaOps.INSTANCE, lookup);
    }

    public <OUT, IN> OUT convert(IN in, Codec<OUT> outCodec, Codec<IN> inCodec) {
        Object obj = inCodec.encodeStart(this.javaOps, in).getOrThrow(s2 -> new RuntimeException("Failed to encode input: " + String.valueOf(in) + "; " + s2));
        return (OUT)((Pair)outCodec.decode(this.javaOps, obj).getOrThrow(s2 -> new RuntimeException("Failed to decode to output: " + String.valueOf(obj) + "; " + s2))).getFirst();
    }

    public RegistryOps.c lookup() {
        return this.lookup;
    }

    public <M> Holder.c<M> getReferenceHolder(ResourceKey<M> key) {
        return this.lookup.a(key.c()).orElseThrow().b().b(key);
    }

    @Contract(value="null -> null; !null -> !null")
    public @Nullable IChatBaseComponent asVanilla(@Nullable Component adventure) {
        if (adventure == null) {
            return null;
        }
        return this.serializer.serialize(adventure);
    }

    public Component asAdventure(@Nullable IChatBaseComponent vanilla) {
        return vanilla == null ? Component.empty() : this.serializer.deserialize(vanilla);
    }

    public ClientTextureAsset asBukkit( @Nullable ClientAsset.c clientTextureAsset) {
        return clientTextureAsset == null ? null : ClientTextureAsset.clientTextureAsset((Key)PaperAdventure.asAdventure(clientTextureAsset.a()), (Key)PaperAdventure.asAdventure(clientTextureAsset.b()));
    }

    public ClientAsset.b asVanilla(@Nullable ClientTextureAsset clientTextureAsset) {
        return clientTextureAsset == null ? null : new ClientAsset.b(PaperAdventure.asVanilla(clientTextureAsset.identifier()), PaperAdventure.asVanilla(clientTextureAsset.texturePath()));
    }

    private static <M, A extends Keyed, B extends PaperRegistryBuilder<M, A>> RegistryEntryMeta.Buildable<M, A, B> getDirectHolderBuildableMeta(RegistryKey<A> registryKey) {
        RegistryEntryMeta.Buildable buildableMeta = PaperRegistries.getBuildableMeta(registryKey);
        Preconditions.checkArgument((boolean)buildableMeta.registryTypeMapper().supportsDirectHolders(), (Object)"Registry type mapper must support direct holders");
        return buildableMeta;
    }

    public <M, A extends Keyed, B extends PaperRegistryBuilder<M, A>> A createApiInstanceFromBuilder(RegistryKey<A> registryKey, Consumer<? super PaperRegistryBuilderFactory<M, A, B>> value) {
        RegistryEntryMeta.Buildable<M, A, B> meta = Conversions.getDirectHolderBuildableMeta(registryKey);
        PaperRegistryBuilderFactory<M, A, B> builderFactory = this.createRegistryBuilderFactory(registryKey, meta);
        value.accept(builderFactory);
        return (A)((Keyed)meta.registryTypeMapper().createBukkit(Holder.a(builderFactory.requireBuilder().build())));
    }

    public <M, A extends Keyed, B extends PaperRegistryBuilder<M, A>> Holder<M> createHolderFromBuilder(RegistryKey<A> registryKey, Consumer<? super PaperRegistryBuilderFactory<M, A, B>> value) {
        RegistryEntryMeta.Buildable<M, A, B> meta = Conversions.getDirectHolderBuildableMeta(registryKey);
        PaperRegistryBuilderFactory<M, A, B> builderFactory = this.createRegistryBuilderFactory(registryKey, meta);
        value.accept(builderFactory);
        return Holder.a(builderFactory.requireBuilder().build());
    }

    private <M, A extends Keyed, B extends PaperRegistryBuilder<M, A>> PaperRegistryBuilderFactory<M, A, B> createRegistryBuilderFactory(RegistryKey<A> registryKey, RegistryEntryMeta.Buildable<M, A, B> buildableMeta) {
        ResourceKey resourceRegistryKey = PaperRegistries.registryToNms(registryKey);
        HolderLookup.b lookupForBuilders = this.lookup.lookupForValueCopyViaBuilders().e(resourceRegistryKey);
        return new PaperRegistryBuilderFactory(resourceRegistryKey, this, buildableMeta.builderFiller(), lookupForBuilders::getValueForCopying);
    }
}

