/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.entry;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.WritableCraftRegistry;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.entry.RegistryTypeMapper;
import io.papermc.paper.registry.event.RegistryComposeEventImpl;
import io.papermc.paper.registry.event.RegistryEntryAddEventImpl;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.util.ApiVersion;

public sealed interface RegistryEntryMeta<M, A extends Keyed> {
    public ResourceKey<? extends IRegistry<M>> mcKey();

    public RegistryKey<A> apiKey();

    public Registry<A> createApiRegistry(IRegistry<M> var1);

    default public RegistryModificationApiSupport modificationApiSupport() {
        return RegistryModificationApiSupport.NONE;
    }

    public static enum RegistryModificationApiSupport {
        NONE,
        ADDABLE,
        MODIFIABLE,
        WRITABLE;


        public boolean canAdd() {
            return this != MODIFIABLE && this != NONE;
        }

        public boolean canModify() {
            return this != ADDABLE && this != NONE;
        }
    }

    public record Buildable<M, A extends Keyed, B extends PaperRegistryBuilder<M, A>>(ResourceKey<? extends IRegistry<M>> mcKey, RegistryKey<A> apiKey, Class<?> classToPreload, RegistryTypeMapper<M, A> registryTypeMapper, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater, PaperRegistryBuilder.Filler<M, A, B> builderFiller, RegistryModificationApiSupport modificationApiSupport) implements ServerSide<M, A>
    {
        public RegistryEntryAddEventImpl<A, B> createEntryAddEvent(TypedKey<A> key, B initialBuilder, Conversions conversions) {
            return new RegistryEntryAddEventImpl<A, B>(key, initialBuilder, this.apiKey(), conversions);
        }

        public RegistryComposeEventImpl<A, B> createPostLoadEvent(WritableCraftRegistry<M, A, B> writableRegistry, Conversions conversions) {
            return new RegistryComposeEventImpl<A, B>(this.apiKey(), writableRegistry.createApiWritableRegistry(conversions), conversions);
        }

        @Override
        public Registry<A> createApiRegistry(IRegistry<M> nmsRegistry) {
            if (this.modificationApiSupport.canAdd()) {
                return new WritableCraftRegistry((RegistryMaterials)nmsRegistry, this);
            }
            return ServerSide.super.createApiRegistry(nmsRegistry);
        }
    }

    public record Craft<M, A extends Keyed>(ResourceKey<? extends IRegistry<M>> mcKey, RegistryKey<A> apiKey, Class<?> classToPreload, RegistryTypeMapper<M, A> registryTypeMapper, BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater) implements ServerSide<M, A>
    {
        public Craft {
            Preconditions.checkArgument((!classToPreload.getPackageName().startsWith("net.minecraft") ? 1 : 0) != 0, (String)"%s should not be in the net.minecraft package as the class-to-preload", classToPreload);
        }
    }

    public static sealed interface ServerSide<M, A extends Keyed>
    extends RegistryEntryMeta<M, A>
    permits Craft, Buildable {
        public Class<?> classToPreload();

        public RegistryTypeMapper<M, A> registryTypeMapper();

        public BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater();

        @Override
        default public Registry<A> createApiRegistry(IRegistry<M> nmsRegistry) {
            return new CraftRegistry(this, nmsRegistry);
        }
    }

    public record ApiOnly<M, A extends Keyed>(ResourceKey<? extends IRegistry<M>> mcKey, RegistryKey<A> apiKey, Supplier<Registry<A>> registrySupplier) implements RegistryEntryMeta<M, A>
    {
        @Override
        public Registry<A> createApiRegistry(IRegistry<M> nmsRegistry) {
            return this.registrySupplier.get();
        }
    }
}

