/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.entry;

import com.mojang.datafixers.util.Either;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Holder;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;

public final class RegistryTypeMapper<M, A> {
    final Either<Function<Holder<M>, ? extends A>, BiFunction<? super NamespacedKey, M, ? extends A>> minecraftToBukkit;
    private final boolean supportsDirectHolders;

    private static <M, A> Function<Holder<M>, ? extends A> wrap(BiFunction<? super NamespacedKey, M, ? extends A> byValueCreator) {
        return holder -> {
            if (!(holder instanceof Holder.c)) {
                throw new IllegalArgumentException("This type does not support direct holders: " + String.valueOf(holder));
            }
            Holder.c reference = (Holder.c)holder;
            return byValueCreator.apply(CraftNamespacedKey.fromResourceKey(reference.h()), reference.a());
        };
    }

    public RegistryTypeMapper(BiFunction<? super NamespacedKey, M, ? extends A> byValueCreator) {
        this.minecraftToBukkit = Either.right(byValueCreator);
        this.supportsDirectHolders = false;
    }

    public RegistryTypeMapper(Function<Holder<M>, ? extends A> byHolderCreator, boolean supportsDirectHolders) {
        this.minecraftToBukkit = Either.left(byHolderCreator);
        this.supportsDirectHolders = supportsDirectHolders;
    }

    public A createBukkit(Holder<M> minecraft) {
        return (A)this.minecraftToBukkit.map(Function.identity(), RegistryTypeMapper::wrap).apply(minecraft);
    }

    public boolean supportsDirectHolders() {
        return this.supportsDirectHolders;
    }

    public boolean constructorUsesHolder() {
        return this.minecraftToBukkit.left().isPresent();
    }
}

