/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Position;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.cow.AbstractCow;
import net.minecraft.world.entity.animal.cow.EntityMushroomCow;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFlowerPot;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R7.util.Waitable;

public final class MCUtil {
    public static final Executor MAIN_EXECUTOR = run -> {
        if (!MCUtil.isMainThread()) {
            MinecraftServer.getServer().execute(run);
        } else {
            run.run();
        }
    };
    public static final ExecutorService ASYNC_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setNameFormat("Paper Async Task Handler Thread - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.m)).build());

    private MCUtil() {
    }

    public static List<ChunkCoordIntPair> getSpiralOutChunks(BlockPosition blockposition, int radius) {
        ArrayList list = Lists.newArrayList();
        list.add(new ChunkCoordIntPair(blockposition.u() >> 4, blockposition.w() >> 4));
        for (int r2 = 1; r2 <= radius; ++r2) {
            int x2 = -r2;
            int z2 = r2;
            while (x2 <= r2 && z2 > -r2) {
                list.add(new ChunkCoordIntPair(blockposition.u() + (x2 << 4) >> 4, blockposition.w() + (z2 << 4) >> 4));
                list.add(new ChunkCoordIntPair(blockposition.u() - (x2 << 4) >> 4, blockposition.w() - (z2 << 4) >> 4));
                if (x2 < r2) {
                    ++x2;
                    continue;
                }
                --z2;
            }
        }
        return list;
    }

    public static <T> CompletableFuture<T> ensureMain(CompletableFuture<T> future) {
        return future.thenApplyAsync(r2 -> r2, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, Consumer<T> consumer) {
        future.thenAcceptAsync((Consumer)consumer, MAIN_EXECUTOR);
    }

    public static <T> void thenOnMain(CompletableFuture<T> future, BiConsumer<T, Throwable> consumer) {
        future.whenCompleteAsync((BiConsumer)consumer, MAIN_EXECUTOR);
    }

    public static boolean isMainThread() {
        return MinecraftServer.getServer().bK();
    }

    public static void ensureMain(Runnable run) {
        MCUtil.ensureMain(null, run);
    }

    public static void ensureMain(String reason, Runnable run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                MinecraftServer.m.warn("Asynchronous " + reason + "!", (Throwable)new IllegalStateException());
            }
            MinecraftServer.getServer().processQueue.add(run);
            return;
        }
        run.run();
    }

    public static <T> T ensureMain(Supplier<T> run) {
        return MCUtil.ensureMain(null, run);
    }

    public static <T> T ensureMain(String reason, final Supplier<T> run) {
        if (!MCUtil.isMainThread()) {
            if (reason != null) {
                MinecraftServer.m.warn("Asynchronous " + reason + "! Blocking thread until it returns ", (Throwable)new IllegalStateException());
            }
            Waitable wait = new Waitable<T>(){

                @Override
                protected T evaluate() {
                    return run.get();
                }
            };
            MinecraftServer.getServer().processQueue.add(wait);
            try {
                return wait.get();
            }
            catch (InterruptedException | ExecutionException e2) {
                MinecraftServer.m.warn("Encountered exception", (Throwable)e2);
                return null;
            }
        }
        return run.get();
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(MCUtil.distanceSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distanceSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2);
    }

    @Deprecated
    public static Location toLocation(World world, Vec3D pos) {
        return CraftLocation.toBukkit(pos, world);
    }

    @Deprecated
    public static Location toLocation(World world, Vec3D pos, float yaw, float pitch) {
        return CraftLocation.toBukkit(pos, world, yaw, pitch);
    }

    public static BlockPosition toBlockPos(Position pos) {
        return new BlockPosition(pos.blockX(), pos.blockY(), pos.blockZ());
    }

    public static FinePosition toPosition(Vec3D vector) {
        return Position.fine((double)vector.g, (double)vector.h, (double)vector.i);
    }

    public static io.papermc.paper.math.BlockPosition toPosition(BaseBlockPosition vector) {
        return Position.block((int)vector.u(), (int)vector.v(), (int)vector.w());
    }

    public static Vec3D toVec3(Position position) {
        return new Vec3D(position.x(), position.y(), position.z());
    }

    public static boolean isEdgeOfChunk(BlockPosition pos) {
        int modX = pos.u() & 0xF;
        int modZ = pos.w() & 0xF;
        return modX == 0 || modX == 15 || modZ == 0 || modZ == 15;
    }

    public static void scheduleAsyncTask(Runnable run) {
        ASYNC_EXECUTOR.execute(run);
    }

    public static <A, M> List<A> transformUnmodifiable(List<? extends M> nms, Function<? super M, ? extends A> converter) {
        return Collections.unmodifiableList(Lists.transform(nms, converter::apply));
    }

    public static <A, M> Collection<A> transformUnmodifiable(Collection<? extends M> nms, Function<? super M, ? extends A> converter) {
        return Collections.unmodifiableCollection(Collections2.transform(nms, converter::apply));
    }

    public static <A, M, C extends Collection<M>> void addAndConvert(C target, Collection<A> toAdd, Function<? super A, ? extends M> converter) {
        for (A value : toAdd) {
            target.add(converter.apply(value));
        }
    }

    public static boolean clientPredictsInteraction(EntityHuman player, IBlockData state, ItemStack stack) {
        BlockFlowerPot flowerPot;
        Block block = state.b();
        if (block instanceof BlockFlowerPot && !(flowerPot = (BlockFlowerPot)block).b().m().l()) {
            return true;
        }
        if (stack.N() <= 1 && !player.gv()) {
            return false;
        }
        if (state.a(TagsBlock.cz) && stack.h() instanceof ItemPotion && stack.a(DataComponents.Y, PotionContents.a).a(Potions.a)) {
            return true;
        }
        return state.a(Blocks.qq) && stack.a(Items.sG) || stack.h() instanceof ItemBucket || stack.a(Items.uo);
    }

    public static boolean clientPredictsInteraction(EntityHuman player, Entity entity, ItemStack stack) {
        if (stack.N() <= 1 && !player.gv()) {
            return false;
        }
        return entity instanceof AbstractCow && stack.a(Items.sk) || entity instanceof EntityMushroomCow && stack.a(Items.pU) || entity instanceof Bucketable && stack.a(Items.sl);
    }
}

