/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world;

import com.google.common.io.Files;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.Main;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.validation.ContentValidationException;
import org.apache.commons.io.FileUtils;
import org.bukkit.World;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public record PaperWorldLoader(MinecraftServer server, String levelId) {
    private static final Logger LOGGER = LogUtils.getClassLogger();

    public static PaperWorldLoader create(MinecraftServer server, String levelId) {
        return new PaperWorldLoader(server, levelId);
    }

    private WorldLoadingInfo getWorldInfo(String levelId, WorldDimension stem) {
        ResourceKey<WorldDimension> stemKey = this.server.bc().f(Registries.bF).d(stem).orElseThrow();
        int dimension = 0;
        boolean enabled = true;
        if (stemKey == WorldDimension.c) {
            dimension = -1;
            enabled = this.server.server.getAllowNether();
        } else if (stemKey == WorldDimension.d) {
            dimension = 1;
            enabled = this.server.server.getAllowEnd();
        } else if (stemKey != WorldDimension.b) {
            dimension = -999;
        }
        String worldType = dimension == -999 ? stemKey.a().b() + "_" + stemKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
        String name = stemKey == WorldDimension.b ? levelId : levelId + "_" + worldType;
        return new WorldLoadingInfo(dimension, name, worldType, stemKey, enabled);
    }

    private void migrateWorldFolder(WorldLoadingInfo info) {
        if (info.dimension() == 0) {
            return;
        }
        File newWorld = Convertable.getStorageFolder(new File(info.name()).toPath(), info.stemKey()).toFile();
        File oldWorld = Convertable.getStorageFolder(new File(this.levelId).toPath(), info.stemKey()).toFile();
        File oldLevelDat = new File(new File(this.levelId), "level.dat");
        if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
            LOGGER.info("---- Migration of old " + info.worldType() + " folder required ----");
            LOGGER.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + info.worldType() + " folder to a new location in order to operate correctly.");
            LOGGER.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
            LOGGER.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
            if (newWorld.exists()) {
                LOGGER.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                LOGGER.info("---- Migration of old " + info.worldType() + " folder failed ----");
            } else if (newWorld.getParentFile().mkdirs()) {
                if (oldWorld.renameTo(newWorld)) {
                    LOGGER.info("Success! To restore " + info.worldType() + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                    try {
                        Files.copy((File)oldLevelDat, (File)new File(new File(info.name()), "level.dat"));
                        FileUtils.copyDirectory((File)new File(new File(this.levelId), "data"), (File)new File(new File(info.name()), "data"));
                    }
                    catch (IOException exception) {
                        LOGGER.warn("Unable to migrate world data.");
                    }
                    LOGGER.info("---- Migration of old " + info.worldType() + " folder complete ----");
                } else {
                    LOGGER.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                    LOGGER.info("---- Migration of old " + info.worldType() + " folder failed ----");
                }
            } else {
                LOGGER.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                LOGGER.info("---- Migration of old " + info.worldType() + " folder failed ----");
            }
        }
    }

    public void loadInitialWorlds() {
        for (WorldDimension stem : this.server.bc().f(Registries.bF)) {
            WorldLoadingInfo info = this.getWorldInfo(this.levelId, stem);
            this.migrateWorldFolder(info);
            if (!info.enabled()) continue;
            Convertable.ConversionSession levelStorageAccess = this.server.g;
            if (info.dimension() != 0) {
                try {
                    levelStorageAccess = Convertable.b(this.server.server.getWorldContainer().toPath()).validateAndCreateAccess(info.name(), info.stemKey());
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            LevelDataResult levelData = PaperWorldLoader.getLevelData(levelStorageAccess);
            if (levelData.fatalError) {
                return;
            }
            WorldDataServer primaryLevelData = levelData.dataTag == null ? (WorldDataServer)Main.a(((DedicatedServer)this.server).t, this.server.worldLoaderContext, this.server.worldLoaderContext.d().f(Registries.bF), this.server.aa(), this.server.options.has("bonusChest")).a() : (WorldDataServer)Convertable.a(levelData.dataTag, this.server.worldLoaderContext.b(), this.server.worldLoaderContext.d().f(Registries.bF), this.server.worldLoaderContext.c()).a();
            primaryLevelData.checkName(info.name());
            primaryLevelData.a(this.server.getServerModName(), this.server.T().a());
            if (this.server.options.has("forceUpgrade")) {
                Main.a(levelStorageAccess, primaryLevelData, DataConverterRegistry.a(), this.server.options.has("eraseCache"), () -> true, this.server.bc(), this.server.options.has("recreateRegionFiles"));
            }
            this.server.createLevel(stem, info, levelStorageAccess, primaryLevelData);
        }
        ((DedicatedServer)this.server).t();
        for (WorldServer serverLevel : this.server.P()) {
            this.server.prepareLevel(serverLevel);
        }
    }

    public static LevelDataResult getLevelData(Convertable.ConversionSession levelStorageAccess) {
        Dynamic<?> dataTag;
        if (levelStorageAccess.m()) {
            WorldInfo summary;
            try {
                dataTag = levelStorageAccess.h();
                summary = levelStorageAccess.a(dataTag);
            }
            catch (IOException | NbtException | ReportedNbtException var41) {
                Convertable.b levelDirectory = levelStorageAccess.e();
                LOGGER.warn("Failed to load world data from {}", (Object)levelDirectory.b(), (Object)var41);
                LOGGER.info("Attempting to use fallback");
                try {
                    dataTag = levelStorageAccess.i();
                    summary = levelStorageAccess.a(dataTag);
                }
                catch (IOException | NbtException | ReportedNbtException var40) {
                    LOGGER.error("Failed to load world data from {}", (Object)levelDirectory.c(), (Object)var40);
                    LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)levelDirectory.b(), (Object)levelDirectory.c());
                    return new LevelDataResult(null, true);
                }
                levelStorageAccess.n();
            }
            if (summary.d()) {
                LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                return new LevelDataResult(null, true);
            }
            if (!summary.r()) {
                LOGGER.info("This world was created by an incompatible version.");
                return new LevelDataResult(null, true);
            }
        } else {
            return new LevelDataResult(null, false);
        }
        return new LevelDataResult(dataTag, false);
    }

    public record WorldLoadingInfo(int dimension, String name, String worldType, ResourceKey<WorldDimension> stemKey, boolean enabled) {
    }

    public record LevelDataResult(@Nullable Dynamic<?> dataTag, boolean fatalError) {
    }
}

