/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world.damagesource;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.world.damagesource.CombatEntry;
import io.papermc.paper.world.damagesource.CombatTracker;
import io.papermc.paper.world.damagesource.FallLocationType;
import io.papermc.paper.world.damagesource.PaperCombatEntryWrapper;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.Optionull;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.damagesource.FallLocation;
import org.bukkit.entity.LivingEntity;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record PaperCombatTrackerWrapper(net.minecraft.world.damagesource.CombatTracker handle) implements CombatTracker
{
    private static final BiMap<FallLocation, FallLocationType> FALL_LOCATION_MAPPING = SystemUtils.a(() -> {
        HashBiMap map = HashBiMap.create((int)8);
        map.put((Object)FallLocation.a, (Object)FallLocationType.GENERIC);
        map.put((Object)FallLocation.b, (Object)FallLocationType.LADDER);
        map.put((Object)FallLocation.c, (Object)FallLocationType.VINES);
        map.put((Object)FallLocation.d, (Object)FallLocationType.WEEPING_VINES);
        map.put((Object)FallLocation.e, (Object)FallLocationType.TWISTING_VINES);
        map.put((Object)FallLocation.f, (Object)FallLocationType.SCAFFOLDING);
        map.put((Object)FallLocation.g, (Object)FallLocationType.OTHER_CLIMBABLE);
        map.put((Object)FallLocation.h, (Object)FallLocationType.WATER);
        return map;
    });

    public LivingEntity getEntity() {
        return this.handle.e.getBukkitLivingEntity();
    }

    public List<CombatEntry> getCombatEntries() {
        ArrayList<CombatEntry> combatEntries = new ArrayList<CombatEntry>(this.handle.d.size());
        this.handle.d.forEach(combatEntry -> combatEntries.add(new PaperCombatEntryWrapper((net.minecraft.world.damagesource.CombatEntry)combatEntry)));
        return combatEntries;
    }

    public void setCombatEntries(List<CombatEntry> combatEntries) {
        this.handle.d.clear();
        combatEntries.forEach(combatEntry -> this.handle.d.add(((PaperCombatEntryWrapper)combatEntry).handle()));
    }

    public @Nullable CombatEntry computeMostSignificantFall() {
        net.minecraft.world.damagesource.CombatEntry combatEntry = this.handle.d();
        return combatEntry == null ? null : new PaperCombatEntryWrapper(combatEntry);
    }

    public boolean isInCombat() {
        return this.handle.i;
    }

    public boolean isTakingDamage() {
        return this.handle.j;
    }

    public int getCombatDuration() {
        return this.handle.b();
    }

    public void addCombatEntry(CombatEntry combatEntry) {
        net.minecraft.world.damagesource.CombatEntry entry = ((PaperCombatEntryWrapper)combatEntry).handle();
        this.handle.recordDamageAndCheckCombatState(entry);
    }

    public Component getDeathMessage() {
        return PaperAdventure.asAdventure(this.handle.a());
    }

    public void resetCombatState() {
        this.handle.resetCombatState();
    }

    public FallLocationType calculateFallLocationType() {
        FallLocation fallLocation = FallLocation.a(this.handle().e);
        return Optionull.a(fallLocation, PaperCombatTrackerWrapper::minecraftToPaper);
    }

    public static FallLocation paperToMinecraft(FallLocationType fallLocationType) {
        FallLocation fallLocation = (FallLocation)FALL_LOCATION_MAPPING.inverse().get((Object)fallLocationType);
        if (fallLocation == null) {
            throw new IllegalArgumentException("Unknown fall location type: " + fallLocationType.id());
        }
        return fallLocation;
    }

    public static FallLocationType minecraftToPaper(FallLocation fallLocation) {
        FallLocationType fallLocationType = (FallLocationType)FALL_LOCATION_MAPPING.get((Object)fallLocation);
        if (fallLocationType == null) {
            throw new IllegalArgumentException("Unknown fall location: " + fallLocation.b());
        }
        return fallLocationType;
    }
}

