/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionConditionDistance;
import net.minecraft.advancements.criterion.CriterionConditionEntityEquipment;
import net.minecraft.advancements.criterion.CriterionConditionEntityFlags;
import net.minecraft.advancements.criterion.CriterionConditionEntityType;
import net.minecraft.advancements.criterion.CriterionConditionLocation;
import net.minecraft.advancements.criterion.CriterionConditionMobEffect;
import net.minecraft.advancements.criterion.CriterionConditionNBT;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.advancements.criterion.EntitySubPredicate;
import net.minecraft.advancements.criterion.MovementPredicate;
import net.minecraft.advancements.criterion.SlotsPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.jspecify.annotations.Nullable;

public final class CriterionConditionEntity
extends Record {
    private final Optional<CriterionConditionEntityType> c;
    private final Optional<CriterionConditionDistance> d;
    private final Optional<MovementPredicate> e;
    private final b f;
    private final Optional<CriterionConditionMobEffect> g;
    private final Optional<CriterionConditionNBT> h;
    private final Optional<CriterionConditionEntityFlags> i;
    private final Optional<CriterionConditionEntityEquipment> j;
    private final Optional<EntitySubPredicate> k;
    private final Optional<Integer> l;
    private final Optional<CriterionConditionEntity> m;
    private final Optional<CriterionConditionEntity> n;
    private final Optional<CriterionConditionEntity> o;
    private final Optional<String> p;
    private final Optional<SlotsPredicate> q;
    private final DataComponentMatchers r;
    public static final Codec<CriterionConditionEntity> a = Codec.recursive((String)"EntityPredicate", codec -> RecordCodecBuilder.create(instance -> instance.group((App)CriterionConditionEntityType.a.optionalFieldOf("type").forGetter(CriterionConditionEntity::a), (App)CriterionConditionDistance.a.optionalFieldOf("distance").forGetter(CriterionConditionEntity::b), (App)MovementPredicate.a.optionalFieldOf("movement").forGetter(CriterionConditionEntity::c), (App)net.minecraft.advancements.criterion.CriterionConditionEntity$b.a.forGetter(CriterionConditionEntity::d), (App)CriterionConditionMobEffect.a.optionalFieldOf("effects").forGetter(CriterionConditionEntity::e), (App)CriterionConditionNBT.a.optionalFieldOf("nbt").forGetter(CriterionConditionEntity::f), (App)CriterionConditionEntityFlags.a.optionalFieldOf("flags").forGetter(CriterionConditionEntity::g), (App)CriterionConditionEntityEquipment.a.optionalFieldOf("equipment").forGetter(CriterionConditionEntity::h), (App)EntitySubPredicate.a.optionalFieldOf("type_specific").forGetter(CriterionConditionEntity::i), (App)ExtraCodecs.r.optionalFieldOf("periodic_tick").forGetter(CriterionConditionEntity::j), (App)codec.optionalFieldOf("vehicle").forGetter(CriterionConditionEntity::k), (App)codec.optionalFieldOf("passenger").forGetter(CriterionConditionEntity::l), (App)codec.optionalFieldOf("targeted_entity").forGetter(CriterionConditionEntity::m), (App)Codec.STRING.optionalFieldOf("team").forGetter(CriterionConditionEntity::n), (App)SlotsPredicate.a.optionalFieldOf("slots").forGetter(CriterionConditionEntity::o), (App)DataComponentMatchers.b.forGetter(CriterionConditionEntity::p)).apply((Applicative)instance, CriterionConditionEntity::new)));
    public static final Codec<ContextAwarePredicate> b = Codec.withAlternative(ContextAwarePredicate.a, a, CriterionConditionEntity::a);

    public CriterionConditionEntity(Optional<CriterionConditionEntityType> entityType, Optional<CriterionConditionDistance> distanceToPlayer, Optional<MovementPredicate> movement, b location, Optional<CriterionConditionMobEffect> effects, Optional<CriterionConditionNBT> nbt, Optional<CriterionConditionEntityFlags> flags, Optional<CriterionConditionEntityEquipment> equipment, Optional<EntitySubPredicate> subPredicate, Optional<Integer> periodicTick, Optional<CriterionConditionEntity> vehicle, Optional<CriterionConditionEntity> passenger, Optional<CriterionConditionEntity> targetedEntity, Optional<String> team, Optional<SlotsPredicate> slots, DataComponentMatchers components) {
        this.c = entityType;
        this.d = distanceToPlayer;
        this.e = movement;
        this.f = location;
        this.g = effects;
        this.h = nbt;
        this.i = flags;
        this.j = equipment;
        this.k = subPredicate;
        this.l = periodicTick;
        this.m = vehicle;
        this.n = passenger;
        this.o = targetedEntity;
        this.p = team;
        this.q = slots;
        this.r = components;
    }

    public static ContextAwarePredicate a(a builder) {
        return CriterionConditionEntity.a(builder.b());
    }

    public static Optional<ContextAwarePredicate> a(Optional<CriterionConditionEntity> predicate) {
        return predicate.map(CriterionConditionEntity::a);
    }

    public static List<ContextAwarePredicate> a(a ... builders) {
        return Stream.of(builders).map(CriterionConditionEntity::a).toList();
    }

    public static ContextAwarePredicate a(CriterionConditionEntity predicate) {
        LootItemCondition lootItemCondition = LootItemConditionEntityProperty.a(LootTableInfo.EntityTarget.a, predicate).build();
        return new ContextAwarePredicate(List.of(lootItemCondition));
    }

    public boolean a(EntityPlayer player, @Nullable Entity entity) {
        return this.a(player.A(), player.dI(), entity);
    }

    public boolean a(WorldServer level, @Nullable Vec3D position, @Nullable Entity entity) {
        ScoreboardTeam team;
        Vec3D knownMovement;
        if (entity == null) {
            return false;
        }
        if (this.c.isPresent() && !this.c.get().a(entity.ay())) {
            return false;
        }
        if (position == null ? this.d.isPresent() : this.d.isPresent() && !this.d.get().a(position.g, position.h, position.i, entity.dP(), entity.dR(), entity.dV())) {
            return false;
        }
        if (this.e.isPresent()) {
            knownMovement = entity.ag();
            Vec3D vec3 = knownMovement.c(20.0);
            if (!this.e.get().a(vec3.g, vec3.h, vec3.i, entity.an)) {
                return false;
            }
        }
        if (this.f.b.isPresent() && !this.f.b.get().a(level, entity.dP(), entity.dR(), entity.dV())) {
            return false;
        }
        if (this.f.c.isPresent()) {
            knownMovement = Vec3D.b(entity.bg());
            if (!entity.aV() || !this.f.c.get().a(level, knownMovement.a(), knownMovement.b(), knownMovement.c())) {
                return false;
            }
        }
        if (this.f.d.isPresent()) {
            knownMovement = Vec3D.b(entity.bf());
            if (!this.f.d.get().a(level, knownMovement.a(), knownMovement.b(), knownMovement.c())) {
                return false;
            }
        }
        if (this.g.isPresent() && !this.g.get().a(entity)) {
            return false;
        }
        if (this.i.isPresent() && !this.i.get().a(entity)) {
            return false;
        }
        if (this.j.isPresent() && !this.j.get().a(entity)) {
            return false;
        }
        if (this.k.isPresent() && !this.k.get().a(entity, level, position)) {
            return false;
        }
        if (this.m.isPresent() && !this.m.get().a(level, position, entity.dz())) {
            return false;
        }
        if (this.n.isPresent() && entity.dn().stream().noneMatch(entity1 -> this.n.get().a(level, position, (Entity)entity1))) {
            return false;
        }
        if (this.o.isPresent() && !this.o.get().a(level, position, entity instanceof EntityInsentient ? ((EntityInsentient)entity).ag_() : null)) {
            return false;
        }
        if (this.l.isPresent() && entity.at % this.l.get() != 0) {
            return false;
        }
        if (this.p.isPresent() && ((team = entity.cI()) == null || !this.p.get().equals(((ScoreboardTeamBase)team).c()))) {
            return false;
        }
        return !(this.q.isPresent() && !this.q.get().a(entity) || !this.r.a(entity) || !this.h.isEmpty() && !this.h.get().a(entity));
    }

    public static LootTableInfo b(EntityPlayer player, Entity entity) {
        LootParams lootParams = new LootParams.a(player.A()).a(LootContextParameters.a, entity).a(LootContextParameters.h, player.dI()).a(LootContextParameterSets.n);
        return new LootTableInfo.Builder(lootParams).a(Optional.empty());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;movement;location;effects;nbt;flags;equipment;subPredicate;periodicTick;vehicle;passenger;targetedEntity;team;slots;components", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;movement;location;effects;nbt;flags;equipment;subPredicate;periodicTick;vehicle;passenger;targetedEntity;team;slots;components", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CriterionConditionEntity.class, "entityType;distanceToPlayer;movement;location;effects;nbt;flags;equipment;subPredicate;periodicTick;vehicle;passenger;targetedEntity;team;slots;components", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r"}, this, o2);
    }

    public Optional<CriterionConditionEntityType> a() {
        return this.c;
    }

    public Optional<CriterionConditionDistance> b() {
        return this.d;
    }

    public Optional<MovementPredicate> c() {
        return this.e;
    }

    public b d() {
        return this.f;
    }

    public Optional<CriterionConditionMobEffect> e() {
        return this.g;
    }

    public Optional<CriterionConditionNBT> f() {
        return this.h;
    }

    public Optional<CriterionConditionEntityFlags> g() {
        return this.i;
    }

    public Optional<CriterionConditionEntityEquipment> h() {
        return this.j;
    }

    public Optional<EntitySubPredicate> i() {
        return this.k;
    }

    public Optional<Integer> j() {
        return this.l;
    }

    public Optional<CriterionConditionEntity> k() {
        return this.m;
    }

    public Optional<CriterionConditionEntity> l() {
        return this.n;
    }

    public Optional<CriterionConditionEntity> m() {
        return this.o;
    }

    public Optional<String> n() {
        return this.p;
    }

    public Optional<SlotsPredicate> o() {
        return this.q;
    }

    public DataComponentMatchers p() {
        return this.r;
    }

    public static final class b
    extends Record {
        private final Optional<CriterionConditionLocation> b;
        private final Optional<CriterionConditionLocation> c;
        private final Optional<CriterionConditionLocation> d;
        public static final MapCodec<b> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CriterionConditionLocation.a.optionalFieldOf("location").forGetter(b::a), (App)CriterionConditionLocation.a.optionalFieldOf("stepping_on").forGetter(b::b), (App)CriterionConditionLocation.a.optionalFieldOf("movement_affected_by").forGetter(b::c)).apply((Applicative)instance, b::new));

        public b(Optional<CriterionConditionLocation> located, Optional<CriterionConditionLocation> steppingOn, Optional<CriterionConditionLocation> affectsMovement) {
            this.b = located;
            this.c = steppingOn;
            this.d = affectsMovement;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "located;steppingOn;affectsMovement", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "located;steppingOn;affectsMovement", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "located;steppingOn;affectsMovement", "b", "c", "d"}, this, o2);
        }

        public Optional<CriterionConditionLocation> a() {
            return this.b;
        }

        public Optional<CriterionConditionLocation> b() {
            return this.c;
        }

        public Optional<CriterionConditionLocation> c() {
            return this.d;
        }
    }

    public static class a {
        private Optional<CriterionConditionEntityType> a = Optional.empty();
        private Optional<CriterionConditionDistance> b = Optional.empty();
        private Optional<MovementPredicate> c = Optional.empty();
        private Optional<CriterionConditionLocation> d = Optional.empty();
        private Optional<CriterionConditionLocation> e = Optional.empty();
        private Optional<CriterionConditionLocation> f = Optional.empty();
        private Optional<CriterionConditionMobEffect> g = Optional.empty();
        private Optional<CriterionConditionNBT> h = Optional.empty();
        private Optional<CriterionConditionEntityFlags> i = Optional.empty();
        private Optional<CriterionConditionEntityEquipment> j = Optional.empty();
        private Optional<EntitySubPredicate> k = Optional.empty();
        private Optional<Integer> l = Optional.empty();
        private Optional<CriterionConditionEntity> m = Optional.empty();
        private Optional<CriterionConditionEntity> n = Optional.empty();
        private Optional<CriterionConditionEntity> o = Optional.empty();
        private Optional<String> p = Optional.empty();
        private Optional<SlotsPredicate> q = Optional.empty();
        private DataComponentMatchers r = DataComponentMatchers.a;

        public static a a() {
            return new a();
        }

        public a a(HolderGetter<EntityTypes<?>> entityTypeRegistry, EntityTypes<?> entityType) {
            this.a = Optional.of(CriterionConditionEntityType.a(entityTypeRegistry, entityType));
            return this;
        }

        public a a(HolderGetter<EntityTypes<?>> entityTypeRegistry, TagKey<EntityTypes<?>> entityTypeTag) {
            this.a = Optional.of(CriterionConditionEntityType.a(entityTypeRegistry, entityTypeTag));
            return this;
        }

        public a a(CriterionConditionEntityType entityType) {
            this.a = Optional.of(entityType);
            return this;
        }

        public a a(CriterionConditionDistance distanceToPlayer) {
            this.b = Optional.of(distanceToPlayer);
            return this;
        }

        public a a(MovementPredicate movement) {
            this.c = Optional.of(movement);
            return this;
        }

        public a a(CriterionConditionLocation.a location) {
            this.d = Optional.of(location.b());
            return this;
        }

        public a b(CriterionConditionLocation.a steppingOnLocation) {
            this.e = Optional.of(steppingOnLocation.b());
            return this;
        }

        public a c(CriterionConditionLocation.a movementAffectedBy) {
            this.f = Optional.of(movementAffectedBy.b());
            return this;
        }

        public a a(CriterionConditionMobEffect.a effects) {
            this.g = effects.b();
            return this;
        }

        public a a(CriterionConditionNBT nbt) {
            this.h = Optional.of(nbt);
            return this;
        }

        public a a(CriterionConditionEntityFlags.a flags) {
            this.i = Optional.of(flags.b());
            return this;
        }

        public a a(CriterionConditionEntityEquipment.a equipment) {
            this.j = Optional.of(equipment.b());
            return this;
        }

        public a a(CriterionConditionEntityEquipment equipment) {
            this.j = Optional.of(equipment);
            return this;
        }

        public a a(EntitySubPredicate subPredicate) {
            this.k = Optional.of(subPredicate);
            return this;
        }

        public a a(int periodicTick) {
            this.l = Optional.of(periodicTick);
            return this;
        }

        public a a(a vehicle) {
            this.m = Optional.of(vehicle.b());
            return this;
        }

        public a b(a passenger) {
            this.n = Optional.of(passenger.b());
            return this;
        }

        public a c(a targetedEntity) {
            this.o = Optional.of(targetedEntity.b());
            return this;
        }

        public a a(String team) {
            this.p = Optional.of(team);
            return this;
        }

        public a a(SlotsPredicate slots) {
            this.q = Optional.of(slots);
            return this;
        }

        public a a(DataComponentMatchers components) {
            this.r = components;
            return this;
        }

        public CriterionConditionEntity b() {
            return new CriterionConditionEntity(this.a, this.b, this.c, new b(this.d, this.e, this.f), this.g, this.h, this.i, this.j, this.k, this.l, this.m, this.n, this.o, this.p, this.q, this.r);
        }
    }
}

