/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.advancements.criterion.EntitySubPredicate;
import net.minecraft.advancements.criterion.EntitySubPredicates;
import net.minecraft.advancements.criterion.GameTypePredicate;
import net.minecraft.advancements.criterion.InputPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticManager;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public final class CriterionConditionPlayer
extends Record
implements EntitySubPredicate {
    private final CriterionConditionValue.IntegerRange d;
    private final GameTypePredicate e;
    private final List<e<?>> f;
    private final Object2BooleanMap<ResourceKey<IRecipe<?>>> g;
    private final Map<MinecraftKey, c> h;
    private final Optional<CriterionConditionEntity> i;
    private final Optional<InputPredicate> j;
    public static final int b = 100;
    public static final MapCodec<CriterionConditionPlayer> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CriterionConditionValue.IntegerRange.d.optionalFieldOf("level", (Object)CriterionConditionValue.IntegerRange.c).forGetter(CriterionConditionPlayer::b), (App)GameTypePredicate.c.optionalFieldOf("gamemode", (Object)GameTypePredicate.a).forGetter(CriterionConditionPlayer::c), (App)net.minecraft.advancements.criterion.CriterionConditionPlayer$e.a.listOf().optionalFieldOf("stats", List.of()).forGetter(CriterionConditionPlayer::d), (App)ExtraCodecs.f(IRecipe.b).optionalFieldOf("recipes", (Object)Object2BooleanMaps.emptyMap()).forGetter(CriterionConditionPlayer::e), (App)Codec.unboundedMap(MinecraftKey.a, net.minecraft.advancements.criterion.CriterionConditionPlayer$c.b).optionalFieldOf("advancements", Map.of()).forGetter(CriterionConditionPlayer::f), (App)CriterionConditionEntity.a.optionalFieldOf("looking_at").forGetter(CriterionConditionPlayer::g), (App)InputPredicate.a.optionalFieldOf("input").forGetter(CriterionConditionPlayer::h)).apply((Applicative)instance, CriterionConditionPlayer::new));

    public CriterionConditionPlayer(CriterionConditionValue.IntegerRange level, GameTypePredicate gameType, List<e<?>> stats, Object2BooleanMap<ResourceKey<IRecipe<?>>> recipes, Map<MinecraftKey, c> advancements, Optional<CriterionConditionEntity> lookingAt, Optional<InputPredicate> input) {
        this.d = level;
        this.e = gameType;
        this.f = stats;
        this.g = recipes;
        this.h = advancements;
        this.i = lookingAt;
        this.j = input;
    }

    @Override
    public boolean a(Entity entity, WorldServer level, @Nullable Vec3D position) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer serverPlayer = (EntityPlayer)entity;
        if (!this.d.d(serverPlayer.cs)) {
            return false;
        }
        if (!this.e.a(serverPlayer.a())) {
            return false;
        }
        ServerStatisticManager stats = serverPlayer.K();
        for (e<?> e2 : this.f) {
            if (e2.a(stats)) continue;
            return false;
        }
        RecipeBookServer recipeBook = serverPlayer.L();
        for (Object2BooleanMap.Entry entry : this.g.object2BooleanEntrySet()) {
            if (recipeBook.b((ResourceKey)entry.getKey()) == entry.getBooleanValue()) continue;
            return false;
        }
        if (!this.h.isEmpty()) {
            AdvancementDataPlayer advancementDataPlayer = serverPlayer.U();
            AdvancementDataWorld advancements1 = serverPlayer.A().s().aB();
            for (Map.Entry<MinecraftKey, c> entry1 : this.h.entrySet()) {
                AdvancementHolder advancementHolder = advancements1.a(entry1.getKey());
                if (advancementHolder != null && entry1.getValue().test(advancementDataPlayer.b(advancementHolder))) continue;
                return false;
            }
        }
        if (this.i.isPresent()) {
            Vec3D vec3D = serverPlayer.bV();
            Vec3D viewVector = serverPlayer.h(1.0f);
            Vec3D vec3 = vec3D.b(viewVector.g * 100.0, viewVector.h * 100.0, viewVector.i * 100.0);
            MovingObjectPositionEntity entityHitResult = ProjectileHelper.a((World)serverPlayer.A(), (Entity)serverPlayer, vec3D, vec3, new AxisAlignedBB(vec3D, vec3).g(1.0), entity2 -> !entity2.au(), 0.0f);
            if (entityHitResult == null || entityHitResult.d() != MovingObjectPosition.EnumMovingObjectType.c) {
                return false;
            }
            Entity entity1 = entityHitResult.a();
            if (!this.i.get().a(serverPlayer, entity1) || !serverPlayer.G(entity1)) {
                return false;
            }
        }
        return !this.j.isPresent() || this.j.get().a(serverPlayer.ai());
    }

    public MapCodec<CriterionConditionPlayer> a() {
        return EntitySubPredicates.c;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{CriterionConditionPlayer.class, "level;gameType;stats;recipes;advancements;lookingAt;input", "d", "e", "f", "g", "h", "i", "j"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CriterionConditionPlayer.class, "level;gameType;stats;recipes;advancements;lookingAt;input", "d", "e", "f", "g", "h", "i", "j"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CriterionConditionPlayer.class, "level;gameType;stats;recipes;advancements;lookingAt;input", "d", "e", "f", "g", "h", "i", "j"}, this, o2);
    }

    public CriterionConditionValue.IntegerRange b() {
        return this.d;
    }

    public GameTypePredicate c() {
        return this.e;
    }

    public List<e<?>> d() {
        return this.f;
    }

    public Object2BooleanMap<ResourceKey<IRecipe<?>>> e() {
        return this.g;
    }

    public Map<MinecraftKey, c> f() {
        return this.h;
    }

    public Optional<CriterionConditionEntity> g() {
        return this.i;
    }

    public Optional<InputPredicate> h() {
        return this.j;
    }

    static final class e<T>
    extends Record {
        private final StatisticWrapper<T> b;
        private final Holder<T> c;
        private final CriterionConditionValue.IntegerRange d;
        private final Supplier<Statistic<T>> e;
        public static final Codec<e<?>> a = BuiltInRegistries.w.q().dispatch(e::a, e::a);

        public e(StatisticWrapper<T> type, Holder<T> value, CriterionConditionValue.IntegerRange range) {
            this(type, value, range, (Supplier<Statistic<T>>)Suppliers.memoize(() -> type.b(value.a())));
        }

        e(StatisticWrapper<T> type, Holder<T> value, CriterionConditionValue.IntegerRange range, Supplier<Statistic<T>> stat) {
            this.b = type;
            this.c = value;
            this.d = range;
            this.e = stat;
        }

        private static <T> MapCodec<e<T>> a(StatisticWrapper<T> statType) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)statType.b().r().fieldOf("stat").forGetter(e::b), (App)CriterionConditionValue.IntegerRange.d.optionalFieldOf("value", (Object)CriterionConditionValue.IntegerRange.c).forGetter(e::c)).apply((Applicative)instance, (holder, ints) -> new e(statType, holder, (CriterionConditionValue.IntegerRange)ints)));
        }

        public boolean a(StatisticManager statsCounter) {
            return this.d.d(statsCounter.a(this.e.get()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "type;value;range;stat", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "type;value;range;stat", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "type;value;range;stat", "b", "c", "d", "e"}, this, o2);
        }

        public StatisticWrapper<T> a() {
            return this.b;
        }

        public Holder<T> b() {
            return this.c;
        }

        public CriterionConditionValue.IntegerRange c() {
            return this.d;
        }

        public Supplier<Statistic<T>> d() {
            return this.e;
        }
    }

    static interface c
    extends Predicate<AdvancementProgress> {
        public static final Codec<c> b = Codec.either(net.minecraft.advancements.criterion.CriterionConditionPlayer$b.a, a.a).xmap(Either::unwrap, advancementPredicate -> {
            if (advancementPredicate instanceof b) {
                b advancementDonePredicate = (b)advancementPredicate;
                return Either.left(advancementDonePredicate);
            }
            if (advancementPredicate instanceof a) {
                a advancementCriterionsPredicate = (a)advancementPredicate;
                return Either.right(advancementCriterionsPredicate);
            }
            throw new UnsupportedOperationException();
        });
    }

    public static class d {
        private CriterionConditionValue.IntegerRange a = CriterionConditionValue.IntegerRange.c;
        private GameTypePredicate b = GameTypePredicate.a;
        private final ImmutableList.Builder<e<?>> c = ImmutableList.builder();
        private final Object2BooleanMap<ResourceKey<IRecipe<?>>> d = new Object2BooleanOpenHashMap();
        private final Map<MinecraftKey, c> e = Maps.newHashMap();
        private Optional<CriterionConditionEntity> f = Optional.empty();
        private Optional<InputPredicate> g = Optional.empty();

        public static d a() {
            return new d();
        }

        public d a(CriterionConditionValue.IntegerRange level) {
            this.a = level;
            return this;
        }

        public <T> d a(StatisticWrapper<T> type, Holder.c<T> value, CriterionConditionValue.IntegerRange range) {
            this.c.add(new e<T>(type, value, range));
            return this;
        }

        public d a(ResourceKey<IRecipe<?>> recipe, boolean unlocked) {
            this.d.put(recipe, unlocked);
            return this;
        }

        public d a(GameTypePredicate gameType) {
            this.b = gameType;
            return this;
        }

        public d a(CriterionConditionEntity.a lookingAt) {
            this.f = Optional.of(lookingAt.b());
            return this;
        }

        public d a(MinecraftKey advancement, boolean done) {
            this.e.put(advancement, new b(done));
            return this;
        }

        public d a(MinecraftKey advancement, Map<String, Boolean> criterions) {
            this.e.put(advancement, new a((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(criterions)));
            return this;
        }

        public d a(InputPredicate input) {
            this.g = Optional.of(input);
            return this;
        }

        public CriterionConditionPlayer b() {
            return new CriterionConditionPlayer(this.a, this.b, (List<e<?>>)this.c.build(), this.d, this.e, this.f, this.g);
        }
    }

    static final class b
    extends Record
    implements c {
        private final boolean c;
        public static final Codec<b> a = Codec.BOOL.xmap(b::new, b::a);

        b(boolean state) {
            this.c = state;
        }

        public boolean a(AdvancementProgress progress) {
            return progress.a() == this.c;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "state", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "state", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "state", "c"}, this, o2);
        }

        public boolean a() {
            return this.c;
        }
    }

    static final class a
    extends Record
    implements c {
        private final Object2BooleanMap<String> c;
        public static final Codec<a> a = ExtraCodecs.f(Codec.STRING).xmap(a::new, a::a);

        a(Object2BooleanMap<String> criterions) {
            this.c = criterions;
        }

        public boolean a(AdvancementProgress progress) {
            for (Object2BooleanMap.Entry entry : this.c.object2BooleanEntrySet()) {
                CriterionProgress criterion = progress.c((String)entry.getKey());
                if (criterion != null && criterion.a() == entry.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "criterions", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "criterions", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "criterions", "c"}, this, o2);
        }

        public Object2BooleanMap<String> a() {
            return this.c;
        }
    }
}

