/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;

public interface CriterionConditionValue<T extends Number> {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.range.empty"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.range.swapped"));

    public a<T> a();

    default public Optional<T> b() {
        return this.a().a;
    }

    default public Optional<T> c() {
        return this.a().b;
    }

    default public boolean d() {
        return this.a().a();
    }

    public record a<T extends Number>(Optional<T> a, Optional<T> b) {
        private final Optional<T> a;
        private final Optional<T> b;

        public boolean a() {
            return this.f().isEmpty() && this.g().isEmpty();
        }

        public DataResult<a<T>> b() {
            return this.c() ? DataResult.error(() -> "Swapped bounds in range: " + String.valueOf(this.f()) + " is higher than " + String.valueOf(this.g())) : DataResult.success((Object)this);
        }

        public boolean c() {
            return this.a.isPresent() && this.b.isPresent() && ((Comparable)((Object)((Number)this.a.get()))).compareTo((Number)this.b.get()) > 0;
        }

        public Optional<T> d() {
            Optional<T> optional1;
            Optional<T> optional = this.f();
            return optional.equals(optional1 = this.g()) ? optional : Optional.empty();
        }

        public static <T extends Number> a<T> e() {
            return new a(Optional.empty(), Optional.empty());
        }

        public static <T extends Number> a<T> a(T value) {
            Optional<T> optional = Optional.of(value);
            return new a<T>(optional, optional);
        }

        public static <T extends Number> a<T> a(T min, T max) {
            return new a<T>(Optional.of(min), Optional.of(max));
        }

        public static <T extends Number> a<T> b(T min) {
            return new a<T>(Optional.of(min), Optional.empty());
        }

        public static <T extends Number> a<T> c(T max) {
            return new a(Optional.empty(), Optional.of(max));
        }

        public <U extends Number> a<U> a(Function<T, U> mapper) {
            return new a<U>(this.a.map(mapper), this.b.map(mapper));
        }

        static <T extends Number> Codec<a<T>> a(Codec<T> valueCodec) {
            Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)valueCodec.optionalFieldOf("min").forGetter(a::f), (App)valueCodec.optionalFieldOf("max").forGetter(a::g)).apply((Applicative)instance, a::new));
            return Codec.either((Codec)codec, valueCodec).xmap(either -> either.map(bounds -> bounds, object -> net.minecraft.advancements.criterion.CriterionConditionValue$a.a(object)), bounds -> {
                Optional point = bounds.d();
                return point.isPresent() ? Either.right((Number)point.get()) : Either.left(bounds);
            });
        }

        static <B extends ByteBuf, T extends Number> StreamCodec<B, a<T>> a(final StreamCodec<B, T> valueCodec) {
            return new StreamCodec<B, a<T>>(){
                private static final int b = 1;
                private static final int c = 2;

                public a<T> a(B buffer) {
                    byte _byte = buffer.readByte();
                    Optional optional = (_byte & 1) != 0 ? Optional.of((Number)valueCodec.decode(buffer)) : Optional.empty();
                    Optional optional1 = (_byte & 2) != 0 ? Optional.of((Number)valueCodec.decode(buffer)) : Optional.empty();
                    return new a(optional, optional1);
                }

                public void a(B buffer, a<T> value) {
                    Optional<Number> optional = value.f();
                    Optional<Number> optional1 = value.g();
                    buffer.writeByte((optional.isPresent() ? 1 : 0) | (optional1.isPresent() ? 2 : 0));
                    optional.ifPresent(min -> valueCodec.encode(buffer, min));
                    optional1.ifPresent(max -> valueCodec.encode(buffer, max));
                }
            };
        }

        public static <T extends Number> a<T> a(StringReader reader, Function<String, T> converter, Supplier<DynamicCommandExceptionType> errorGetter) throws CommandSyntaxException {
            if (!reader.canRead()) {
                throw a.createWithContext((ImmutableStringReader)reader);
            }
            int cursor = reader.getCursor();
            try {
                Optional<T> number1;
                Optional<T> number = net.minecraft.advancements.criterion.CriterionConditionValue$a.b(reader, converter, errorGetter);
                if (reader.canRead(2) && reader.peek() == '.' && reader.peek(1) == '.') {
                    reader.skip();
                    reader.skip();
                    number1 = net.minecraft.advancements.criterion.CriterionConditionValue$a.b(reader, converter, errorGetter);
                } else {
                    number1 = number;
                }
                if (number.isEmpty() && number1.isEmpty()) {
                    throw a.createWithContext((ImmutableStringReader)reader);
                }
                return new a<T>(number, number1);
            }
            catch (CommandSyntaxException var6) {
                reader.setCursor(cursor);
                throw new CommandSyntaxException(var6.getType(), var6.getRawMessage(), var6.getInput(), cursor);
            }
        }

        private static <T extends Number> Optional<T> b(StringReader reader, Function<String, T> converter, Supplier<DynamicCommandExceptionType> errorGetter) throws CommandSyntaxException {
            int cursor = reader.getCursor();
            while (reader.canRead() && net.minecraft.advancements.criterion.CriterionConditionValue$a.a(reader)) {
                reader.skip();
            }
            String sub = reader.getString().substring(cursor, reader.getCursor());
            if (sub.isEmpty()) {
                return Optional.empty();
            }
            try {
                return Optional.of((Number)converter.apply(sub));
            }
            catch (NumberFormatException var6) {
                throw errorGetter.get().createWithContext((ImmutableStringReader)reader, (Object)sub);
            }
        }

        private static boolean a(StringReader reader) {
            char c2 = reader.peek();
            return c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '.' && (!reader.canRead(2) || reader.peek(1) != '.');
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "min;max", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "min;max", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "min;max", "a", "b"}, this, o2);
        }

        public Optional<T> f() {
            return this.a;
        }

        public Optional<T> g() {
            return this.b;
        }
    }

    public static final class IntegerRange
    extends Record
    implements CriterionConditionValue<Integer> {
        private final a<Integer> f;
        private final a<Long> g;
        public static final IntegerRange c = new IntegerRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.e());
        public static final Codec<IntegerRange> d = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(Codec.INT).validate(a::b).xmap(IntegerRange::new, IntegerRange::a);
        public static final StreamCodec<ByteBuf, IntegerRange> e = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(ByteBufCodecs.g).a(IntegerRange::new, IntegerRange::a);

        private IntegerRange(a<Integer> bounds) {
            this(bounds, bounds.a(integer -> MathHelper.b(integer.longValue())));
        }

        public IntegerRange(a<Integer> bounds, a<Long> boundsSqr) {
            this.f = bounds;
            this.g = boundsSqr;
        }

        public static IntegerRange a(int value) {
            return new IntegerRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.a(value));
        }

        public static IntegerRange a(int min, int max) {
            return new IntegerRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.a(min, max));
        }

        public static IntegerRange b(int min) {
            return new IntegerRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.b(min));
        }

        public static IntegerRange c(int max) {
            return new IntegerRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.c(max));
        }

        public boolean d(int value) {
            return !(this.f.a.isPresent() && (Integer)this.f.a.get() > value || !this.f.b.isEmpty() && (Integer)this.f.b.get() < value);
        }

        public boolean a(long value) {
            return !(this.g.a.isPresent() && (Long)this.g.a.get() > value || !this.g.b.isEmpty() && (Long)this.g.b.get() < value);
        }

        public static IntegerRange a(StringReader reader) throws CommandSyntaxException {
            int cursor = reader.getCursor();
            a<Integer> bounds = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(reader, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt());
            if (bounds.c()) {
                reader.setCursor(cursor);
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new IntegerRange(bounds);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerRange.class, "bounds;boundsSqr", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerRange.class, "bounds;boundsSqr", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerRange.class, "bounds;boundsSqr", "f", "g"}, this, o2);
        }

        @Override
        public a<Integer> a() {
            return this.f;
        }

        public a<Long> e() {
            return this.g;
        }
    }

    public static final class c
    extends Record
    implements CriterionConditionValue<Float> {
        private final a<Float> f;
        public static final c c = new c(net.minecraft.advancements.criterion.CriterionConditionValue$a.e());
        public static final Codec<c> d = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(Codec.FLOAT).xmap(c::new, c::a);
        public static final StreamCodec<ByteBuf, c> e = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(ByteBufCodecs.l).a(c::new, c::a);

        public c(a<Float> bounds) {
            this.f = bounds;
        }

        public static c a(StringReader reader) throws CommandSyntaxException {
            a<Float> bounds = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(reader, Float::parseFloat, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidFloat());
            return new c(bounds);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "bounds", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "bounds", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "bounds", "f"}, this, o2);
        }

        @Override
        public a<Float> a() {
            return this.f;
        }
    }

    public static final class DoubleRange
    extends Record
    implements CriterionConditionValue<Double> {
        private final a<Double> f;
        private final a<Double> g;
        public static final DoubleRange c = new DoubleRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.e());
        public static final Codec<DoubleRange> d = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(Codec.DOUBLE).validate(a::b).xmap(DoubleRange::new, DoubleRange::a);
        public static final StreamCodec<ByteBuf, DoubleRange> e = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(ByteBufCodecs.m).a(DoubleRange::new, DoubleRange::a);

        private DoubleRange(a<Double> bounds) {
            this(bounds, bounds.a(MathHelper::n));
        }

        public DoubleRange(a<Double> bounds, a<Double> boundsSqr) {
            this.f = bounds;
            this.g = boundsSqr;
        }

        public static DoubleRange a(double value) {
            return new DoubleRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.a(value));
        }

        public static DoubleRange a(double min, double max) {
            return new DoubleRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.a(min, max));
        }

        public static DoubleRange b(double min) {
            return new DoubleRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.b(min));
        }

        public static DoubleRange c(double max) {
            return new DoubleRange(net.minecraft.advancements.criterion.CriterionConditionValue$a.c(max));
        }

        public boolean d(double value) {
            return !(this.f.a.isPresent() && (Double)this.f.a.get() > value || !this.f.b.isEmpty() && (Double)this.f.b.get() < value);
        }

        public boolean e(double value) {
            return !(this.g.a.isPresent() && (Double)this.g.a.get() > value || !this.g.b.isEmpty() && (Double)this.g.b.get() < value);
        }

        public static DoubleRange a(StringReader reader) throws CommandSyntaxException {
            int cursor = reader.getCursor();
            a<Double> bounds = net.minecraft.advancements.criterion.CriterionConditionValue$a.a(reader, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble());
            if (bounds.c()) {
                reader.setCursor(cursor);
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new DoubleRange(bounds);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DoubleRange.class, "bounds;boundsSqr", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleRange.class, "bounds;boundsSqr", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleRange.class, "bounds;boundsSqr", "f", "g"}, this, o2);
        }

        @Override
        public a<Double> a() {
            return this.f;
        }

        public a<Double> e() {
            return this.g;
        }
    }
}

