/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.permissions.PermissionSetSupplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.World;

public interface ICompletionProvider
extends PermissionSetSupplier {
    public static final CharMatcher c = CharMatcher.anyOf((CharSequence)"._/");

    public Collection<String> r();

    default public Collection<String> z() {
        return this.r();
    }

    default public Collection<String> A() {
        return Collections.emptyList();
    }

    public Collection<String> s();

    public Stream<MinecraftKey> t();

    public CompletableFuture<Suggestions> a(CommandContext<?> var1);

    default public Collection<b> B() {
        return Collections.singleton(b.b);
    }

    default public Collection<b> C() {
        return Collections.singleton(b.b);
    }

    public Set<ResourceKey<World>> u();

    public IRegistryCustom v();

    public FeatureFlagSet w();

    default public void a(HolderLookup<?> lookup, a type, SuggestionsBuilder builder) {
        if (type.a()) {
            ICompletionProvider.a(lookup.f().map(TagKey::b), builder, "#");
        }
        if (type.b()) {
            ICompletionProvider.a(lookup.c_().map(ResourceKey::a), builder);
        }
    }

    public static <S> CompletableFuture<Suggestions> a(CommandContext<S> context, SuggestionsBuilder builder, ResourceKey<? extends IRegistry<?>> registryKey, a type) {
        CompletableFuture<Suggestions> completableFuture;
        Object object = context.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider sharedSuggestionProvider = (ICompletionProvider)object;
            completableFuture = sharedSuggestionProvider.a(registryKey, type, builder, context);
        } else {
            completableFuture = builder.buildFuture();
        }
        return completableFuture;
    }

    public CompletableFuture<Suggestions> a(ResourceKey<? extends IRegistry<?>> var1, a var2, SuggestionsBuilder var3, CommandContext<?> var4);

    public static <T> void a(Iterable<T> resources, String input, Function<T, MinecraftKey> locationFunction, Consumer<T> resourceConsumer) {
        boolean flag = input.indexOf(58) > -1;
        for (T object : resources) {
            MinecraftKey identifier = locationFunction.apply(object);
            if (flag) {
                String string = identifier.toString();
                if (!ICompletionProvider.a(input, string)) continue;
                resourceConsumer.accept(object);
                continue;
            }
            if (!ICompletionProvider.a(input, identifier.b()) && !ICompletionProvider.a(input, identifier.a())) continue;
            resourceConsumer.accept(object);
        }
    }

    public static <T> void a(Iterable<T> resources, String remaining, String prefix, Function<T, MinecraftKey> locationFunction, Consumer<T> resourceConsumer) {
        if (remaining.isEmpty()) {
            resources.forEach(resourceConsumer);
        } else {
            String string = Strings.commonPrefix((CharSequence)remaining, (CharSequence)prefix);
            if (!string.isEmpty()) {
                String sub = remaining.substring(string.length());
                ICompletionProvider.a(resources, sub, locationFunction, resourceConsumer);
            }
        }
    }

    public static CompletableFuture<Suggestions> a(Iterable<MinecraftKey> resources, SuggestionsBuilder builder, String prefix) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.a(resources, string, prefix, identifier -> identifier, identifier -> builder.suggest(prefix + String.valueOf(identifier)));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> a(Stream<MinecraftKey> resources, SuggestionsBuilder builder, String prefix) {
        return ICompletionProvider.a(resources::iterator, builder, prefix);
    }

    public static CompletableFuture<Suggestions> a(Iterable<MinecraftKey> resources, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.a(resources, string, (T identifier) -> identifier, (T identifier) -> builder.suggest(identifier.toString()));
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> a(Iterable<T> resources, SuggestionsBuilder builder, Function<T, MinecraftKey> locationFunction, Function<T, Message> suggestionFunction) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        ICompletionProvider.a(resources, string, locationFunction, (T object) -> builder.suggest(((MinecraftKey)locationFunction.apply(object)).toString(), (Message)suggestionFunction.apply(object)));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> a(Stream<MinecraftKey> resourceLocations, SuggestionsBuilder builder) {
        return ICompletionProvider.a(resourceLocations::iterator, builder);
    }

    public static <T> CompletableFuture<Suggestions> a(Stream<T> resources, SuggestionsBuilder builder, Function<T, MinecraftKey> locationFunction, Function<T, Message> suggestionFunction) {
        return ICompletionProvider.a(resources::iterator, builder, locationFunction, suggestionFunction);
    }

    public static CompletableFuture<Suggestions> a(String remaining, Collection<b> coordinates, SuggestionsBuilder builder, Predicate<String> validator) {
        ArrayList list;
        block4: {
            String[] parts;
            block5: {
                block3: {
                    list = Lists.newArrayList();
                    if (!Strings.isNullOrEmpty((String)remaining)) break block3;
                    for (b textCoordinates : coordinates) {
                        String string = textCoordinates.c + " " + textCoordinates.d + " " + textCoordinates.e;
                        if (!validator.test(string)) continue;
                        list.add(textCoordinates.c);
                        list.add(textCoordinates.c + " " + textCoordinates.d);
                        list.add(string);
                    }
                    break block4;
                }
                parts = remaining.split(" ");
                if (parts.length != 1) break block5;
                for (b textCoordinates1 : coordinates) {
                    String string1 = parts[0] + " " + textCoordinates1.d + " " + textCoordinates1.e;
                    if (!validator.test(string1)) continue;
                    list.add(parts[0] + " " + textCoordinates1.d);
                    list.add(string1);
                }
                break block4;
            }
            if (parts.length != 2) break block4;
            for (b textCoordinates1x : coordinates) {
                String string1 = parts[0] + " " + parts[1] + " " + textCoordinates1x.e;
                if (!validator.test(string1)) continue;
                list.add(string1);
            }
        }
        return ICompletionProvider.b(list, builder);
    }

    public static CompletableFuture<Suggestions> b(String remaining, Collection<b> coordinates, SuggestionsBuilder builder, Predicate<String> validator) {
        ArrayList list;
        block3: {
            block2: {
                list = Lists.newArrayList();
                if (!Strings.isNullOrEmpty((String)remaining)) break block2;
                for (b textCoordinates : coordinates) {
                    String string = textCoordinates.c + " " + textCoordinates.e;
                    if (!validator.test(string)) continue;
                    list.add(textCoordinates.c);
                    list.add(string);
                }
                break block3;
            }
            String[] parts = remaining.split(" ");
            if (parts.length != 1) break block3;
            for (b textCoordinates1 : coordinates) {
                String string1 = parts[0] + " " + textCoordinates1.e;
                if (!validator.test(string1)) continue;
                list.add(string1);
            }
        }
        return ICompletionProvider.b(list, builder);
    }

    public static CompletableFuture<Suggestions> b(Iterable<String> strings, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string1 : strings) {
            if (!ICompletionProvider.a(string, string1.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string1);
        }
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> b(Stream<String> strings, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        strings.filter(string1 -> ICompletionProvider.a(string, string1.toLowerCase(Locale.ROOT))).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static CompletableFuture<Suggestions> a(String[] strings, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (String string1 : strings) {
            if (!ICompletionProvider.a(string, string1.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string1);
        }
        return builder.buildFuture();
    }

    public static <T> CompletableFuture<Suggestions> b(Iterable<T> resources, SuggestionsBuilder builder, Function<T, String> stringFunction, Function<T, Message> suggestionFunction) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (T object : resources) {
            String string1 = stringFunction.apply(object);
            if (!ICompletionProvider.a(string, string1.toLowerCase(Locale.ROOT))) continue;
            builder.suggest(string1, suggestionFunction.apply(object));
        }
        return builder.buildFuture();
    }

    public static boolean a(String input, String substring) {
        int i2 = 0;
        while (!substring.startsWith(input, i2)) {
            int i1 = c.indexIn((CharSequence)substring, i2);
            if (i1 < 0) {
                return false;
            }
            i2 = i1 + 1;
        }
        return true;
    }

    public static class b {
        public static final b a = new b("^", "^", "^");
        public static final b b = new b("~", "~", "~");
        public final String c;
        public final String d;
        public final String e;

        public b(String x2, String y2, String z2) {
            this.c = x2;
            this.d = y2;
            this.e = z2;
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        public boolean a() {
            return this == a || this == c;
        }

        public boolean b() {
            return this == b || this == c;
        }

        private static /* synthetic */ a[] c() {
            return new a[]{a, b, c};
        }

        static {
            d = net.minecraft.commands.ICompletionProvider$a.c();
        }
    }
}

