/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;

public class ArgumentParticle
implements ArgumentType<ParticleParam> {
    private static final Collection<String> c = Arrays.asList("foo", "foo:bar", "particle{foo:bar}");
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(particle -> IChatBaseComponent.b("particle.notFound", particle));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("particle.invalidOptions", object));
    private final HolderLookup.a d;
    private static final MojangsonParser<?> e = MojangsonParser.a(DynamicOpsNBT.a);

    public ArgumentParticle(CommandBuildContext buildContext) {
        this.d = buildContext;
    }

    public static ArgumentParticle a(CommandBuildContext buildContext) {
        return new ArgumentParticle(buildContext);
    }

    public static ParticleParam a(CommandContext<CommandListenerWrapper> context, String name) {
        return (ParticleParam)context.getArgument(name, ParticleParam.class);
    }

    public ParticleParam a(StringReader reader) throws CommandSyntaxException {
        return ArgumentParticle.a(reader, this.d);
    }

    public Collection<String> getExamples() {
        return c;
    }

    public static ParticleParam a(StringReader reader, HolderLookup.a registries) throws CommandSyntaxException {
        Particle<?> particleType = ArgumentParticle.a(reader, registries.e(Registries.ag));
        return ArgumentParticle.a(e, reader, particleType, registries);
    }

    private static Particle<?> a(StringReader reader, HolderLookup<Particle<?>> particleTypeLookup) throws CommandSyntaxException {
        MinecraftKey identifier = MinecraftKey.a(reader);
        ResourceKey<Particle<?>> resourceKey = ResourceKey.a(Registries.ag, identifier);
        return particleTypeLookup.a(resourceKey).orElseThrow(() -> a.createWithContext((ImmutableStringReader)reader, (Object)identifier)).a();
    }

    private static <T extends ParticleParam, O> T a(MojangsonParser<O> parser, StringReader reader, Particle<T> particleType, HolderLookup.a registries) throws CommandSyntaxException {
        RegistryOps<O> registryOps = registries.a(parser.a());
        Object object = reader.canRead() && reader.peek() == '{' ? parser.b(reader) : registryOps.emptyMap();
        return (T)((ParticleParam)particleType.c().codec().parse(registryOps, object).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)b).create(arg_0)));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        HolderLookup.b<Particle<?>> registryLookup = this.d.e(Registries.ag);
        return ICompletionProvider.a(registryLookup.c_().map(ResourceKey::a), builder);
    }
}

