/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreHolder;

public class ArgumentScoreholder
implements ArgumentType<b> {
    public static final SuggestionProvider<CommandListenerWrapper> a = (context, builder) -> {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(stringReader, ((CommandListenerWrapper)context.getSource()).d().hasPermission(Permissions.e));
        try {
            entitySelectorParser.t();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return entitySelectorParser.a(builder, offsetBuilder -> ICompletionProvider.b(((CommandListenerWrapper)context.getSource()).r(), offsetBuilder));
    };
    private static final Collection<String> b = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.scoreHolder.empty"));
    final boolean d;

    public ArgumentScoreholder(boolean multiple) {
        this.d = multiple;
    }

    public static ScoreHolder a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ArgumentScoreholder.b(context, name).iterator().next();
    }

    public static Collection<ScoreHolder> b(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ArgumentScoreholder.a(context, name, Collections::emptyList);
    }

    public static Collection<ScoreHolder> c(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ArgumentScoreholder.a(context, name, ((CommandListenerWrapper)context.getSource()).m().aK()::d);
    }

    public static Collection<ScoreHolder> a(CommandContext<CommandListenerWrapper> context, String name, Supplier<Collection<ScoreHolder>> objectives) throws CommandSyntaxException {
        Collection<ScoreHolder> names = ((b)context.getArgument(name, b.class)).getNames((CommandListenerWrapper)context.getSource(), objectives);
        if (names.isEmpty()) {
            throw ArgumentEntity.d.create();
        }
        return names;
    }

    public static ArgumentScoreholder a() {
        return new ArgumentScoreholder(false);
    }

    public static ArgumentScoreholder b() {
        return new ArgumentScoreholder(true);
    }

    public b a(StringReader reader) throws CommandSyntaxException {
        return this.a(reader, true);
    }

    public <S> b a(StringReader reader, S suggestionProvider) throws CommandSyntaxException {
        return this.a(reader, ArgumentParserSelector.a(suggestionProvider));
    }

    private b a(StringReader reader, boolean allowSelectors) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '@') {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(reader, allowSelectors);
            EntitySelector entitySelector = entitySelectorParser.t();
            if (!this.d && entitySelector.a() > 1) {
                throw ArgumentEntity.a.createWithContext((ImmutableStringReader)reader);
            }
            return new c(entitySelector);
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        String sub = reader.getString().substring(cursor, reader.getCursor());
        if (sub.equals("*")) {
            return (source, objectives) -> {
                Collection collection = (Collection)objectives.get();
                if (collection.isEmpty()) {
                    throw c.create();
                }
                return collection;
            };
        }
        List<ScoreHolder> list = List.of(ScoreHolder.c(sub));
        if (sub.startsWith("#")) {
            return (source, objectives) -> list;
        }
        try {
            UUID uuid = UUID.fromString(sub);
            return (source, objectives) -> {
                MinecraftServer server = source.m();
                Entity scoreHolder = null;
                ArrayList<Entity> list1 = null;
                for (WorldServer serverLevel : server.P()) {
                    Entity entity = serverLevel.d(uuid);
                    if (entity == null) continue;
                    if (scoreHolder == null) {
                        scoreHolder = entity;
                        continue;
                    }
                    if (list1 == null) {
                        list1 = new ArrayList<Entity>();
                        list1.add(scoreHolder);
                    }
                    list1.add(entity);
                }
                if (list1 != null) {
                    return list1;
                }
                return scoreHolder != null ? List.of(scoreHolder) : list;
            };
        }
        catch (IllegalArgumentException var7) {
            return (source, objectives) -> {
                MinecraftServer server = source.m();
                EntityPlayer playerByName = server.aj().a(sub);
                return playerByName != null ? List.of(playerByName) : list;
            };
        }
    }

    public Collection<String> getExamples() {
        return b;
    }

    @FunctionalInterface
    public static interface b {
        public Collection<ScoreHolder> getNames(CommandListenerWrapper var1, Supplier<Collection<ScoreHolder>> var2) throws CommandSyntaxException;
    }

    public static class c
    implements b {
        private final EntitySelector a;

        public c(EntitySelector selector) {
            this.a = selector;
        }

        @Override
        public Collection<ScoreHolder> getNames(CommandListenerWrapper source, Supplier<Collection<ScoreHolder>> objectives) throws CommandSyntaxException {
            List<? extends Entity> list = this.a.b(source);
            if (list.isEmpty()) {
                throw ArgumentEntity.d.create();
            }
            return List.copyOf(list);
        }
    }

    public static class net.minecraft.commands.arguments.ArgumentScoreholder$a
    implements ArgumentTypeInfo<ArgumentScoreholder, a> {
        private static final byte a = 1;

        @Override
        public void a(a template, PacketDataSerializer buffer) {
            int i2 = 0;
            if (template.b) {
                i2 |= 1;
            }
            buffer.l(i2);
        }

        @Override
        public a a(PacketDataSerializer buffer) {
            byte _byte = buffer.readByte();
            boolean flag = (_byte & 1) != 0;
            return new a(flag);
        }

        @Override
        public void a(a template, JsonObject json) {
            json.addProperty("amount", template.b ? "multiple" : "single");
        }

        @Override
        public a a(ArgumentScoreholder argument) {
            return new a(argument.d);
        }

        public final class a
        implements ArgumentTypeInfo.a<ArgumentScoreholder> {
            final boolean b;

            a(boolean multiple) {
                this.b = multiple;
            }

            public ArgumentScoreholder a(CommandBuildContext context) {
                return new ArgumentScoreholder(this.b);
            }

            @Override
            public ArgumentTypeInfo<ArgumentScoreholder, ?> a() {
                return a.this;
            }
        }
    }
}

