/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ARGB;

public class HexColorArgument
implements ArgumentType<Integer> {
    private static final Collection<String> b = Arrays.asList("F00", "FF0000");
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("argument.hexcolor.invalid", object));

    private HexColorArgument() {
    }

    public static HexColorArgument a() {
        return new HexColorArgument();
    }

    public static Integer a(CommandContext<CommandListenerWrapper> context, String argument) {
        return (Integer)context.getArgument(argument, Integer.class);
    }

    public Integer a(StringReader reader) throws CommandSyntaxException {
        String unquotedString = reader.readUnquotedString();
        return switch (unquotedString.length()) {
            case 3 -> ARGB.a(HexColorArgument.a(Integer.parseInt(unquotedString, 0, 1, 16)), HexColorArgument.a(Integer.parseInt(unquotedString, 1, 2, 16)), HexColorArgument.a(Integer.parseInt(unquotedString, 2, 3, 16)));
            case 6 -> ARGB.a(Integer.parseInt(unquotedString, 0, 2, 16), Integer.parseInt(unquotedString, 2, 4, 16), Integer.parseInt(unquotedString, 4, 6, 16));
            default -> throw a.createWithContext((ImmutableStringReader)reader, (Object)unquotedString);
        };
    }

    private static int a(int digit) {
        return digit * 17;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ICompletionProvider.b(b, builder);
    }

    public Collection<String> getExamples() {
        return b;
    }
}

