/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class EntitySelector {
    public static final int a = Integer.MAX_VALUE;
    public static final BiConsumer<Vec3D, List<? extends Entity>> b = (center, entityList) -> {};
    private static final EntityTypeTest<Entity, ?> c = new EntityTypeTest<Entity, Entity>(){

        @Override
        public Entity a(Entity entity) {
            return entity;
        }

        @Override
        public Class<? extends Entity> a() {
            return Entity.class;
        }
    };
    private final int d;
    private final boolean e;
    private final boolean f;
    private final List<Predicate<Entity>> g;
    private final @Nullable CriterionConditionValue.DoubleRange h;
    private final Function<Vec3D, Vec3D> i;
    private final @Nullable AxisAlignedBB j;
    private final BiConsumer<Vec3D, List<? extends Entity>> k;
    private final boolean l;
    private final @Nullable String m;
    private final @Nullable UUID n;
    private final EntityTypeTest<Entity, ?> o;
    private final boolean p;

    public EntitySelector(int maxResults, boolean includesEntities, boolean worldLimited, List<Predicate<Entity>> contextFreePredicates, @Nullable CriterionConditionValue.DoubleRange range, Function<Vec3D, Vec3D> position, @Nullable AxisAlignedBB aabb, BiConsumer<Vec3D, List<? extends Entity>> order, boolean currentEntity, @Nullable String playerName, @Nullable UUID entityUUID, @Nullable EntityTypes<?> type, boolean usesSelector) {
        this.d = maxResults;
        this.e = includesEntities;
        this.f = worldLimited;
        this.g = contextFreePredicates;
        this.h = range;
        this.i = position;
        this.j = aabb;
        this.k = order;
        this.l = currentEntity;
        this.m = playerName;
        this.n = entityUUID;
        this.o = type == null ? c : type;
        this.p = usesSelector;
    }

    public int a() {
        return this.d;
    }

    public boolean b() {
        return this.e;
    }

    public boolean c() {
        return this.l;
    }

    public boolean d() {
        return this.f;
    }

    public boolean e() {
        return this.p;
    }

    private void e(CommandListenerWrapper source) throws CommandSyntaxException {
        if (!source.bypassSelectorPermissions && this.p && !source.hasPermission(Permissions.e, "minecraft.command.selector")) {
            throw ArgumentEntity.f.create();
        }
    }

    public Entity a(CommandListenerWrapper source) throws CommandSyntaxException {
        this.e(source);
        List<? extends Entity> list = this.b(source);
        if (list.isEmpty()) {
            throw ArgumentEntity.d.create();
        }
        if (list.size() > 1) {
            throw ArgumentEntity.a.create();
        }
        return list.get(0);
    }

    public List<? extends Entity> b(CommandListenerWrapper source) throws CommandSyntaxException {
        this.e(source);
        if (!this.e) {
            return this.d(source);
        }
        if (this.m != null) {
            EntityPlayer playerByName = source.m().aj().a(this.m);
            return playerByName == null ? List.of() : List.of(playerByName);
        }
        if (this.n != null) {
            for (WorldServer serverLevel : source.m().P()) {
                Entity entity = serverLevel.d(this.n);
                if (entity == null) continue;
                if (!entity.ay().a(source.w())) break;
                return List.of(entity);
            }
            return List.of();
        }
        Vec3D vec3 = this.i.apply(source.e());
        AxisAlignedBB absoluteAabb = this.a(vec3);
        if (this.l) {
            Predicate<Entity> predicate = this.a(vec3, absoluteAabb, null);
            return source.g() != null && predicate.test(source.g()) ? List.of(source.g()) : List.of();
        }
        Predicate<Entity> predicate = this.a(vec3, absoluteAabb, source.w());
        ObjectArrayList list = new ObjectArrayList();
        if (this.d()) {
            this.a((List<Entity>)list, source.f(), absoluteAabb, predicate);
        } else {
            for (WorldServer serverLevel1 : source.m().P()) {
                this.a((List<Entity>)list, serverLevel1, absoluteAabb, predicate);
            }
        }
        return this.a(vec3, (List)list);
    }

    private void a(List<Entity> entities, WorldServer level, @Nullable AxisAlignedBB box, Predicate<Entity> predicate) {
        int resultLimit = this.f();
        if (entities.size() < resultLimit) {
            if (box != null) {
                level.a(this.o, box, predicate, entities, resultLimit);
            } else {
                level.a(this.o, predicate, entities, resultLimit);
            }
        }
    }

    private int f() {
        return this.k == b ? this.d : Integer.MAX_VALUE;
    }

    public EntityPlayer c(CommandListenerWrapper source) throws CommandSyntaxException {
        this.e(source);
        List<EntityPlayer> list = this.d(source);
        if (list.size() != 1) {
            throw ArgumentEntity.e.create();
        }
        return list.get(0);
    }

    public List<EntityPlayer> d(CommandListenerWrapper source) throws CommandSyntaxException {
        Object players;
        this.e(source);
        if (this.m != null) {
            EntityPlayer playerByName = source.m().aj().a(this.m);
            return playerByName == null ? List.of() : List.of(playerByName);
        }
        if (this.n != null) {
            EntityPlayer playerByName = source.m().aj().b(this.n);
            return playerByName == null ? List.of() : List.of(playerByName);
        }
        Vec3D vec3 = this.i.apply(source.e());
        AxisAlignedBB absoluteAabb = this.a(vec3);
        Predicate<Entity> predicate = this.a(vec3, absoluteAabb, null);
        if (this.l) {
            EntityPlayer serverPlayer;
            Entity entity = source.g();
            return entity instanceof EntityPlayer && predicate.test(serverPlayer = (EntityPlayer)entity) ? List.of(serverPlayer) : List.of();
        }
        int resultLimit = this.f();
        if (this.d()) {
            players = source.f().a(predicate, resultLimit);
        } else {
            players = new ObjectArrayList();
            for (EntityPlayer serverPlayer1 : source.m().aj().t()) {
                if (!predicate.test(serverPlayer1)) continue;
                players.add(serverPlayer1);
                if (players.size() < resultLimit) continue;
                return players;
            }
        }
        return this.a(vec3, (List)players);
    }

    private @Nullable AxisAlignedBB a(Vec3D pos) {
        return this.j != null ? this.j.c(pos) : null;
    }

    private Predicate<Entity> a(Vec3D pos, @Nullable AxisAlignedBB box, @Nullable FeatureFlagSet enabledFeatures) {
        ObjectArrayList list;
        boolean flag2;
        boolean flag1;
        boolean flag = enabledFeatures != null;
        int i2 = (flag ? 1 : 0) + ((flag1 = box != null) ? 1 : 0) + ((flag2 = this.h != null) ? 1 : 0);
        if (i2 == 0) {
            list = this.g;
        } else {
            ObjectArrayList list1 = new ObjectArrayList(this.g.size() + i2);
            list1.addAll(this.g);
            if (flag) {
                list1.add(entity -> entity.ay().a(enabledFeatures));
            }
            if (flag1) {
                list1.add(entity -> box.c(entity.dj()));
            }
            if (flag2) {
                list1.add(entity -> this.h.e(entity.g(pos)));
            }
            list = list1;
        }
        return SystemUtils.a(list);
    }

    private <T extends Entity> List<T> a(Vec3D pos, List<T> entities) {
        if (entities.size() > 1) {
            this.k.accept(pos, entities);
        }
        return entities.subList(0, Math.min(this.d, entities.size()));
    }

    public static IChatBaseComponent a(List<? extends Entity> names) {
        return ChatComponentUtils.b(names, Entity::R_);
    }
}

