/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.functions.PlainTextFunction;
import net.minecraft.commands.functions.StringTemplate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.SystemUtils;
import org.jspecify.annotations.Nullable;

public class MacroFunction<T extends ExecutionCommandSource<T>>
implements CommandFunction<T> {
    private static final DecimalFormat a = SystemUtils.a(new DecimalFormat("#", DecimalFormatSymbols.getInstance(Locale.ROOT)), (? super T format) -> format.setMaximumFractionDigits(15));
    private static final int b = 8;
    private final List<String> c;
    private final Object2ObjectLinkedOpenHashMap<List<String>, InstantiatedFunction<T>> d = new Object2ObjectLinkedOpenHashMap(8, 0.25f);
    private final MinecraftKey e;
    private final List<a<T>> f;

    public MacroFunction(MinecraftKey id, List<a<T>> entries, List<String> parameters) {
        this.e = id;
        this.f = entries;
        this.c = parameters;
    }

    @Override
    public MinecraftKey a() {
        return this.e;
    }

    @Override
    public InstantiatedFunction<T> a(@Nullable NBTTagCompound arguments, CommandDispatcher<T> dispatcher) throws FunctionInstantiationException {
        if (arguments == null) {
            throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.missing_arguments", IChatBaseComponent.a(this.a())));
        }
        ArrayList<String> list = new ArrayList<String>(this.c.size());
        for (String string : this.c) {
            NBTBase tag = arguments.a(string);
            if (tag == null) {
                throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.missing_argument", IChatBaseComponent.a(this.a()), string));
            }
            list.add(MacroFunction.a(tag));
        }
        InstantiatedFunction instantiatedFunction = (InstantiatedFunction)this.d.getAndMoveToLast(list);
        if (instantiatedFunction != null) {
            return instantiatedFunction;
        }
        if (this.d.size() >= 8) {
            this.d.removeFirst();
        }
        InstantiatedFunction<T> instantiatedFunction1 = this.a(this.c, list, dispatcher);
        this.d.put(list, instantiatedFunction1);
        return instantiatedFunction1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a(NBTBase tag) {
        String string;
        NBTBase nBTBase = tag;
        Objects.requireNonNull(nBTBase);
        NBTBase nBTBase2 = nBTBase;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTTagFloat.class, NBTTagDouble.class, NBTTagByte.class, NBTTagShort.class, NBTTagLong.class, NBTTagString.class}, (Object)nBTBase2, n2)) {
            case 0: {
                float var24;
                NBTTagFloat nBTTagFloat = (NBTTagFloat)nBTBase2;
                try {
                    float f2;
                    var24 = f2 = nBTTagFloat.n();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                string = a.format(var24);
                return string;
            }
            case 1: {
                double var25;
                NBTTagDouble nBTTagDouble = (NBTTagDouble)nBTBase2;
                {
                    double d2;
                    var25 = d2 = nBTTagDouble.n();
                }
                string = a.format(var25);
                return string;
            }
            case 2: {
                byte var26;
                NBTTagByte nBTTagByte = (NBTTagByte)nBTBase2;
                {
                    byte by;
                    var26 = by = nBTTagByte.n();
                }
                string = String.valueOf(var26);
                return string;
            }
            case 3: {
                short var27;
                NBTTagShort nBTTagShort = (NBTTagShort)nBTBase2;
                {
                    short s2;
                    var27 = s2 = nBTTagShort.n();
                }
                string = String.valueOf(var27);
                return string;
            }
            case 4: {
                long var28;
                NBTTagLong nBTTagLong = (NBTTagLong)nBTBase2;
                {
                    long l2;
                    var28 = l2 = nBTTagLong.n();
                }
                string = String.valueOf(var28);
                return string;
            }
            case 5: {
                NBTTagString nBTTagString = (NBTTagString)nBTBase2;
                {
                    String string2;
                    String var17;
                    string = var17 = (string2 = nBTTagString.k());
                    return string;
                }
            }
        }
        string = tag.toString();
        return string;
    }

    private static void a(List<String> arguments, IntList parameters, List<String> output) {
        output.clear();
        parameters.forEach(i2 -> output.add((String)arguments.get(i2)));
    }

    private InstantiatedFunction<T> a(List<String> argumentNames, List<String> argumentValues, CommandDispatcher<T> dispatcher) throws FunctionInstantiationException {
        ArrayList list = new ArrayList(this.f.size());
        ArrayList<String> list1 = new ArrayList<String>(argumentValues.size());
        for (a<T> entry : this.f) {
            MacroFunction.a(argumentValues, entry.a(), list1);
            list.add(entry.a(list1, dispatcher, this.e));
        }
        return new PlainTextFunction(this.a().a(string -> string + "/" + argumentNames.hashCode()), list);
    }

    static interface a<T> {
        public IntList a();

        public UnboundEntryAction<T> a(List<String> var1, CommandDispatcher<T> var2, MinecraftKey var3) throws FunctionInstantiationException;
    }

    static class c<T>
    implements a<T> {
        private final UnboundEntryAction<T> a;

        public c(UnboundEntryAction<T> compiledAction) {
            this.a = compiledAction;
        }

        @Override
        public IntList a() {
            return IntLists.emptyList();
        }

        @Override
        public UnboundEntryAction<T> a(List<String> arguments, CommandDispatcher<T> dispatcher, MinecraftKey function) {
            return this.a;
        }
    }

    static class b<T extends ExecutionCommandSource<T>>
    implements a<T> {
        private final StringTemplate a;
        private final IntList b;
        private final T c;

        public b(StringTemplate template, IntList parameters, T compilationContext) {
            this.a = template;
            this.b = parameters;
            this.c = compilationContext;
        }

        @Override
        public IntList a() {
            return this.b;
        }

        @Override
        public UnboundEntryAction<T> a(List<String> arguments, CommandDispatcher<T> dispatcher, MinecraftKey function) throws FunctionInstantiationException {
            String string = this.a.a(arguments);
            try {
                return CommandFunction.a(dispatcher, this.c, new StringReader(string));
            }
            catch (CommandSyntaxException var6) {
                throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.parse", IChatBaseComponent.a(function), string, var6.getMessage()));
            }
        }
    }
}

