/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.c<T>> c();

    default public Stream<ResourceKey<T>> c_() {
        return this.c().map(Holder.c::h);
    }

    public Stream<HolderSet.Named<T>> e();

    default public Stream<TagKey<T>> f() {
        return this.e().map(HolderSet.Named::h);
    }

    public static interface b<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public Optional<T> getValueForCopying(ResourceKey<T> var1);

        public ResourceKey<? extends IRegistry<? extends T>> g();

        public Lifecycle h();

        default public b<T> a(FeatureFlagSet enabledFeatures) {
            return FeatureElement.cd.contains(this.g()) ? this.a((T featureElement) -> ((FeatureElement)featureElement).a(enabledFeatures)) : this;
        }

        default public b<T> a(final Predicate<T> predicate) {
            return new a<T>(){

                @Override
                public Optional<T> getValueForCopying(ResourceKey<T> resourceKey) {
                    return this.a().getValueForCopying(resourceKey).filter(predicate);
                }

                @Override
                public b<T> a() {
                    return this;
                }

                @Override
                public Optional<Holder.c<T>> a(ResourceKey<T> resourceKey) {
                    return this.a().a(resourceKey).filter(reference -> predicate.test(reference.a()));
                }

                @Override
                public Stream<Holder.c<T>> c() {
                    return this.a().c().filter(reference -> predicate.test(reference.a()));
                }
            };
        }

        public static interface a<T>
        extends b<T> {
            public b<T> a();

            @Override
            default public Optional<T> getValueForCopying(ResourceKey<T> resourceKey) {
                return this.a().getValueForCopying(resourceKey);
            }

            @Override
            default public ResourceKey<? extends IRegistry<? extends T>> g() {
                return this.a().g();
            }

            @Override
            default public Lifecycle h() {
                return this.a().h();
            }

            @Override
            default public Optional<Holder.c<T>> a(ResourceKey<T> resourceKey) {
                return this.a().a(resourceKey);
            }

            @Override
            default public Stream<Holder.c<T>> c() {
                return this.a().c();
            }

            @Override
            default public Optional<HolderSet.Named<T>> a(TagKey<T> tagKey) {
                return this.a().a(tagKey);
            }

            @Override
            default public Stream<HolderSet.Named<T>> e() {
                return this.a().e();
            }
        }
    }

    public static interface a
    extends HolderGetter.a {
        public Stream<ResourceKey<? extends IRegistry<?>>> b();

        default public Stream<b<?>> c() {
            return this.b().map(this::e);
        }

        public <T> Optional<? extends b<T>> a(ResourceKey<? extends IRegistry<? extends T>> var1);

        default public <T> b<T> e(ResourceKey<? extends IRegistry<? extends T>> registryKey) {
            return this.a(registryKey).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(registryKey.a()) + " not found"));
        }

        default public <V> RegistryOps<V> a(DynamicOps<V> ops) {
            return RegistryOps.a(ops, this);
        }

        public static a a(Stream<b<?>> lookupStream) {
            final Map<ResourceKey, b> map = lookupStream.collect(Collectors.toUnmodifiableMap(b::g, registryLookup -> registryLookup));
            return new a(){

                @Override
                public Stream<ResourceKey<? extends IRegistry<?>>> b() {
                    return map.keySet().stream();
                }

                public <T> Optional<b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryKey) {
                    return Optional.ofNullable((b)map.get(registryKey));
                }
            };
        }

        default public Lifecycle d() {
            return this.c().map(b::h).reduce(Lifecycle.stable(), Lifecycle::add);
        }
    }
}

