/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import org.jspecify.annotations.Nullable;

public interface IRegistry<T>
extends Keyable,
HolderLookup.b<T>,
Registry<T> {
    @Override
    public ResourceKey<? extends IRegistry<T>> g();

    default public Codec<T> q() {
        return this.b().flatComapMap(Holder.c::a, object -> this.a(this.e(object)));
    }

    default public Codec<Holder<T>> r() {
        return this.b().flatComapMap(reference -> reference, this::a);
    }

    private Codec<Holder.c<T>> b() {
        Codec codec = MinecraftKey.a.comapFlatMap(identifier -> this.c((MinecraftKey)identifier).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.g()) + ": " + String.valueOf(identifier))), reference -> reference.h().a());
        return ExtraCodecs.a(codec, (E reference) -> this.d(reference.h()).map(RegistrationInfo::b).orElse(Lifecycle.experimental()));
    }

    @Override
    private DataResult<Holder.c<T>> a(Holder<T> value) {
        DataResult dataResult;
        if (value instanceof Holder.c) {
            Holder.c reference = (Holder.c)value;
            dataResult = DataResult.success((Object)reference);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(this.g()) + ": " + String.valueOf(value));
        }
        return dataResult;
    }

    default public <U> Stream<U> keys(DynamicOps<U> ops) {
        return this.i().stream().map(identifier -> ops.createString(identifier.toString()));
    }

    public @Nullable MinecraftKey b(T var1);

    public Optional<ResourceKey<T>> d(T var1);

    @Override
    public int a(@Nullable T var1);

    public @Nullable T c(@Nullable ResourceKey<T> var1);

    public @Nullable T a(@Nullable MinecraftKey var1);

    public Optional<RegistrationInfo> d(ResourceKey<T> var1);

    default public Optional<T> b(@Nullable MinecraftKey key) {
        return Optional.ofNullable(this.a(key));
    }

    default public Optional<T> f(@Nullable ResourceKey<T> registryKey) {
        return Optional.ofNullable(this.c(registryKey));
    }

    public Optional<Holder.c<T>> a();

    default public T g(ResourceKey<T> key) {
        T value = this.c(key);
        if (value == null) {
            throw new IllegalStateException("Missing key in " + String.valueOf(this.g()) + ": " + String.valueOf(key));
        }
        return value;
    }

    public Set<MinecraftKey> i();

    public Set<Map.Entry<ResourceKey<T>, T>> k();

    public Set<ResourceKey<T>> j();

    public Optional<Holder.c<T>> a(RandomSource var1);

    default public Stream<T> s() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean d(MinecraftKey var1);

    public boolean e(ResourceKey<T> var1);

    public static <T> T a(IRegistry<? super T> registry, String name, T value) {
        return IRegistry.a(registry, MinecraftKey.a(name), value);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, MinecraftKey key, T value) {
        return IRegistry.a(registry, ResourceKey.a(registry.g(), key), value);
    }

    public static <V, T extends V> T a(IRegistry<V> registry, ResourceKey<V> key, T value) {
        ((IRegistryWritable)registry).a(key, value, RegistrationInfo.a);
        return value;
    }

    public static <R, T extends R> Holder.c<T> b(IRegistry<R> registry, ResourceKey<R> key, T value) {
        return ((IRegistryWritable)registry).a(key, value, RegistrationInfo.a);
    }

    public static <R, T extends R> Holder.c<T> b(IRegistry<R> registry, MinecraftKey key, T value) {
        return IRegistry.b(registry, ResourceKey.a(registry.g(), key), value);
    }

    public IRegistry<T> n();

    public Holder.c<T> f(T var1);

    public Optional<Holder.c<T>> c(int var1);

    public Optional<Holder.c<T>> c(MinecraftKey var1);

    public Holder<T> e(T var1);

    default public Iterable<Holder<T>> c(TagKey<T> key) {
        return (Iterable)DataFixUtils.orElse((Optional)this.a(key), List.of());
    }

    public Stream<HolderSet.Named<T>> l();

    default public Registry<Holder<T>> t() {
        return new Registry<Holder<T>>(){

            @Override
            public int a(Holder<T> value) {
                return IRegistry.this.a(value.a());
            }

            public @Nullable Holder<T> c(int id) {
                return IRegistry.this.c(id).orElse(null);
            }

            @Override
            public int d() {
                return IRegistry.this.d();
            }

            @Override
            public Iterator<Holder<T>> iterator() {
                return IRegistry.this.c().map(holder -> holder).iterator();
            }
        };
    }

    @Override
    public a<T> a(TagDataPack.c<T> var1);

    public static interface a<T> {
        public ResourceKey<? extends IRegistry<? extends T>> a();

        public HolderLookup.b<T> c();

        public void d();

        public int b();
    }
}

