/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.CursorPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.entity.EntityAccess;

public class SectionPosition
extends BaseBlockPosition {
    public static final int a = 4;
    public static final int b = 16;
    public static final int c = 15;
    public static final int d = 8;
    public static final int e = 15;
    private static final int j = 22;
    private static final int k = 20;
    private static final int l = 22;
    private static final long m = 0x3FFFFFL;
    private static final long n = 1048575L;
    private static final long o = 0x3FFFFFL;
    private static final int p = 0;
    private static final int q = 20;
    private static final int r = 42;
    private static final int s = 8;
    private static final int t = 0;
    private static final int u = 4;
    public static final StreamCodec<ByteBuf, SectionPosition> f = ByteBufCodecs.j.a(SectionPosition::a, SectionPosition::s);

    SectionPosition(int x2, int y2, int z2) {
        super(x2, y2, z2);
    }

    public static SectionPosition a(int x2, int y2, int z2) {
        return new SectionPosition(x2, y2, z2);
    }

    public static SectionPosition a(BlockPosition pos) {
        return new SectionPosition(pos.u() >> 4, pos.v() >> 4, pos.w() >> 4);
    }

    public static SectionPosition a(ChunkCoordIntPair chunkPos, int y2) {
        return new SectionPosition(chunkPos.h, y2, chunkPos.i);
    }

    public static SectionPosition a(EntityAccess entity) {
        return SectionPosition.a(entity.dK());
    }

    public static SectionPosition a(IPosition position) {
        return new SectionPosition(SectionPosition.b(position.a()), SectionPosition.b(position.b()), SectionPosition.b(position.c()));
    }

    public static SectionPosition a(long packed) {
        return new SectionPosition((int)(packed >> 42), (int)(packed << 44 >> 44), (int)(packed << 22 >> 42));
    }

    public static SectionPosition a(IChunkAccess chunk) {
        return SectionPosition.a(chunk.f(), chunk.ay());
    }

    public static long a(long packed, EnumDirection direction) {
        return SectionPosition.a(packed, direction.j(), direction.k(), direction.l());
    }

    public static long getAdjacentFromBlockPos(int x2, int y2, int z2, EnumDirection direction) {
        return ((long)((x2 >> 4) + direction.j()) & 0x3FFFFFL) << 42 | (long)((y2 >> 4) + direction.k()) & 0xFFFFFL | ((long)((z2 >> 4) + direction.l()) & 0x3FFFFFL) << 20;
    }

    public static long getAdjacentFromSectionPos(int x2, int y2, int z2, EnumDirection direction) {
        return ((long)(x2 + direction.j()) & 0x3FFFFFL) << 42 | (long)(y2 + direction.k()) & 0xFFFFFL | ((long)(z2 + direction.l()) & 0x3FFFFFL) << 20;
    }

    public static long a(long packed, int dx, int dy, int dz) {
        return ((long)((int)(packed >> 42) + dx) & 0x3FFFFFL) << 42 | (long)((int)(packed << 44 >> 44) + dy) & 0xFFFFFL | ((long)((int)(packed << 22 >> 42) + dz) & 0x3FFFFFL) << 20;
    }

    public static int a(double pos) {
        return SectionPosition.a(MathHelper.c(pos));
    }

    public static int a(int blockCoord) {
        return blockCoord >> 4;
    }

    public static int b(double blockCoord) {
        return MathHelper.c(blockCoord) >> 4;
    }

    public static int b(int blockCoord) {
        return blockCoord & 0xF;
    }

    public static short b(BlockPosition pos) {
        return (short)((pos.u() & 0xF) << 8 | (pos.w() & 0xF) << 4 | pos.v() & 0xF);
    }

    public static int a(short x2) {
        return x2 >>> 8 & 0xF;
    }

    public static int b(short y2) {
        return y2 >>> 0 & 0xF;
    }

    public static int c(short z2) {
        return z2 >>> 4 & 0xF;
    }

    public int d(short x2) {
        return this.d() + SectionPosition.a(x2);
    }

    public int e(short y2) {
        return this.e() + SectionPosition.b(y2);
    }

    public int f(short z2) {
        return this.f() + SectionPosition.c(z2);
    }

    public BlockPosition g(short pos) {
        return new BlockPosition(this.d(pos), this.e(pos), this.f(pos));
    }

    public static int c(int sectionCoord) {
        return sectionCoord << 4;
    }

    public static int a(int sectionCoord, int offset) {
        return SectionPosition.c(sectionCoord) + offset;
    }

    public static int b(long packed) {
        return (int)(packed << 0 >> 42);
    }

    public static int c(long packed) {
        return (int)(packed << 44 >> 44);
    }

    public static int d(long packed) {
        return (int)(packed << 22 >> 42);
    }

    public int a() {
        return this.u();
    }

    public int b() {
        return this.v();
    }

    public int c() {
        return this.w();
    }

    public final int d() {
        return this.u() << 4;
    }

    public final int e() {
        return this.v() << 4;
    }

    public final int f() {
        return this.w() << 4;
    }

    public int g() {
        return SectionPosition.a(this.a(), 15);
    }

    public int h() {
        return SectionPosition.a(this.b(), 15);
    }

    public int i() {
        return SectionPosition.a(this.c(), 15);
    }

    public static long e(long pos) {
        return ((long)((int)(pos >> 42)) & 0x3FFFFFL) << 42 | (long)((int)(pos << 52 >> 56)) & 0xFFFFFL | ((long)((int)(pos << 26 >> 42)) & 0x3FFFFFL) << 20;
    }

    public static long b(int x2, int z2) {
        return SectionPosition.f(SectionPosition.b(x2, 0, z2));
    }

    public static long f(long pos) {
        return pos & 0xFFFFFFFFFFF00000L;
    }

    public static long g(long pos) {
        return ChunkCoordIntPair.d(SectionPosition.b(pos), SectionPosition.d(pos));
    }

    public BlockPosition j() {
        return new BlockPosition(SectionPosition.c(this.a()), SectionPosition.c(this.b()), SectionPosition.c(this.c()));
    }

    public BlockPosition k() {
        int i2 = 8;
        return this.j().b(8, 8, 8);
    }

    public ChunkCoordIntPair r() {
        return new ChunkCoordIntPair(this.a(), this.c());
    }

    public static long c(BlockPosition pos) {
        return SectionPosition.b(SectionPosition.a(pos.u()), SectionPosition.a(pos.v()), SectionPosition.a(pos.w()));
    }

    public static long blockPosAsSectionLong(int x2, int y2, int z2) {
        return ((long)(x2 >> 4) & 0x3FFFFFL) << 42 | (long)(y2 >> 4) & 0xFFFFFL | ((long)(z2 >> 4) & 0x3FFFFFL) << 20;
    }

    public static long b(int x2, int y2, int z2) {
        return ((long)x2 & 0x3FFFFFL) << 42 | (long)y2 & 0xFFFFFL | ((long)z2 & 0x3FFFFFL) << 20;
    }

    public long s() {
        return ((long)this.u() & 0x3FFFFFL) << 42 | (long)this.v() & 0xFFFFFL | ((long)this.w() & 0x3FFFFFL) << 20;
    }

    public SectionPosition d(int dx, int dy, int dz) {
        return dx == 0 && dy == 0 && dz == 0 ? this : new SectionPosition(this.a() + dx, this.b() + dy, this.c() + dz);
    }

    public Stream<BlockPosition> t() {
        return BlockPosition.a(this.d(), this.e(), this.f(), this.g(), this.h(), this.i());
    }

    public static Stream<SectionPosition> a(SectionPosition center, int radius) {
        return SectionPosition.a(center.u() - radius, center.v() - radius, center.w() - radius, center.u() + radius, center.v() + radius, center.w() + radius);
    }

    public static Stream<SectionPosition> a(ChunkCoordIntPair chunkPos, int radius, int minY, int maxY) {
        int i2 = chunkPos.h;
        int i1 = chunkPos.i;
        return SectionPosition.a(i2 - radius, minY, i1 - radius, i2 + radius, maxY, i1 + radius);
    }

    public static Stream<SectionPosition> a(final int x1, final int y1, final int z1, final int x2, final int y2, final int z2) {
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<SectionPosition>((long)((x2 - x1 + 1) * (y2 - y1 + 1) * (z2 - z1 + 1)), 64){
            final CursorPosition a;
            {
                super(arg0, arg1);
                this.a = new CursorPosition(x1, y1, z1, x2, y2, z2);
            }

            @Override
            public boolean tryAdvance(Consumer<? super SectionPosition> consumer) {
                if (this.a.a()) {
                    consumer.accept(new SectionPosition(this.a.b(), this.a.c(), this.a.d()));
                    return true;
                }
                return false;
            }
        }, false);
    }

    public static void a(BlockPosition pos, LongConsumer consumer) {
        SectionPosition.a(pos.u(), pos.v(), pos.w(), consumer);
    }

    public static void a(long pos, LongConsumer consumer) {
        SectionPosition.a(BlockPosition.a(pos), BlockPosition.b(pos), BlockPosition.c(pos), consumer);
    }

    public static void a(int x2, int y2, int z2, LongConsumer consumer) {
        int sectionPosCoord = SectionPosition.a(x2 - 1);
        int sectionPosCoord1 = SectionPosition.a(x2 + 1);
        int sectionPosCoord2 = SectionPosition.a(y2 - 1);
        int sectionPosCoord3 = SectionPosition.a(y2 + 1);
        int sectionPosCoord4 = SectionPosition.a(z2 - 1);
        int sectionPosCoord5 = SectionPosition.a(z2 + 1);
        if (sectionPosCoord == sectionPosCoord1 && sectionPosCoord2 == sectionPosCoord3 && sectionPosCoord4 == sectionPosCoord5) {
            consumer.accept(SectionPosition.b(sectionPosCoord, sectionPosCoord2, sectionPosCoord4));
        } else {
            for (int i2 = sectionPosCoord; i2 <= sectionPosCoord1; ++i2) {
                for (int i1 = sectionPosCoord2; i1 <= sectionPosCoord3; ++i1) {
                    for (int i22 = sectionPosCoord4; i22 <= sectionPosCoord5; ++i22) {
                        consumer.accept(SectionPosition.b(i2, i1, i22));
                    }
                }
            }
        }
    }
}

