/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenseBehaviorShears
extends DispenseBehaviorMaybe {
    @Override
    protected net.minecraft.world.item.ItemStack a(SourceBlock blockSource, net.minecraft.world.item.ItemStack item) {
        net.minecraft.world.item.ItemStack eventStack;
        IDispenseBehavior dispenseBehavior;
        WorldServer serverLevel = blockSource.b();
        CraftBlock bukkitBlock = CraftBlock.at(serverLevel, blockSource.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(item);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
        serverLevel.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.a(false);
            return item;
        }
        if (!event.getItem().equals((Object)craftItem) && (dispenseBehavior = BlockDispenser.getDispenseBehavior(blockSource, eventStack = CraftItemStack.asNMSCopy(event.getItem()))) != IDispenseBehavior.b && dispenseBehavior != this) {
            dispenseBehavior.dispense(blockSource, eventStack);
            return item;
        }
        if (!serverLevel.B_()) {
            BlockPosition blockPos = blockSource.c().a(blockSource.d().c(BlockDispenser.b));
            this.a(DispenseBehaviorShears.a(serverLevel, item, blockPos) || DispenseBehaviorShears.tryShearEntity(serverLevel, blockPos, item, bukkitBlock, craftItem));
            if (this.b()) {
                item.hurtAndBreak(1, serverLevel, null, item1 -> {});
            }
        }
        return item;
    }

    private static boolean a(WorldServer level, net.minecraft.world.item.ItemStack stack, BlockPosition pos) {
        int honeyLevelValue;
        IBlockData blockState = level.a_(pos);
        if (blockState.a(TagsBlock.aU, (BlockBase.BlockData blockStateBase) -> blockStateBase.b(BlockBeehive.c) && blockStateBase.b() instanceof BlockBeehive) && (honeyLevelValue = blockState.c(BlockBeehive.c).intValue()) >= 5) {
            level.a(null, pos, SoundEffects.cj, SoundCategory.e, 1.0f, 1.0f);
            BlockBeehive.a(level, stack, blockState, level.c_(pos), null, pos);
            ((BlockBeehive)blockState.b()).a((World)level, blockState, pos, null, TileEntityBeehive.ReleaseStatus.b);
            level.a(null, GameEvent.M, pos);
            return true;
        }
        return false;
    }

    private static boolean tryShearEntity(WorldServer level, BlockPosition pos, net.minecraft.world.item.ItemStack stack, Block bukkitBlock, CraftItemStack craftItem) {
        for (Entity entity : level.a(Entity.class, new AxisAlignedBB(pos), IEntitySelector.f)) {
            BlockShearEntityEvent event;
            IShearable shearable;
            if (entity.c((EntityHuman)null)) {
                return true;
            }
            if (!(entity instanceof IShearable) || !(shearable = (IShearable)((Object)entity)).a() || (event = CraftEventFactory.callBlockShearEntityEvent(entity, bukkitBlock, craftItem, shearable.generateDefaultDrops(level, stack))).isCancelled()) continue;
            shearable.shear(level, SoundCategory.e, stack, CraftItemStack.asNMSCopy(event.getDrops()));
            level.a(null, GameEvent.M, pos);
            return true;
        }
        return false;
    }
}

