/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.advancements.packs;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.CriterionConditionBlock;
import net.minecraft.advancements.criterion.CriterionConditionDamage;
import net.minecraft.advancements.criterion.CriterionConditionDamageSource;
import net.minecraft.advancements.criterion.CriterionConditionDistance;
import net.minecraft.advancements.criterion.CriterionConditionEntity;
import net.minecraft.advancements.criterion.CriterionConditionEntityEquipment;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionConditionLocation;
import net.minecraft.advancements.criterion.CriterionConditionPlayer;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.advancements.criterion.CriterionSlideDownBlock;
import net.minecraft.advancements.criterion.CriterionTriggerChanneledLightning;
import net.minecraft.advancements.criterion.CriterionTriggerInventoryChanged;
import net.minecraft.advancements.criterion.CriterionTriggerKilled;
import net.minecraft.advancements.criterion.CriterionTriggerPlayerGeneratesContainerLoot;
import net.minecraft.advancements.criterion.CriterionTriggerPlayerHurtEntity;
import net.minecraft.advancements.criterion.CriterionTriggerPlayerInteractedWithEntity;
import net.minecraft.advancements.criterion.CriterionTriggerProperties;
import net.minecraft.advancements.criterion.CriterionTriggerShotCrossbow;
import net.minecraft.advancements.criterion.CriterionTriggerSummonedEntity;
import net.minecraft.advancements.criterion.CriterionTriggerTargetHit;
import net.minecraft.advancements.criterion.CriterionTriggerUsedTotem;
import net.minecraft.advancements.criterion.CriterionTriggerVillagerTrade;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.advancements.criterion.DistanceTrigger;
import net.minecraft.advancements.criterion.FallAfterExplosionTrigger;
import net.minecraft.advancements.criterion.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.criterion.KilledByArrowTrigger;
import net.minecraft.advancements.criterion.LightningBoltPredicate;
import net.minecraft.advancements.criterion.LightningStrikeTrigger;
import net.minecraft.advancements.criterion.PlayerTrigger;
import net.minecraft.advancements.criterion.RecipeCraftedTrigger;
import net.minecraft.advancements.criterion.SpearMobsTrigger;
import net.minecraft.advancements.criterion.TagPredicate;
import net.minecraft.advancements.criterion.UsingItemTrigger;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.JukeboxPlayablePredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.data.advancements.packs.VanillaHusbandryAdvancements;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.CreakingHeartState;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import org.slf4j.Logger;

public class VanillaAdventureAdvancements
implements AdvancementSubProvider {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 384;
    private static final int c = 320;
    private static final int d = -64;
    private static final int e = 5;
    private static final Map<EnumCreatureType, Set<EntityTypes<?>>> f = Map.of(EnumCreatureType.a, Set.of(EntityTypes.aj, EntityTypes.as, EntityTypes.bO));
    private static final List<EntityTypes<?>> g = Arrays.asList(EntityTypes.q, EntityTypes.s, EntityTypes.t, EntityTypes.w, EntityTypes.y, EntityTypes.H, EntityTypes.I, EntityTypes.O, EntityTypes.Q, EntityTypes.T, EntityTypes.R, EntityTypes.S, EntityTypes.W, EntityTypes.ah, EntityTypes.an, EntityTypes.ao, EntityTypes.ar, EntityTypes.aE, EntityTypes.aV, EntityTypes.aX, EntityTypes.aZ, EntityTypes.ba, EntityTypes.bb, EntityTypes.bh, EntityTypes.bk, EntityTypes.bm, EntityTypes.bn, EntityTypes.bp, EntityTypes.bw, EntityTypes.bA, EntityTypes.bK, EntityTypes.bM, EntityTypes.bQ, EntityTypes.bS, EntityTypes.bR, EntityTypes.bV, EntityTypes.bZ, EntityTypes.bW, EntityTypes.bX, EntityTypes.ca, EntityTypes.bY);

    private static Criterion<LightningStrikeTrigger.a> a(CriterionConditionValue.IntegerRange fireCount, Optional<CriterionConditionEntity> bystander) {
        return LightningStrikeTrigger.a.a(Optional.of(CriterionConditionEntity.a.a().a(CriterionConditionDistance.c(CriterionConditionValue.DoubleRange.c(30.0))).a(LightningBoltPredicate.a(fireCount)).b()), bystander);
    }

    private static Criterion<UsingItemTrigger.a> a(CriterionConditionEntity.a builder, CriterionConditionItem.a item) {
        return UsingItemTrigger.a.a(CriterionConditionEntity.a.a().a(CriterionConditionPlayer.d.a().a(builder).b()), item);
    }

    @Override
    public void a(HolderLookup.a registries, Consumer<AdvancementHolder> writer) {
        HolderLookup.b<EntityTypes<?>> holderLookup = registries.e(Registries.F);
        HolderLookup.b<Item> holderLookup1 = registries.e(Registries.R);
        HolderLookup.b<Block> holderLookup2 = registries.e(Registries.i);
        AdvancementHolder advancementHolder = Advancement.SerializedAdvancement.a().a(Items.wv, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.root.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.root.description"), MinecraftKey.b("gui/advancements/backgrounds/adventure"), AdvancementFrameType.a, false, false, false).a(AdvancementRequirements.a.b).a("killed_something", CriterionTriggerKilled.a.b()).a("killed_by_something", CriterionTriggerKilled.a.d()).a(writer, "adventure/root");
        AdvancementHolder advancementHolder1 = Advancement.SerializedAdvancement.a().a(advancementHolder).a(Blocks.bu, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.sleep_in_bed.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.sleep_in_bed.description"), null, AdvancementFrameType.a, true, true, false).a("slept_in_bed", PlayerTrigger.a.b()).a(writer, "adventure/sleep_in_bed");
        VanillaAdventureAdvancements.a(registries, writer, advancementHolder1, MultiNoiseBiomeSourceParameterList.a.b);
        AdvancementHolder advancementHolder2 = Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.qb, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.trade.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.trade.description"), null, AdvancementFrameType.a, true, true, false).a("traded", CriterionTriggerVillagerTrade.a.b()).a(writer, "adventure/trade");
        Advancement.SerializedAdvancement.a().a(advancementHolder2).a(Items.qb, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.trade_at_world_height.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.trade_at_world_height.description"), null, AdvancementFrameType.a, true, true, false).a("trade_at_world_height", CriterionTriggerVillagerTrade.a.a(CriterionConditionEntity.a.a().a(CriterionConditionLocation.a.a(CriterionConditionValue.DoubleRange.b(319.0))))).a(writer, "adventure/trade_at_world_height");
        AdvancementHolder advancementHolder3 = VanillaAdventureAdvancements.a(advancementHolder, writer, holderLookup, VanillaAdventureAdvancements.a(g, holderLookup));
        AdvancementHolder advancementHolder4 = Advancement.SerializedAdvancement.a().a(advancementHolder3).a(Items.pW, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.shoot_arrow.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.shoot_arrow.description"), null, AdvancementFrameType.a, true, true, false).a("shot_arrow", CriterionTriggerPlayerHurtEntity.a.a(CriterionConditionDamage.a.a().a(CriterionConditionDamageSource.a.a().a(TagPredicate.a(DamageTypeTags.j)).a(CriterionConditionEntity.a.a().a(holderLookup, TagsEntity.g))))).a(writer, "adventure/shoot_arrow");
        AdvancementHolder advancementHolder5 = Advancement.SerializedAdvancement.a().a(advancementHolder3).a(Items.yr, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.throw_trident.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.throw_trident.description"), null, AdvancementFrameType.a, true, true, false).a("shot_trident", CriterionTriggerPlayerHurtEntity.a.a(CriterionConditionDamage.a.a().a(CriterionConditionDamageSource.a.a().a(TagPredicate.a(DamageTypeTags.j)).a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.bH))))).a(writer, "adventure/throw_trident");
        Advancement.SerializedAdvancement.a().a(advancementHolder5).a(Items.yr, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.very_very_frightening.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.very_very_frightening.description"), null, AdvancementFrameType.a, true, true, false).a("struck_villager", CriterionTriggerChanneledLightning.a.a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.bL))).a(writer, "adventure/very_very_frightening");
        Advancement.SerializedAdvancement.a().a(advancementHolder2).a(Blocks.eJ, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.summon_iron_golem.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.summon_iron_golem.description"), null, AdvancementFrameType.c, true, true, false).a("summoned_golem", CriterionTriggerSummonedEntity.a.a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.au))).a(writer, "adventure/summon_iron_golem");
        Advancement.SerializedAdvancement.a().a(advancementHolder4).a(Items.pX, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.sniper_duel.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.sniper_duel.description"), null, AdvancementFrameType.b, true, true, false).a(AdvancementRewards.a.a(50)).a("killed_skeleton", CriterionTriggerKilled.a.a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.bn).a(CriterionConditionDistance.a(CriterionConditionValue.DoubleRange.b(50.0))), CriterionConditionDamageSource.a.a().a(TagPredicate.a(DamageTypeTags.j)))).a(writer, "adventure/sniper_duel");
        Advancement.SerializedAdvancement.a().a(advancementHolder3).a(Items.xP, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.totem_of_undying.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.totem_of_undying.description"), null, AdvancementFrameType.c, true, true, false).a("used_totem", CriterionTriggerUsedTotem.a.a(holderLookup1, Items.xP)).a(writer, "adventure/totem_of_undying");
        Advancement.SerializedAdvancement.a().a(advancementHolder3).a(Items.xL, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.spear_many_mobs.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.spear_many_mobs.description"), null, AdvancementFrameType.c, true, true, false).a("spear_many_mobs", SpearMobsTrigger.a.a(5)).a(writer, "adventure/spear_many_mobs");
        AdvancementHolder advancementHolder6 = Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.yz, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.ol_betsy.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.ol_betsy.description"), null, AdvancementFrameType.a, true, true, false).a("shot_crossbow", CriterionTriggerShotCrossbow.a.a(holderLookup1, Items.yz)).a(writer, "adventure/ol_betsy");
        Advancement.SerializedAdvancement.a().a(advancementHolder6).a(Items.yz, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.whos_the_pillager_now.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.whos_the_pillager_now.description"), null, AdvancementFrameType.a, true, true, false).a("kill_pillager", KilledByArrowTrigger.a.a(holderLookup1, CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.bb))).a(writer, "adventure/whos_the_pillager_now");
        Advancement.SerializedAdvancement.a().a(advancementHolder6).a(Items.yz, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.two_birds_one_arrow.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.two_birds_one_arrow.description"), null, AdvancementFrameType.b, true, true, false).a(AdvancementRewards.a.a(65)).a("two_birds", KilledByArrowTrigger.a.a(holderLookup1, CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.aX), CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.aX))).a(writer, "adventure/two_birds_one_arrow");
        Advancement.SerializedAdvancement.a().a(advancementHolder6).a(Items.yz, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.arbalistic.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.arbalistic.description"), null, AdvancementFrameType.b, true, true, true).a(AdvancementRewards.a.a(85)).a("arbalistic", KilledByArrowTrigger.a.a(holderLookup1, CriterionConditionValue.IntegerRange.a(5))).a(writer, "adventure/arbalistic");
        HolderLookup.b<EnumBannerPatternType> registryLookup = registries.e(Registries.aR);
        AdvancementHolder advancementHolder7 = Advancement.SerializedAdvancement.a().a(advancementHolder).a(Raid.a(registryLookup), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.voluntary_exile.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.voluntary_exile.description"), null, AdvancementFrameType.a, true, true, true).a("voluntary_exile", CriterionTriggerKilled.a.a(CriterionConditionEntity.a.a().a(holderLookup, TagsEntity.c).a(CriterionConditionEntityEquipment.a(holderLookup1, registryLookup)))).a(writer, "adventure/voluntary_exile");
        Advancement.SerializedAdvancement.a().a(advancementHolder7).a(Raid.a(registryLookup), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.hero_of_the_village.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.hero_of_the_village.description"), null, AdvancementFrameType.b, true, true, true).a(AdvancementRewards.a.a(100)).a("hero_of_the_village", PlayerTrigger.a.c()).a(writer, "adventure/hero_of_the_village");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Blocks.qg.h(), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.honey_block_slide.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.honey_block_slide.description"), null, AdvancementFrameType.a, true, true, false).a("honey_block_slide", CriterionSlideDownBlock.a.a(Blocks.qg)).a(writer, "adventure/honey_block_slide");
        Advancement.SerializedAdvancement.a().a(advancementHolder4).a(Blocks.qd.h(), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.bullseye.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.bullseye.description"), null, AdvancementFrameType.b, true, true, false).a(AdvancementRewards.a.a(50)).a("bullseye", CriterionTriggerTargetHit.a.a(CriterionConditionValue.IntegerRange.a(15), Optional.of(CriterionConditionEntity.a(CriterionConditionEntity.a.a().a(CriterionConditionDistance.a(CriterionConditionValue.DoubleRange.b(30.0))))))).a(writer, "adventure/bullseye");
        Advancement.SerializedAdvancement.a().a(advancementHolder1).a(Items.rh, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.walk_on_powder_snow_with_leather_boots.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.walk_on_powder_snow_with_leather_boots.description"), null, AdvancementFrameType.a, true, true, false).a("walk_on_powder_snow_with_leather_boots", PlayerTrigger.a.a(holderLookup2, holderLookup1, Blocks.rP, Items.rh)).a(writer, "adventure/walk_on_powder_snow_with_leather_boots");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.mR, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.lightning_rod_with_villager_no_fire.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.lightning_rod_with_villager_no_fire.description"), null, AdvancementFrameType.a, true, true, false).a("lightning_rod_with_villager_no_fire", VanillaAdventureAdvancements.a(CriterionConditionValue.IntegerRange.a(0), Optional.of(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.bL).b()))).a(writer, "adventure/lightning_rod_with_villager_no_fire");
        AdvancementHolder advancementHolder8 = Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.tb, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.spyglass_at_parrot.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.spyglass_at_parrot.description"), null, AdvancementFrameType.a, true, true, false).a("spyglass_at_parrot", VanillaAdventureAdvancements.a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.aW), CriterionConditionItem.a.a().a(holderLookup1, Items.tb))).a(writer, "adventure/spyglass_at_parrot");
        AdvancementHolder advancementHolder9 = Advancement.SerializedAdvancement.a().a(advancementHolder8).a(Items.tb, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.spyglass_at_ghast.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.spyglass_at_ghast.description"), null, AdvancementFrameType.a, true, true, false).a("spyglass_at_ghast", VanillaAdventureAdvancements.a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.ah), CriterionConditionItem.a.a().a(holderLookup1, Items.tb))).a(writer, "adventure/spyglass_at_ghast");
        Advancement.SerializedAdvancement.a().a(advancementHolder1).a(Items.fF, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.play_jukebox_in_meadows.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.play_jukebox_in_meadows.description"), null, AdvancementFrameType.a, true, true, false).a("play_jukebox_in_meadows", ItemUsedOnLocationTrigger.a.a(CriterionConditionLocation.a.a().a(HolderSet.a(registries.e(Registries.aS).b(Biomes.E))).a(CriterionConditionBlock.a.a().a(holderLookup2, Blocks.ew)), CriterionConditionItem.a.a().a(DataComponentMatchers.a.a().a(DataComponentPredicates.n, JukeboxPlayablePredicate.b()).b()))).a(writer, "adventure/play_jukebox_in_meadows");
        Advancement.SerializedAdvancement.a().a(advancementHolder9).a(Items.tb, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.spyglass_at_dragon.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.spyglass_at_dragon.description"), null, AdvancementFrameType.a, true, true, false).a("spyglass_at_dragon", VanillaAdventureAdvancements.a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.T), CriterionConditionItem.a.a().a(holderLookup1, Items.tb))).a(writer, "adventure/spyglass_at_dragon");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.sl, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.fall_from_world_height.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.fall_from_world_height.description"), null, AdvancementFrameType.a, true, true, false).a("fall_from_world_height", DistanceTrigger.a.a(CriterionConditionEntity.a.a().a(CriterionConditionLocation.a.a(CriterionConditionValue.DoubleRange.c(-59.0))), CriterionConditionDistance.b(CriterionConditionValue.DoubleRange.b(379.0)), CriterionConditionLocation.a.a(CriterionConditionValue.DoubleRange.b(319.0)))).a(writer, "adventure/fall_from_world_height");
        Advancement.SerializedAdvancement.a().a(advancementHolder3).a(Blocks.rU, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.kill_mob_near_sculk_catalyst.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.kill_mob_near_sculk_catalyst.description"), null, AdvancementFrameType.b, true, true, false).a("kill_mob_near_sculk_catalyst", CriterionTriggerKilled.a.c()).a(writer, "adventure/kill_mob_near_sculk_catalyst");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Blocks.rQ, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.avoid_vibration.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.avoid_vibration.description"), null, AdvancementFrameType.a, true, true, false).a("avoid_vibration", PlayerTrigger.a.d()).a(writer, "adventure/avoid_vibration");
        AdvancementHolder advancementHolder10 = VanillaAdventureAdvancements.a(holderLookup1, Advancement.SerializedAdvancement.a()).a(advancementHolder).a(Items.Aa, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.salvage_sherd.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.salvage_sherd.description"), null, AdvancementFrameType.a, true, true, false).a(writer, "adventure/salvage_sherd");
        Advancement.SerializedAdvancement.a().a(advancementHolder10).a(DecoratedPotBlockEntity.a(new PotDecorations(Optional.empty(), Optional.of(Items.AF), Optional.empty(), Optional.of(Items.AB))), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.craft_decorated_pot_using_only_sherds.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.craft_decorated_pot_using_only_sherds.description"), null, AdvancementFrameType.a, true, true, false).a("pot_crafted_using_only_sherds", RecipeCraftedTrigger.a.a(ResourceKey.a(Registries.bK, MinecraftKey.b("decorated_pot")), List.of(CriterionConditionItem.a.a().a(holderLookup1, TagsItem.bY), CriterionConditionItem.a.a().a(holderLookup1, TagsItem.bY), CriterionConditionItem.a.a().a(holderLookup1, TagsItem.bY), CriterionConditionItem.a.a().a(holderLookup1, TagsItem.bY)))).a(writer, "adventure/craft_decorated_pot_using_only_sherds");
        AdvancementHolder advancementHolder11 = VanillaAdventureAdvancements.b(Advancement.SerializedAdvancement.a()).a(advancementHolder).a(new ItemStack(Items.Ad), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.trim_with_any_armor_pattern.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.trim_with_any_armor_pattern.description"), null, AdvancementFrameType.a, true, true, false).a(writer, "adventure/trim_with_any_armor_pattern");
        VanillaAdventureAdvancements.a(Advancement.SerializedAdvancement.a()).a(advancementHolder11).a(new ItemStack(Items.Ap), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.trim_with_all_exclusive_armor_patterns.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.trim_with_all_exclusive_armor_patterns.description"), null, AdvancementFrameType.b, true, true, false).a(AdvancementRewards.a.a(150)).a(writer, "adventure/trim_with_all_exclusive_armor_patterns");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.fg, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.read_power_from_chiseled_bookshelf.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.read_power_from_chiseled_bookshelf.description"), null, AdvancementFrameType.a, true, true, false).a(AdvancementRequirements.a.b).a("chiseled_bookshelf", VanillaAdventureAdvancements.a(holderLookup2, Blocks.cw)).a("comparator", VanillaAdventureAdvancements.b(holderLookup2, Blocks.cw)).a(writer, "adventure/read_power_of_chiseled_bookshelf");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.pR, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.brush_armadillo.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.brush_armadillo.description"), null, AdvancementFrameType.a, true, true, false).a("brush_armadillo", CriterionTriggerPlayerInteractedWithEntity.a.b(CriterionConditionItem.a.a().a(holderLookup1, Items.Aa), Optional.of(CriterionConditionEntity.a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.g))))).a(writer, "adventure/brush_armadillo");
        AdvancementHolder advancementHolder12 = Advancement.SerializedAdvancement.a().a(advancementHolder).a(Blocks.rH, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.minecraft_trials_edition.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.minecraft_trials_edition.description"), null, AdvancementFrameType.a, true, true, false).a("minecraft_trials_edition", PlayerTrigger.a.a(CriterionConditionLocation.a.b(registries.e(Registries.bs).b(BuiltinStructures.H)))).a(writer, "adventure/minecraft_trials_edition");
        Advancement.SerializedAdvancement.a().a(advancementHolder12).a(Items.AZ, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.lighten_up.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.lighten_up.description"), null, AdvancementFrameType.a, true, true, false).a("lighten_up", ItemUsedOnLocationTrigger.a.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(holderLookup2, Blocks.tn, Blocks.tm, Blocks.tl, Blocks.tr, Blocks.tq, Blocks.tp).a(CriterionTriggerProperties.a.a().a(CopperBulbBlock.c, true))), CriterionConditionItem.a.a().a(holderLookup1, VanillaHusbandryAdvancements.c))).a(writer, "adventure/lighten_up");
        AdvancementHolder advancementHolder13 = Advancement.SerializedAdvancement.a().a(advancementHolder12).a(Items.By, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.under_lock_and_key.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.under_lock_and_key.description"), null, AdvancementFrameType.a, true, true, false).a("under_lock_and_key", ItemUsedOnLocationTrigger.a.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(holderLookup2, Blocks.uR).a(CriterionTriggerProperties.a.a().a(VaultBlock.d, false))), CriterionConditionItem.a.a().a(holderLookup1, Items.By))).a(writer, "adventure/under_lock_and_key");
        Advancement.SerializedAdvancement.a().a(advancementHolder13).a(Items.Bz, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.revaulting.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.revaulting.description"), null, AdvancementFrameType.c, true, true, false).a("revaulting", ItemUsedOnLocationTrigger.a.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(holderLookup2, Blocks.uR).a(CriterionTriggerProperties.a.a().a(VaultBlock.d, true))), CriterionConditionItem.a.a().a(holderLookup1, Items.Bz))).a(writer, "adventure/revaulting");
        Advancement.SerializedAdvancement.a().a(advancementHolder12).a(Items.wj, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.blowback.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.blowback.description"), null, AdvancementFrameType.b, true, true, false).a(AdvancementRewards.a.a(40)).a("blowback", CriterionTriggerKilled.a.a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.t), CriterionConditionDamageSource.a.a().a(TagPredicate.a(DamageTypeTags.j)).a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.u)))).a(writer, "adventure/blowback");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.tX, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.crafters_crafting_crafters.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.crafters_crafting_crafters.description"), null, AdvancementFrameType.a, true, true, false).a("crafter_crafted_crafter", RecipeCraftedTrigger.a.b(ResourceKey.a(Registries.bK, MinecraftKey.b("crafter")))).a(writer, "adventure/crafters_crafting_crafters");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Items.zk, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.use_lodestone.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.use_lodestone.description"), null, AdvancementFrameType.a, true, true, false).a("use_lodestone", ItemUsedOnLocationTrigger.a.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(holderLookup2, Blocks.qq)), CriterionConditionItem.a.a().a(holderLookup1, Items.sG))).a(writer, "adventure/use_lodestone");
        Advancement.SerializedAdvancement.a().a(advancementHolder12).a(Items.wj, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.who_needs_rockets.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.who_needs_rockets.description"), null, AdvancementFrameType.a, true, true, false).a("who_needs_rockets", FallAfterExplosionTrigger.a.a(CriterionConditionDistance.b(CriterionConditionValue.DoubleRange.b(7.0)), CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.bP))).a(writer, "adventure/who_needs_rockets");
        Advancement.SerializedAdvancement.a().a(advancementHolder12).a(Items.wn, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.overoverkill.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.overoverkill.description"), null, AdvancementFrameType.b, true, true, false).a(AdvancementRewards.a.a(50)).a("overoverkill", CriterionTriggerPlayerHurtEntity.a.a(CriterionConditionDamage.a.a().a(CriterionConditionValue.DoubleRange.b(100.0)).a(CriterionConditionDamageSource.a.a().a(TagPredicate.a(DamageTypeTags.H)).a(CriterionConditionEntity.a.a().a(holderLookup, EntityTypes.cb).a(CriterionConditionEntityEquipment.a.a().f(CriterionConditionItem.a.a().a(holderLookup1, Items.wn))))))).a(writer, "adventure/overoverkill");
        Advancement.SerializedAdvancement.a().a(advancementHolder).a(Blocks.cQ, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.heart_transplanter.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.heart_transplanter.description"), null, AdvancementFrameType.a, true, true, false).a(AdvancementRequirements.a.b).a("place_creaking_heart_dormant", ItemUsedOnLocationTrigger.a.a(Blocks.cQ, BlockProperties.bF, CreakingHeartState.b)).a("place_creaking_heart_awake", ItemUsedOnLocationTrigger.a.a(Blocks.cQ, BlockProperties.bF, CreakingHeartState.c)).a("place_pale_oak_log", VanillaAdventureAdvancements.a(holderLookup2, TagsBlock.t)).a(writer, "adventure/heart_transplanter");
    }

    public static AdvancementHolder a(AdvancementHolder parent, Consumer<AdvancementHolder> output, HolderGetter<EntityTypes<?>> entityTypeRegistry, List<EntityTypes<?>> typesRequired) {
        AdvancementHolder advancementHolder = VanillaAdventureAdvancements.a(Advancement.SerializedAdvancement.a(), entityTypeRegistry, typesRequired).a(parent).a(Items.qH, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.kill_a_mob.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.kill_a_mob.description"), null, AdvancementFrameType.a, true, true, false).a(AdvancementRequirements.a.b).a(output, "adventure/kill_a_mob");
        VanillaAdventureAdvancements.a(Advancement.SerializedAdvancement.a(), entityTypeRegistry, typesRequired).a(advancementHolder).a(Items.qM, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.kill_all_mobs.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.kill_all_mobs.description"), null, AdvancementFrameType.b, true, true, false).a(AdvancementRewards.a.a(100)).a(output, "adventure/kill_all_mobs");
        return advancementHolder;
    }

    private static Criterion<ItemUsedOnLocationTrigger.a> a(HolderGetter<Block> blockRegistry, Block block) {
        LootItemCondition.a[] builders = (LootItemCondition.a[])BlockFacingHorizontal.f.a().stream().map(direction -> {
            CriterionTriggerProperties.a builder = CriterionTriggerProperties.a.a().a(BlockFacingHorizontal.f, direction);
            CriterionConditionBlock.a builder1 = CriterionConditionBlock.a.a().a(blockRegistry, Blocks.hP).a(builder);
            return LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(builder1), new BlockPosition(direction.g().q()));
        }).toArray(LootItemCondition.a[]::new);
        return ItemUsedOnLocationTrigger.a.a(LootItemConditionBlockStateProperty.a(block), AnyOfCondition.a(builders));
    }

    private static Criterion<ItemUsedOnLocationTrigger.a> b(HolderGetter<Block> blockRegistry, Block block) {
        LootItemCondition.a[] builders = (LootItemCondition.a[])BlockFacingHorizontal.f.a().stream().map(direction -> {
            CriterionTriggerProperties.a builder = CriterionTriggerProperties.a.a().a(BlockFacingHorizontal.f, direction);
            LootItemConditionBlockStateProperty.a builder1 = new LootItemConditionBlockStateProperty.a(Blocks.hP).a(builder);
            LootItemCondition.a builder2 = LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(blockRegistry, block)), new BlockPosition(direction.q()));
            return AllOfCondition.a(builder1, builder2);
        }).toArray(LootItemCondition.a[]::new);
        return ItemUsedOnLocationTrigger.a.a(AnyOfCondition.a(builders));
    }

    private static Criterion<ItemUsedOnLocationTrigger.a> a(HolderGetter<Block> blockRegistry, TagKey<Block> blockTag) {
        LootItemCondition.a[] builders = (LootItemCondition.a[])Stream.of(EnumDirection.values()).map(direction -> {
            CriterionTriggerProperties.a builder = CriterionTriggerProperties.a.a().a(CreakingHeartBlock.b, direction.o());
            CriterionConditionBlock.a builder1 = CriterionConditionBlock.a.a().a(blockRegistry, blockTag).a(builder);
            BaseBlockPosition unitVec3i = direction.q();
            LootItemCondition.a builder2 = LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(builder1));
            LootItemCondition.a builder3 = LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(blockRegistry, Blocks.cQ).a(builder)), new BlockPosition(unitVec3i));
            LootItemCondition.a builder4 = LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(builder1), new BlockPosition(unitVec3i.o(2)));
            return AllOfCondition.a(builder2, builder3, builder4);
        }).toArray(LootItemCondition.a[]::new);
        return ItemUsedOnLocationTrigger.a.a(AnyOfCondition.a(builders));
    }

    private static Advancement.SerializedAdvancement a(Advancement.SerializedAdvancement builder) {
        builder.a(AdvancementRequirements.a.a);
        Set<Item> set = Set.of(Items.Am, Items.Ak, Items.Al, Items.Ag, Items.Ap, Items.Ai, Items.Aj, Items.An);
        VanillaRecipeProvider.b().filter(trimTemplate -> set.contains(trimTemplate.a())).forEach(trimTemplate -> builder.a("armor_trimmed_" + String.valueOf(trimTemplate.c().a()), RecipeCraftedTrigger.a.a(trimTemplate.c())));
        return builder;
    }

    private static Advancement.SerializedAdvancement b(Advancement.SerializedAdvancement builder) {
        builder.a(AdvancementRequirements.a.b);
        VanillaRecipeProvider.b().map(VanillaRecipeProvider.b::c).forEach(resourceKey -> builder.a("armor_trimmed_" + String.valueOf(resourceKey.a()), RecipeCraftedTrigger.a.a(resourceKey)));
        return builder;
    }

    private static Advancement.SerializedAdvancement a(HolderGetter<Item> itemRegistry, Advancement.SerializedAdvancement builder) {
        List<Pair> list = List.of(Pair.of((Object)"desert_pyramid", CriterionTriggerPlayerGeneratesContainerLoot.a.a(LootTables.bk)), Pair.of((Object)"desert_well", CriterionTriggerPlayerGeneratesContainerLoot.a.a(LootTables.bj)), Pair.of((Object)"ocean_ruin_cold", CriterionTriggerPlayerGeneratesContainerLoot.a.a(LootTables.bo)), Pair.of((Object)"ocean_ruin_warm", CriterionTriggerPlayerGeneratesContainerLoot.a.a(LootTables.bn)), Pair.of((Object)"trail_ruins_rare", CriterionTriggerPlayerGeneratesContainerLoot.a.a(LootTables.bm)), Pair.of((Object)"trail_ruins_common", CriterionTriggerPlayerGeneratesContainerLoot.a.a(LootTables.bl)));
        list.forEach(pair -> builder.a((String)pair.getFirst(), (Criterion)pair.getSecond()));
        String string = "has_sherd";
        builder.a("has_sherd", CriterionTriggerInventoryChanged.a.a(CriterionConditionItem.a.a().a(itemRegistry, TagsItem.bY)));
        builder.a(new AdvancementRequirements(List.of(list.stream().map(Pair::getFirst).toList(), List.of("has_sherd"))));
        return builder;
    }

    protected static void a(HolderLookup.a levelRegistry, Consumer<AdvancementHolder> writer, AdvancementHolder parent, MultiNoiseBiomeSourceParameterList.a preset) {
        VanillaAdventureAdvancements.a(Advancement.SerializedAdvancement.a(), levelRegistry, preset.a().toList()).a(parent).a(Items.rx, (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.adventuring_time.title"), (IChatBaseComponent)IChatBaseComponent.c("advancements.adventure.adventuring_time.description"), null, AdvancementFrameType.b, true, true, false).a(AdvancementRewards.a.a(500)).a(writer, "adventure/adventuring_time");
    }

    private static Advancement.SerializedAdvancement a(Advancement.SerializedAdvancement builder, HolderGetter<EntityTypes<?>> entityTypeRegistry, List<EntityTypes<?>> mobsToKill) {
        mobsToKill.forEach(entityType -> builder.a(BuiltInRegistries.g.b((EntityTypes<?>)entityType).toString(), CriterionTriggerKilled.a.a(CriterionConditionEntity.a.a().a(entityTypeRegistry, (EntityTypes<?>)entityType))));
        return builder;
    }

    protected static Advancement.SerializedAdvancement a(Advancement.SerializedAdvancement builder, HolderLookup.a levelRegistry, List<ResourceKey<BiomeBase>> biomes) {
        HolderLookup.b<BiomeBase> holderGetter = levelRegistry.e(Registries.aS);
        for (ResourceKey<BiomeBase> resourceKey : biomes) {
            builder.a(resourceKey.a().toString(), PlayerTrigger.a.a(CriterionConditionLocation.a.a(holderGetter.b(resourceKey))));
        }
        return builder;
    }

    private static List<EntityTypes<?>> a(List<EntityTypes<?>> mobsToKill, HolderLookup<EntityTypes<?>> entityTypeRegistry) {
        Sets.SetView set3;
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        Set<EntityTypes<?>> set = Set.copyOf(mobsToKill);
        Set set1 = set.stream().map(EntityTypes::f).collect(Collectors.toSet());
        Sets.SetView set2 = Sets.symmetricDifference(f.keySet(), set1);
        if (!set2.isEmpty()) {
            list.add((CallSite)((Object)("Found EntityType with MobCategory only in either expected exceptions or kill_all_mobs advancement: " + set2.stream().map(Object::toString).sorted().collect(Collectors.joining(", ")))));
        }
        if (!(set3 = Sets.intersection(f.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()), set)).isEmpty()) {
            list.add((CallSite)((Object)("Found EntityType in both expected exceptions and kill_all_mobs advancement: " + set3.stream().map(Object::toString).sorted().collect(Collectors.joining(", ")))));
        }
        Map map = entityTypeRegistry.c().map(Holder.c::a).filter(Predicate.not(set::contains)).collect(Collectors.groupingBy(EntityTypes::f, Collectors.toSet()));
        f.forEach((mobCategory, set4) -> {
            Sets.SetView set5 = Sets.difference(map.getOrDefault(mobCategory, Set.of()), (Set)set4);
            if (!set5.isEmpty()) {
                list.add((CallSite)((Object)String.format(Locale.ROOT, "Found (new?) EntityType with MobCategory %s which are in neither expected exceptions nor kill_all_mobs advancement: %s", mobCategory, set5.stream().map(Object::toString).sorted().collect(Collectors.joining(", ")))));
            }
        });
        if (!list.isEmpty()) {
            list.forEach(arg_0 -> ((Logger)a).error(arg_0));
            throw new IllegalStateException("Found inconsistencies with kill_all_mobs advancement");
        }
        return mobsToKill;
    }
}

