/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.advancements.criterion.CriterionConditionBlock;
import net.minecraft.advancements.criterion.CriterionConditionEnchantments;
import net.minecraft.advancements.criterion.CriterionConditionItem;
import net.minecraft.advancements.criterion.CriterionConditionLocation;
import net.minecraft.advancements.criterion.CriterionConditionValue;
import net.minecraft.advancements.criterion.CriterionTriggerProperties;
import net.minecraft.advancements.criterion.DataComponentMatchers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.INamable;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFlowerPot;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEntry;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionLimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChance;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionSurvivesExplosion;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTableBonus;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class BlockLootSubProvider
implements LootTableSubProvider {
    protected final HolderLookup.a a;
    protected final Set<Item> b;
    protected final FeatureFlagSet c;
    protected final Map<ResourceKey<LootTable>, LootTable.a> d;
    protected static final float[] e = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] f = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    protected LootItemCondition.a a() {
        return LootItemConditionMatchTool.a(CriterionConditionItem.a.a().a(DataComponentMatchers.a.a().a(DataComponentPredicates.b, EnchantmentsPredicate.a(List.of(new CriterionConditionEnchantments(this.a.e(Registries.bf).b(Enchantments.v), CriterionConditionValue.IntegerRange.b(1))))).b()));
    }

    protected LootItemCondition.a b() {
        return this.a().invert();
    }

    protected LootItemCondition.a c() {
        return LootItemConditionMatchTool.a(CriterionConditionItem.a.a().a(this.a.e(Registries.R), Items.tZ));
    }

    private LootItemCondition.a f() {
        return this.c().or(this.a());
    }

    private LootItemCondition.a g() {
        return this.f().invert();
    }

    protected BlockLootSubProvider(Set<Item> explosionResistant, FeatureFlagSet enabledFeatures, HolderLookup.a registries) {
        this(explosionResistant, enabledFeatures, new HashMap<ResourceKey<LootTable>, LootTable.a>(), registries);
    }

    protected BlockLootSubProvider(Set<Item> explosionResistant, FeatureFlagSet enabledFeatures, Map<ResourceKey<LootTable>, LootTable.a> map, HolderLookup.a registries) {
        this.b = explosionResistant;
        this.c = enabledFeatures;
        this.d = map;
        this.a = registries;
    }

    protected <T extends LootItemFunctionUser<T>> T a(IMaterial item, LootItemFunctionUser<T> functionBuilder) {
        return !this.b.contains(item.h()) ? functionBuilder.b(LootItemFunctionExplosionDecay.c()) : functionBuilder.c();
    }

    protected <T extends LootItemConditionUser<T>> T a(IMaterial item, LootItemConditionUser<T> conditionBuilder) {
        return !this.b.contains(item.h()) ? conditionBuilder.b(LootItemConditionSurvivesExplosion.c()) : conditionBuilder.d();
    }

    public LootTable.a a(IMaterial item) {
        return LootTable.b().a(this.a(item, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(item))));
    }

    private static LootTable.a a(Block block, LootItemCondition.a conditionBuilder, LootEntryAbstract.a<?> alternativeBuilder) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(((LootSelectorEntry.a)LootItem.a(block).a(conditionBuilder)).a(alternativeBuilder)));
    }

    protected LootTable.a a(Block block, LootEntryAbstract.a<?> builder) {
        return BlockLootSubProvider.a(block, this.a(), builder);
    }

    protected LootTable.a b(Block block, LootEntryAbstract.a<?> builder) {
        return BlockLootSubProvider.a(block, this.c(), builder);
    }

    protected LootTable.a c(Block block, LootEntryAbstract.a<?> builder) {
        return BlockLootSubProvider.a(block, this.f(), builder);
    }

    protected LootTable.a a(Block block, IMaterial item) {
        return this.a(block, (LootEntryAbstract.a)this.a((IMaterial)block, LootItem.a(item)));
    }

    protected LootTable.a a(IMaterial item, NumberProvider count) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a(item, (LootItemFunctionUser)LootItem.a(item).a(LootItemFunctionSetCount.a(count)))));
    }

    protected LootTable.a a(Block block, IMaterial item, NumberProvider count) {
        return this.a(block, (LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)LootItem.a(item).a(LootItemFunctionSetCount.a(count))));
    }

    private LootTable.a d(IMaterial item) {
        return LootTable.b().a(LootSelector.a().a(this.a()).a(ConstantValue.a(1.0f)).a(LootItem.a(item)));
    }

    private LootTable.a e(IMaterial item) {
        return LootTable.b().a(this.a((IMaterial)Blocks.gG, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(Blocks.gG)))).a(this.a(item, LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(item))));
    }

    protected LootTable.a a(Block block) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)LootItem.a(block).a((LootItemFunction.a)LootItemFunctionSetCount.a(ConstantValue.a(2.0f)).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(BlockStepAbstract.b, BlockPropertySlabType.c)))))));
    }

    protected <T extends Comparable<T> & INamable> LootTable.a a(Block block, IBlockState<T> property, T value) {
        return LootTable.b().a(this.a((IMaterial)block, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(block).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(property, value))))));
    }

    protected LootTable.a b(Block block) {
        return LootTable.b().a(this.a((IMaterial)block, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(block).a(CopyComponentsFunction.b(LootContextParameters.j).a(DataComponents.h)))));
    }

    protected LootTable.a c(Block block) {
        return LootTable.b().a(this.a((IMaterial)block, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(block).a(CopyComponentsFunction.b(LootContextParameters.j).a(DataComponents.h).a(DataComponents.aw).a(DataComponents.az).a(DataComponents.aA)))));
    }

    protected LootTable.a d(Block block) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.a(block, (LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.qh).a(LootItemFunctionSetCount.a(UniformGenerator.a(2.0f, 5.0f)))).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x)))));
    }

    protected LootTable.a e(Block block) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.a(block, (LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.qc).a(LootItemFunctionSetCount.a(UniformGenerator.a(4.0f, 9.0f)))).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x)))));
    }

    protected LootTable.a f(Block block) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.a(block, (LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.mB).a(LootItemFunctionSetCount.a(UniformGenerator.a(4.0f, 5.0f)))).a(LootItemFunctionApplyBonus.b(registryLookup.b(Enchantments.x)))));
    }

    protected LootTable.a g(Block block) {
        return LootTable.b().a(this.a((IMaterial)block, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(block).a(CopyComponentsFunction.b(LootContextParameters.j).a(DataComponents.h).a(DataComponents.k).a(DataComponents.t).a(DataComponents.at).a(DataComponents.n)))));
    }

    protected LootTable.a h(Block block) {
        return LootTable.b().a(LootSelector.a().a(this.a()).a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)LootItem.a(block).a(CopyComponentsFunction.b(LootContextParameters.j).a(DataComponents.ay))).a(LootItemFunctionCopyState.a(block).a(BlockBeehive.c))));
    }

    protected LootTable.a i(Block block) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(((LootEntryAbstract.a)((LootSelectorEntry.a)((LootSelectorEntry.a)LootItem.a(block).a(this.a())).a(CopyComponentsFunction.b(LootContextParameters.j).a(DataComponents.ay))).a(LootItemFunctionCopyState.a(block).a(BlockBeehive.c))).a(LootItem.a(block))));
    }

    protected LootTable.a j(Block block) {
        return LootTable.b().a(LootSelector.a().a(LootItem.a(Items.zb)).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(CaveVines.v_, true))));
    }

    protected LootTable.a k(Block block) {
        return LootTable.b().a(this.a((IMaterial)block, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)LootItem.a(block).a(CopyComponentsFunction.b(LootContextParameters.j).a(DataComponents.h))).a(LootItemFunctionCopyState.a(block).a(CopperGolemStatueBlock.c)))));
    }

    protected LootTable.a a(Block block, Item item) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.a(block, (LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)LootItem.a(item).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x)))));
    }

    protected LootTable.a b(Block block, IMaterial item) {
        return this.a(block, (LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(item).a(LootItemFunctionSetCount.a(UniformGenerator.a(-6.0f, 2.0f)))).a(LootItemFunctionLimitCount.a(IntRange.b(0)))));
    }

    protected LootTable.a l(Block block) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.b(block, (LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(Items.rb).a(LootItemConditionRandomChance.a(0.125f))).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x), 2))));
    }

    public LootTable.a b(Block block, Item item) {
        return LootTable.b().a(this.a((IMaterial)block, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)LootItem.a(item).a(BlockStem.c.a(), (E age) -> LootItemFunctionSetCount.a(BinomialDistributionGenerator.a(3, (float)(age + 1) / 15.0f)).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(BlockStem.c, age.intValue())))))));
    }

    public LootTable.a c(Block block, Item item) {
        return LootTable.b().a(this.a((IMaterial)block, LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a<?>)LootItem.a(item).a(LootItemFunctionSetCount.a(BinomialDistributionGenerator.a(3, 0.53333336f))))));
    }

    protected LootTable.a b(IMaterial item) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(this.c()).a(LootItem.a(item)));
    }

    protected LootTable.a c(IMaterial item) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(this.f()).a(LootItem.a(item)));
    }

    protected LootTable.a a(Block block, LootItemCondition.a builder) {
        return LootTable.b().a(LootSelector.a().a((LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)((LootSelectorEntry.a)((LootSelectorEntry.a)LootItem.a(block).a(builder)).a(EnumDirection.values(), (E direction) -> LootItemFunctionSetCount.a((NumberProvider)ConstantValue.a(1.0f), true).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(MultifaceBlock.b(direction), true))))).a(LootItemFunctionSetCount.a((NumberProvider)ConstantValue.a(-1.0f), true)))));
    }

    protected LootTable.a m(Block block) {
        return LootTable.b().a(LootSelector.a().a((LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)((LootSelectorEntry.a)LootItem.a(block).a(EnumDirection.values(), (E direction) -> LootItemFunctionSetCount.a((NumberProvider)ConstantValue.a(1.0f), true).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(MultifaceBlock.b(direction), true))))).a(LootItemFunctionSetCount.a((NumberProvider)ConstantValue.a(-1.0f), true)))));
    }

    protected LootTable.a n(Block block) {
        return LootTable.b().a(LootSelector.a().a((LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)LootItem.a(block).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(MossyCarpetBlock.b, true))))));
    }

    protected LootTable.a a(Block leavesBlock, Block saplingBlock, float ... chances) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.c(leavesBlock, (LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)leavesBlock, LootItem.a(saplingBlock))).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), chances))).a(LootSelector.a().a(ConstantValue.a(1.0f)).a(this.g()).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)leavesBlock, (LootItemFunctionUser)LootItem.a(Items.qW).a(LootItemFunctionSetCount.a(UniformGenerator.a(1.0f, 2.0f))))).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), f))));
    }

    protected LootTable.a b(Block oakLeavesBlock, Block saplingBlock, float ... chances) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.a(oakLeavesBlock, saplingBlock, chances).a(LootSelector.a().a(ConstantValue.a(1.0f)).a(this.g()).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)oakLeavesBlock, LootItem.a(Items.pV))).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), 0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f))));
    }

    protected LootTable.a o(Block block) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.c(block, (LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)Blocks.aS, (LootItemFunctionUser)LootItem.a(Items.qW).a(LootItemFunctionSetCount.a(UniformGenerator.a(1.0f, 2.0f))))).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), f)));
    }

    protected LootTable.a a(Block cropBlock, Item grownCropItem, Item seedsItem, LootItemCondition.a dropGrownCropCondition) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        return this.a((IMaterial)cropBlock, LootTable.b().a(LootSelector.a().a(((LootSelectorEntry.a)LootItem.a(grownCropItem).a(dropGrownCropCondition)).a(LootItem.a(seedsItem)))).a(LootSelector.a().a(dropGrownCropCondition).a((LootEntryAbstract.a<?>)LootItem.a(seedsItem).a(LootItemFunctionApplyBonus.a(registryLookup.b(Enchantments.x), 0.5714286f, 3)))));
    }

    protected LootTable.a p(Block sheared) {
        return LootTable.b().a(LootSelector.a().a(this.c()).a((LootEntryAbstract.a<?>)LootItem.a(sheared).a(LootItemFunctionSetCount.a(ConstantValue.a(2.0f)))));
    }

    protected LootTable.a a(Block block, Block sheared) {
        HolderLookup.b<Block> registryLookup = this.a.e(Registries.i);
        LootEntryAlternatives.a builder = ((LootSelectorEntry.a)((LootEntryAbstract.a)LootItem.a(sheared).a(LootItemFunctionSetCount.a(ConstantValue.a(2.0f)))).a(this.c())).a((LootEntryAbstract.a<?>)((LootSelectorEntry.a)this.a((IMaterial)block, LootItem.a(Items.rb))).a(LootItemConditionRandomChance.a(0.125f)));
        return LootTable.b().a(LootSelector.a().a(builder).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.b))).a(LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(registryLookup, block).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.a))), new BlockPosition(0, 1, 0)))).a(LootSelector.a().a(builder).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.a))).a(LootItemConditionLocationCheck.a(CriterionConditionLocation.a.a().a(CriterionConditionBlock.a.a().a(registryLookup, block).a(CriterionTriggerProperties.a.a().a(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.b))), new BlockPosition(0, -1, 0))));
    }

    protected LootTable.a q(Block candleBlock) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)candleBlock, (LootItemFunctionUser)LootItem.a(candleBlock).a(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), (E candles) -> LootItemFunctionSetCount.a(ConstantValue.a(candles.intValue())).a(LootItemConditionBlockStateProperty.a(candleBlock).a(CriterionTriggerProperties.a.a().a(CandleBlock.f, candles.intValue())))))));
    }

    public LootTable.a r(Block block) {
        LootTable.a a2;
        if (block instanceof SegmentableBlock) {
            SegmentableBlock segmentableBlock = (SegmentableBlock)((Object)block);
            a2 = LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a((LootEntryAbstract.a)this.a((IMaterial)block, (LootItemFunctionUser)LootItem.a(block).a(IntStream.rangeClosed(1, 4).boxed().toList(), (E amount) -> LootItemFunctionSetCount.a(ConstantValue.a(amount.intValue())).a(LootItemConditionBlockStateProperty.a(block).a(CriterionTriggerProperties.a.a().a(segmentableBlock.c(), amount.intValue())))))));
        } else {
            a2 = BlockLootSubProvider.d();
        }
        return a2;
    }

    protected static LootTable.a s(Block candleCakeBlock) {
        return LootTable.b().a(LootSelector.a().a(ConstantValue.a(1.0f)).a(LootItem.a(candleCakeBlock)));
    }

    public static LootTable.a d() {
        return LootTable.b();
    }

    protected abstract void e();

    @Override
    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.a> output) {
        this.e();
        HashSet set = new HashSet();
        for (Block block : BuiltInRegistries.e) {
            if (!block.a(this.c)) continue;
            block.y().ifPresent(lootTable -> {
                if (set.add(lootTable)) {
                    LootTable.a builder = this.d.remove(lootTable);
                    if (builder == null) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", lootTable.a(), BuiltInRegistries.e.b(block)));
                    }
                    output.accept((ResourceKey<LootTable>)lootTable, builder);
                }
            });
        }
        if (!this.d.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.d.keySet()));
        }
    }

    protected void b(Block vines, Block plant) {
        HolderLookup.b<Enchantment> registryLookup = this.a.e(Registries.bf);
        LootTable.a builder = this.c(vines, (LootEntryAbstract.a<?>)LootItem.a(vines).a(LootItemConditionTableBonus.a(registryLookup.b(Enchantments.x), 0.33f, 0.55f, 0.77f, 1.0f)));
        this.a(vines, builder);
        this.a(plant, builder);
    }

    protected LootTable.a t(Block doorBlock) {
        return this.a(doorBlock, BlockDoor.c, BlockPropertyDoubleBlockHalf.b);
    }

    protected void u(Block flowerPot) {
        this.a(flowerPot, (Block block) -> this.e((IMaterial)((BlockFlowerPot)block).b()));
    }

    protected void c(Block block, Block other) {
        this.a(block, this.d((IMaterial)other));
    }

    protected void c(Block block, IMaterial item) {
        this.a(block, this.a(item));
    }

    protected void v(Block block) {
        this.c(block, block);
    }

    protected void w(Block block) {
        this.c(block, (IMaterial)block);
    }

    protected void a(Block block, Function<Block, LootTable.a> factory) {
        this.a(block, factory.apply(block));
    }

    protected void a(Block block, LootTable.a builder) {
        this.d.put(block.y().orElseThrow(() -> new IllegalStateException("Block " + String.valueOf(block) + " does not have loot table")), builder);
    }
}

