/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class LootTableProvider
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    private final PackOutput.a e;
    private final Set<ResourceKey<LootTable>> f;
    private final List<b> g;
    private final CompletableFuture<HolderLookup.a> h;

    public LootTableProvider(PackOutput output, Set<ResourceKey<LootTable>> requiredTables, List<b> subProviders, CompletableFuture<HolderLookup.a> registries) {
        this.e = output.a(Registries.bG);
        this.g = subProviders;
        this.f = requiredTables;
        this.h = registries;
    }

    @Override
    public CompletableFuture<?> a(CachedOutput output) {
        return this.h.thenCompose(provider -> this.a(output, (HolderLookup.a)provider));
    }

    private CompletableFuture<?> a(CachedOutput output, HolderLookup.a provider) {
        RegistryMaterials<LootTable> writableRegistry = new RegistryMaterials<LootTable>(Registries.bG, Lifecycle.experimental());
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        this.g.forEach(arg_0 -> LootTableProvider.a(provider, (Map)map, writableRegistry, arg_0));
        writableRegistry.n();
        ProblemReporter.a collector = new ProblemReporter.a();
        IRegistryCustom.Dimension frozen = new IRegistryCustom.c(List.of(writableRegistry)).e();
        LootCollector validationContext = new LootCollector(collector, LootContextParameterSets.q, frozen);
        for (ResourceKey resourceKey : Sets.difference(this.f, writableRegistry.j())) {
            collector.a(new a(resourceKey));
        }
        writableRegistry.c().forEach(reference -> ((LootTable)reference.a()).a(validationContext.a(((LootTable)reference.a()).a()).a(new ProblemReporter.h(reference.h()), reference.h())));
        if (!collector.a()) {
            collector.a((String string, ProblemReporter.g problem) -> d.warn("Found validation problem in {}: {}", string, (Object)problem.a()));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])writableRegistry.k().stream().map(entry -> {
            ResourceKey resourceKey1 = (ResourceKey)entry.getKey();
            LootTable lootTable = (LootTable)entry.getValue();
            Path path = this.e.a(resourceKey1.a());
            return DebugReportProvider.a(output, provider, LootTable.d, lootTable, path);
        }).toArray(CompletableFuture[]::new));
    }

    private static MinecraftKey a(ResourceKey<LootTable> lootTable) {
        return lootTable.a();
    }

    @Override
    public final String a() {
        return "Loot Tables";
    }

    private static /* synthetic */ void a(HolderLookup.a provider, Map map, IRegistryWritable writableRegistry, b subProviderEntry) {
        subProviderEntry.a().apply(provider).generate((resourceKey1, builder) -> {
            MinecraftKey identifier = LootTableProvider.a(resourceKey1);
            MinecraftKey identifier1 = map.put(RandomSequence.a(identifier), identifier);
            if (identifier1 != null) {
                SystemUtils.b("Loot table random sequence seed collision on " + String.valueOf(identifier1) + " and " + String.valueOf(resourceKey1.a()));
            }
            builder.a(identifier);
            LootTable lootTable = builder.a(subProviderEntry.b).b();
            writableRegistry.a(resourceKey1, lootTable, RegistrationInfo.a);
        });
    }

    public record a(ResourceKey<LootTable> a) implements ProblemReporter.g
    {
        private final ResourceKey<LootTable> a;

        @Override
        public String a() {
            return "Missing built-in table: " + String.valueOf(this.a.a());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id", "a"}, this, o2);
        }

        public ResourceKey<LootTable> b() {
            return this.a;
        }
    }

    public record b(Function<HolderLookup.a, LootTableSubProvider> a, ContextKeySet b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "provider;paramSet", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "provider;paramSet", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "provider;paramSet", "a", "b"}, this, o2);
        }
    }
}

