/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.util.SystemUtils;

public abstract class TagsProvider<T>
implements DebugReportProvider {
    protected final PackOutput.a e;
    private final CompletableFuture<HolderLookup.a> d;
    private final CompletableFuture<Void> g = new CompletableFuture();
    private final CompletableFuture<b<T>> h;
    protected final ResourceKey<? extends IRegistry<T>> f;
    private final Map<MinecraftKey, TagBuilder> i = Maps.newLinkedHashMap();

    protected TagsProvider(PackOutput output, ResourceKey<? extends IRegistry<T>> registryKey, CompletableFuture<HolderLookup.a> lookupProvider) {
        this(output, registryKey, lookupProvider, CompletableFuture.completedFuture(b.empty()));
    }

    protected TagsProvider(PackOutput output, ResourceKey<? extends IRegistry<T>> registryKey, CompletableFuture<HolderLookup.a> lookupProvider, CompletableFuture<b<T>> parentProvider) {
        this.e = output.b(registryKey);
        this.f = registryKey;
        this.h = parentProvider;
        this.d = lookupProvider;
    }

    @Override
    public final String a() {
        return "Tags for " + String.valueOf(this.f.a());
    }

    protected abstract void a(HolderLookup.a var1);

    @Override
    public CompletableFuture<?> a(CachedOutput output) {
        record A<T>(HolderLookup.a a, b<T> b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "contents;parent", "a", "b"}, this, o2);
            }
        }
        return ((CompletableFuture)((CompletableFuture)this.c().thenApply(provider -> {
            this.g.complete(null);
            return provider;
        })).thenCombineAsync(this.h, (provider, tagLookup) -> new A((HolderLookup.a)provider, tagLookup), (Executor)SystemUtils.h())).thenCompose(combinedData -> {
            HolderLookup.b registryLookup = combinedData.a.e(this.f);
            Predicate<MinecraftKey> predicate = identifier -> registryLookup.a(ResourceKey.a(this.f, identifier)).isPresent();
            Predicate<MinecraftKey> predicate1 = identifier -> this.i.containsKey(identifier) || combinedData.b.contains(TagKey.a(this.f, identifier));
            return CompletableFuture.allOf((CompletableFuture[])this.i.entrySet().stream().map(entry -> {
                MinecraftKey identifier = (MinecraftKey)entry.getKey();
                TagBuilder tagBuilder = (TagBuilder)entry.getValue();
                List<TagEntry> list = tagBuilder.b();
                List<TagEntry> list1 = list.stream().filter(tagEntry -> !tagEntry.a(predicate, predicate1)).toList();
                if (!list1.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", identifier, list1.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                Path path = this.e.a(identifier);
                return DebugReportProvider.a(output, combinedData.a, TagFile.a, new TagFile(list, false), path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected TagBuilder b(TagKey<T> tag) {
        return this.i.computeIfAbsent(tag.b(), identifier -> TagBuilder.a());
    }

    public CompletableFuture<b<T>> b() {
        return this.g.thenApply(_void -> tagKey -> Optional.ofNullable(this.i.get(tagKey.b())));
    }

    protected CompletableFuture<HolderLookup.a> c() {
        return this.d.thenApply(provider -> {
            this.i.clear();
            this.a((HolderLookup.a)provider);
            return provider;
        });
    }

    @FunctionalInterface
    public static interface b<T>
    extends Function<TagKey<T>, Optional<TagBuilder>> {
        public static <T> b<T> empty() {
            return tagKey -> Optional.empty();
        }

        default public boolean contains(TagKey<T> key) {
            return ((Optional)this.apply(key)).isPresent();
        }
    }
}

