/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraft.gametest.framework.GameTestHarnessITestReporter;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JUnitLikeTestReporter
implements GameTestHarnessITestReporter {
    private final Document a;
    private final Element b;
    private final Stopwatch c;
    private final File d;

    public JUnitLikeTestReporter(File destination) throws ParserConfigurationException {
        this.d = destination;
        this.a = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.b = this.a.createElement("testsuite");
        Element element = this.a.createElement("testsuite");
        element.appendChild(this.b);
        this.a.appendChild(element);
        this.b.setAttribute("timestamp", DateTimeFormatter.ISO_INSTANT.format(Instant.now()));
        this.c = Stopwatch.createStarted();
    }

    private Element a(GameTestHarnessInfo testInfo, String name) {
        Element element = this.a.createElement("testcase");
        element.setAttribute("name", name);
        element.setAttribute("classname", testInfo.t().toString());
        element.setAttribute("time", String.valueOf((double)testInfo.l() / 1000.0));
        this.b.appendChild(element);
        return element;
    }

    @Override
    public void a(GameTestHarnessInfo testInfo) {
        String string = testInfo.b().toString();
        String message = testInfo.n().getMessage();
        Element element = this.a.createElement(testInfo.r() ? "failure" : "skipped");
        element.setAttribute("message", "(" + testInfo.c().y() + ") " + message);
        Element element1 = this.a(testInfo, string);
        element1.appendChild(element);
    }

    @Override
    public void b(GameTestHarnessInfo testInfo) {
        String string = testInfo.b().toString();
        this.a(testInfo, string);
    }

    @Override
    public void a() {
        this.c.stop();
        this.b.setAttribute("time", String.valueOf((double)this.c.elapsed(TimeUnit.MILLISECONDS) / 1000.0));
        try {
            this.a(this.d);
        }
        catch (TransformerException var2) {
            throw new Error("Couldn't save test report", var2);
        }
    }

    public void a(File destination) throws TransformerException {
        TransformerFactory instance = TransformerFactory.newInstance();
        Transformer transformer = instance.newTransformer();
        DOMSource domSource = new DOMSource(this.a);
        StreamResult streamResult = new StreamResult(destination);
        transformer.transform(domSource, streamResult);
    }
}

