/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gizmos;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.gizmos.ArrowGizmo;
import net.minecraft.gizmos.CircleGizmo;
import net.minecraft.gizmos.CuboidGizmo;
import net.minecraft.gizmos.Gizmo;
import net.minecraft.gizmos.GizmoCollector;
import net.minecraft.gizmos.GizmoProperties;
import net.minecraft.gizmos.GizmoStyle;
import net.minecraft.gizmos.LineGizmo;
import net.minecraft.gizmos.PointGizmo;
import net.minecraft.gizmos.RectGizmo;
import net.minecraft.gizmos.TextGizmo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public class Gizmos {
    static final ThreadLocal<@Nullable GizmoCollector> a = new ThreadLocal();

    private Gizmos() {
    }

    public static a a(GizmoCollector collector) {
        a temporaryCollection = new a();
        a.set(collector);
        return temporaryCollection;
    }

    public static GizmoProperties a(Gizmo gizmo) {
        GizmoCollector gizmoCollector = a.get();
        if (gizmoCollector == null) {
            throw new IllegalStateException("Gizmos cannot be created here! No GizmoCollector has been registered.");
        }
        return gizmoCollector.add(gizmo);
    }

    public static GizmoProperties a(AxisAlignedBB aabb, GizmoStyle style) {
        return Gizmos.a(aabb, style, false);
    }

    public static GizmoProperties a(AxisAlignedBB aabb, GizmoStyle style, boolean coloredCornerStroke) {
        return Gizmos.a(new CuboidGizmo(aabb, style, coloredCornerStroke));
    }

    public static GizmoProperties a(BlockPosition pos, GizmoStyle style) {
        return Gizmos.a(new AxisAlignedBB(pos), style);
    }

    public static GizmoProperties a(BlockPosition pos, float margin, GizmoStyle style) {
        return Gizmos.a(new AxisAlignedBB(pos).g(margin), style);
    }

    public static GizmoProperties a(Vec3D pos, float radius, GizmoStyle style) {
        return Gizmos.a(new CircleGizmo(pos, radius, style));
    }

    public static GizmoProperties a(Vec3D start, Vec3D end, int color) {
        return Gizmos.a(new LineGizmo(start, end, color, 3.0f));
    }

    public static GizmoProperties a(Vec3D start, Vec3D end, int color, float width) {
        return Gizmos.a(new LineGizmo(start, end, color, width));
    }

    public static GizmoProperties b(Vec3D start, Vec3D end, int color) {
        return Gizmos.a(new ArrowGizmo(start, end, color, 2.5f));
    }

    public static GizmoProperties b(Vec3D start, Vec3D end, int color, float width) {
        return Gizmos.a(new ArrowGizmo(start, end, color, width));
    }

    public static GizmoProperties a(Vec3D pos1, Vec3D pos2, EnumDirection face, GizmoStyle style) {
        return Gizmos.a(RectGizmo.a(pos1, pos2, face, style));
    }

    public static GizmoProperties a(Vec3D a2, Vec3D b2, Vec3D c2, Vec3D d2, GizmoStyle style) {
        return Gizmos.a(new RectGizmo(a2, b2, c2, d2, style));
    }

    public static GizmoProperties a(Vec3D pos, int color, float size) {
        return Gizmos.a(new PointGizmo(pos, color, size));
    }

    public static GizmoProperties a(String text, BlockPosition pos, int line, int color, float scale) {
        double d2 = 1.3;
        double d1 = 0.2;
        GizmoProperties gizmoProperties = Gizmos.a(text, Vec3D.a(pos, 0.5, 1.3 + (double)line * 0.2, 0.5), TextGizmo.a.a(color).a(scale));
        gizmoProperties.a();
        return gizmoProperties;
    }

    public static GizmoProperties a(Entity entity, int line, String text, int color, float scale) {
        double d2 = 2.4;
        double d1 = 0.25;
        double d22 = (double)entity.dO() + 0.5;
        double d3 = entity.dR() + 2.4 + (double)line * 0.25;
        double d4 = (double)entity.dU() + 0.5;
        float f2 = 0.5f;
        GizmoProperties gizmoProperties = Gizmos.a(text, new Vec3D(d22, d3, d4), TextGizmo.a.b(color).a(scale).b(0.5f));
        gizmoProperties.a();
        return gizmoProperties;
    }

    public static GizmoProperties a(String text, Vec3D pos, TextGizmo.a style) {
        return Gizmos.a(new TextGizmo(pos, text, style));
    }

    public static class a
    implements AutoCloseable {
        private final @Nullable GizmoCollector a = a.get();
        private boolean b;

        a() {
        }

        @Override
        public void close() {
            if (!this.b) {
                this.b = true;
                a.set(this.a);
            }
        }
    }
}

