/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.PrimitiveTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class GameProfileSerializer {
    private static final Comparator<NBTTagList> b = Comparator.comparingInt(listTag -> listTag.a(1, 0)).thenComparingInt(listTag -> listTag.a(0, 0)).thenComparingInt(listTag -> listTag.a(2, 0));
    private static final Comparator<NBTTagList> c = Comparator.comparingDouble(listTag -> listTag.a(1, 0.0)).thenComparingDouble(listTag -> listTag.a(0, 0.0)).thenComparingDouble(listTag -> listTag.a(2, 0.0));
    private static final Codec<ResourceKey<Block>> d = ResourceKey.a(Registries.i);
    public static final String a = "data";
    private static final char e = '{';
    private static final char f = '}';
    private static final String g = ",";
    private static final char h = ':';
    private static final Splitter i = Splitter.on((String)",");
    private static final Splitter j = Splitter.on((char)':').limit(2);
    private static final Logger k = LogUtils.getLogger();
    private static final int l = 2;
    private static final int m = -1;

    private GameProfileSerializer() {
    }

    @VisibleForTesting
    public static boolean a(@Nullable NBTBase tag, @Nullable NBTBase other, boolean compareListTag) {
        if (tag == other) {
            return true;
        }
        if (tag == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!tag.getClass().equals(other.getClass())) {
            return false;
        }
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            NBTTagCompound compoundTag1 = (NBTTagCompound)other;
            if (compoundTag1.i() < compoundTag.i()) {
                return false;
            }
            for (Map.Entry<String, NBTBase> entry : compoundTag.g()) {
                NBTBase tag1 = entry.getValue();
                if (GameProfileSerializer.a(tag1, compoundTag1.a(entry.getKey()), compareListTag)) continue;
                return false;
            }
            return true;
        }
        if (tag instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)tag;
            if (compareListTag) {
                NBTTagList listTag1 = (NBTTagList)other;
                if (listTag.isEmpty()) {
                    return listTag1.isEmpty();
                }
                if (listTag1.size() < listTag.size()) {
                    return false;
                }
                for (NBTBase tag2 : listTag) {
                    boolean flag = false;
                    for (NBTBase tag3 : listTag1) {
                        if (!GameProfileSerializer.a(tag2, tag3, compareListTag)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    return false;
                }
                return true;
            }
        }
        return tag.equals(other);
    }

    public static IBlockData a(HolderGetter<Block> blockGetter, NBTTagCompound tag) {
        Optional optional = tag.a("Name", d).flatMap(blockGetter::a);
        if (optional.isEmpty()) {
            return Blocks.a.m();
        }
        Block block = (Block)((Holder)optional.get()).a();
        IBlockData blockState = block.m();
        Optional<NBTTagCompound> compound = tag.m("Properties");
        if (compound.isPresent()) {
            BlockStateList<Block, IBlockData> stateDefinition = block.l();
            for (String string : compound.get().e()) {
                IBlockState<?> property = stateDefinition.a(string);
                if (property == null) continue;
                blockState = GameProfileSerializer.a(blockState, property, string, compound.get(), tag);
            }
        }
        return blockState;
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S a(S stateHolder, IBlockState<T> property, String propertyName, NBTTagCompound propertiesTag, NBTTagCompound blockStateTag) {
        Optional optional = propertiesTag.i(propertyName).flatMap(property::b);
        if (optional.isPresent()) {
            return (S)((IBlockDataHolder)stateHolder.b(property, (Comparable)((Comparable)optional.get())));
        }
        k.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{propertyName, propertiesTag.a(propertyName), blockStateTag});
        return stateHolder;
    }

    public static NBTTagCompound a(IBlockData state) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", BuiltInRegistries.e.b(state.b()).toString());
        Map<IBlockState<?>, Comparable<?>> values = state.G();
        if (!values.isEmpty()) {
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> entry : values.entrySet()) {
                IBlockState<?> property = entry.getKey();
                compoundTag1.a(property.f(), GameProfileSerializer.a(property, entry.getValue()));
            }
            compoundTag.a("Properties", compoundTag1);
        }
        return compoundTag;
    }

    public static NBTTagCompound a(Fluid state) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", BuiltInRegistries.c.b(state.a()).toString());
        Map<IBlockState<?>, Comparable<?>> values = state.G();
        if (!values.isEmpty()) {
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> entry : values.entrySet()) {
                IBlockState<?> property = entry.getKey();
                compoundTag1.a(property.f(), GameProfileSerializer.a(property, entry.getValue()));
            }
            compoundTag.a("Properties", compoundTag1);
        }
        return compoundTag;
    }

    private static <T extends Comparable<T>> String a(IBlockState<T> property, Comparable<?> value) {
        return property.b(value);
    }

    public static String a(NBTBase tag) {
        return GameProfileSerializer.a(tag, false);
    }

    public static String a(NBTBase tag, boolean prettyPrintArray) {
        return GameProfileSerializer.a(new StringBuilder(), tag, 0, prettyPrintArray).toString();
    }

    public static StringBuilder a(StringBuilder stringBuilder, NBTBase tag, int indentLevel, boolean prettyPrintArray) {
        NBTBase nBTBase = tag;
        Objects.requireNonNull(nBTBase);
        NBTBase nBTBase2 = nBTBase;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTag.class, NBTTagEnd.class, NBTTagByteArray.class, NBTTagList.class, NBTTagIntArray.class, NBTTagCompound.class, NBTTagLongArray.class}, (Object)nBTBase2, n2)) {
            case 0 -> {
                PrimitiveTag primitiveTag = (PrimitiveTag)nBTBase2;
                yield stringBuilder.append(primitiveTag);
            }
            case 1 -> {
                NBTTagEnd endTag = (NBTTagEnd)nBTBase2;
                yield stringBuilder;
            }
            case 2 -> {
                NBTTagByteArray byteArrayTag = (NBTTagByteArray)nBTBase2;
                byte[] asByteArray = byteArrayTag.e();
                int i = asByteArray.length;
                GameProfileSerializer.a(indentLevel, stringBuilder).append("byte[").append(i).append("] {\n");
                if (prettyPrintArray) {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                    for (int i1 = 0; i1 < asByteArray.length; ++i1) {
                        if (i1 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i1 % 16 == 0 && i1 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i1 < asByteArray.length) {
                                GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                            }
                        } else if (i1 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%02X", asByteArray[i1] & 0xFF));
                    }
                } else {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(indentLevel, stringBuilder).append('}');
                yield stringBuilder;
            }
            case 3 -> {
                NBTTagList listTag = (NBTTagList)nBTBase2;
                int i = listTag.size();
                GameProfileSerializer.a(indentLevel, stringBuilder).append("list").append("[").append(i).append("] [");
                if (i != 0) {
                    stringBuilder.append('\n');
                }
                for (int i1 = 0; i1 < i; ++i1) {
                    if (i1 != 0) {
                        stringBuilder.append(",\n");
                    }
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                    GameProfileSerializer.a(stringBuilder, listTag.c(i1), indentLevel + 1, prettyPrintArray);
                }
                if (i != 0) {
                    stringBuilder.append('\n');
                }
                GameProfileSerializer.a(indentLevel, stringBuilder).append(']');
                yield stringBuilder;
            }
            case 4 -> {
                NBTTagIntArray intArrayTag = (NBTTagIntArray)nBTBase2;
                int[] asIntArray = intArrayTag.g();
                int i2 = 0;
                for (int i3 : asIntArray) {
                    i2 = Math.max(i2, String.format(Locale.ROOT, "%X", i3).length());
                }
                int i4 = asIntArray.length;
                GameProfileSerializer.a(indentLevel, stringBuilder).append("int[").append(i4).append("] {\n");
                if (prettyPrintArray) {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                    for (int i5 = 0; i5 < asIntArray.length; ++i5) {
                        if (i5 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i5 % 16 == 0 && i5 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i5 < asIntArray.length) {
                                GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                            }
                        } else if (i5 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + i2 + "X", asIntArray[i5]));
                    }
                } else {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(indentLevel, stringBuilder).append('}');
                yield stringBuilder;
            }
            case 5 -> {
                NBTTagCompound compoundTag = (NBTTagCompound)nBTBase2;
                ArrayList list = Lists.newArrayList(compoundTag.e());
                Collections.sort(list);
                GameProfileSerializer.a(indentLevel, stringBuilder).append('{');
                if (stringBuilder.length() - stringBuilder.lastIndexOf("\n") > 2 * (indentLevel + 1)) {
                    stringBuilder.append('\n');
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                }
                int i4 = list.stream().mapToInt(String::length).max().orElse(0);
                String repeated = Strings.repeat((String)" ", (int)i4);
                for (int i6 = 0; i6 < list.size(); ++i6) {
                    if (i6 != 0) {
                        stringBuilder.append(",\n");
                    }
                    String string = (String)list.get(i6);
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder).append('\"').append(string).append('\"').append(repeated, 0, repeated.length() - string.length()).append(": ");
                    GameProfileSerializer.a(stringBuilder, compoundTag.a(string), indentLevel + 1, prettyPrintArray);
                }
                if (!list.isEmpty()) {
                    stringBuilder.append('\n');
                }
                GameProfileSerializer.a(indentLevel, stringBuilder).append('}');
                yield stringBuilder;
            }
            case 6 -> {
                NBTTagLongArray longArrayTag = (NBTTagLongArray)nBTBase2;
                long[] asLongArray = longArrayTag.g();
                long l = 0L;
                for (long l1 : asLongArray) {
                    l = Math.max(l, (long)String.format(Locale.ROOT, "%X", l1).length());
                }
                long l2 = asLongArray.length;
                GameProfileSerializer.a(indentLevel, stringBuilder).append("long[").append(l2).append("] {\n");
                if (prettyPrintArray) {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                    for (int i7 = 0; i7 < asLongArray.length; ++i7) {
                        if (i7 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i7 % 16 == 0 && i7 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i7 < asLongArray.length) {
                                GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                            }
                        } else if (i7 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + l + "X", asLongArray[i7]));
                    }
                } else {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(indentLevel, stringBuilder).append('}');
                yield stringBuilder;
            }
            default -> throw new MatchException(null, null);
        };
    }

    private static StringBuilder a(int indentLevel, StringBuilder stringBuilder) {
        int i2 = stringBuilder.lastIndexOf("\n") + 1;
        int i1 = stringBuilder.length() - i2;
        for (int i22 = 0; i22 < 2 * indentLevel - i1; ++i22) {
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }

    public static IChatBaseComponent b(NBTBase tag) {
        return new TextComponentTagVisitor("").a(tag);
    }

    public static String a(NBTTagCompound tag) {
        return new SnbtPrinterTagVisitor().a((NBTBase)GameProfileSerializer.b(tag));
    }

    public static NBTTagCompound a(String text) throws CommandSyntaxException {
        return GameProfileSerializer.c(MojangsonParser.a(text));
    }

    @VisibleForTesting
    static NBTTagCompound b(NBTTagCompound tag) {
        NBTTagList listTag2;
        Optional<NBTTagList> list1;
        Optional<NBTTagList> list = tag.o("palettes");
        NBTTagList listOrEmpty = list.isPresent() ? list.get().f(0) : tag.p("palette");
        NBTTagList listTag = listOrEmpty.j().map(GameProfileSerializer::d).map(NBTTagString::a).collect(Collectors.toCollection(NBTTagList::new));
        tag.a("palette", listTag);
        if (list.isPresent()) {
            NBTTagList listTag1 = new NBTTagList();
            list.get().stream().flatMap(tag1 -> tag1.t_().stream()).forEach(listTag3 -> {
                NBTTagCompound compoundTag = new NBTTagCompound();
                for (int i2 = 0; i2 < listTag3.size(); ++i2) {
                    compoundTag.a(listTag.m(i2).orElseThrow(), GameProfileSerializer.d(listTag3.a(i2).orElseThrow()));
                }
                listTag1.add(compoundTag);
            });
            tag.a("palettes", listTag1);
        }
        if ((list1 = tag.o("entities")).isPresent()) {
            listTag2 = list1.get().j().sorted(Comparator.comparing(compoundTag -> compoundTag.o("pos"), Comparators.emptiesLast(c))).collect(Collectors.toCollection(NBTTagList::new));
            tag.a("entities", listTag2);
        }
        listTag2 = tag.o("blocks").stream().flatMap(NBTTagList::j).sorted(Comparator.comparing(compoundTag -> compoundTag.o("pos"), Comparators.emptiesLast(b))).peek(compoundTag -> compoundTag.a("state", listTag.m(compoundTag.b("state", 0)).orElseThrow())).collect(Collectors.toCollection(NBTTagList::new));
        tag.a(a, listTag2);
        tag.r("blocks");
        return tag;
    }

    @VisibleForTesting
    static NBTTagCompound c(NBTTagCompound tag) {
        NBTTagList listOrEmpty = tag.p("palette");
        Map map = (Map)listOrEmpty.stream().flatMap(tag1 -> tag1.p_().stream()).collect(ImmutableMap.toImmutableMap(Function.identity(), GameProfileSerializer::b));
        Optional<NBTTagList> list = tag.o("palettes");
        if (list.isPresent()) {
            tag.a("palettes", list.get().j().map(compoundTag1 -> map.keySet().stream().map(string1 -> compoundTag1.i((String)string1).orElseThrow()).map(GameProfileSerializer::b).collect(Collectors.toCollection(NBTTagList::new))).collect(Collectors.toCollection(NBTTagList::new)));
            tag.r("palette");
        } else {
            tag.a("palette", map.values().stream().collect(Collectors.toCollection(NBTTagList::new)));
        }
        Optional<NBTTagList> list1 = tag.o(a);
        if (list1.isPresent()) {
            Object2IntOpenHashMap map1 = new Object2IntOpenHashMap();
            map1.defaultReturnValue(-1);
            for (int i2 = 0; i2 < listOrEmpty.size(); ++i2) {
                map1.put((Object)listOrEmpty.m(i2).orElseThrow(), i2);
            }
            NBTTagList listTag = list1.get();
            for (int i1 = 0; i1 < listTag.size(); ++i1) {
                NBTTagCompound compoundTag = listTag.a(i1).orElseThrow();
                String string = compoundTag.i("state").orElseThrow();
                int _int = map1.getInt((Object)string);
                if (_int == -1) {
                    throw new IllegalStateException("Entry " + string + " missing from palette");
                }
                compoundTag.a("state", _int);
            }
            tag.a("blocks", listTag);
            tag.r(a);
        }
        return tag;
    }

    @VisibleForTesting
    static String d(NBTTagCompound tag) {
        StringBuilder stringBuilder = new StringBuilder(tag.i("Name").orElseThrow());
        tag.m("Properties").ifPresent(compoundTag -> {
            String string = compoundTag.g().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + ":" + ((NBTBase)entry.getValue()).p_().orElseThrow()).collect(Collectors.joining(g));
            stringBuilder.append('{').append(string).append('}');
        });
        return stringBuilder.toString();
    }

    @VisibleForTesting
    static NBTTagCompound b(String blockStateText) {
        String sub;
        NBTTagCompound compoundTag = new NBTTagCompound();
        int index = blockStateText.indexOf(123);
        if (index >= 0) {
            sub = blockStateText.substring(0, index);
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            if (index + 2 <= blockStateText.length()) {
                String sub1 = blockStateText.substring(index + 1, blockStateText.indexOf(125, index));
                i.split((CharSequence)sub1).forEach(string -> {
                    List parts = j.splitToList((CharSequence)string);
                    if (parts.size() == 2) {
                        compoundTag1.a((String)parts.get(0), (String)parts.get(1));
                    } else {
                        k.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)blockStateText);
                    }
                });
                compoundTag.a("Properties", compoundTag1);
            }
        } else {
            sub = blockStateText;
        }
        compoundTag.a("Name", sub);
        return compoundTag;
    }

    public static NBTTagCompound e(NBTTagCompound tag) {
        int version = SharedConstants.b().a().b();
        return GameProfileSerializer.a(tag, version);
    }

    public static NBTTagCompound a(NBTTagCompound tag, int dataVersion) {
        tag.a("DataVersion", dataVersion);
        return tag;
    }

    public static Dynamic<NBTBase> a(Dynamic<NBTBase> dynamic) {
        int version = SharedConstants.b().a().b();
        return GameProfileSerializer.a(dynamic, version);
    }

    public static Dynamic<NBTBase> a(Dynamic<NBTBase> dynamic, int dataVersion) {
        return dynamic.set("DataVersion", dynamic.createInt(dataVersion));
    }

    public static void a(ValueOutput output) {
        int version = SharedConstants.b().a().b();
        GameProfileSerializer.a(output, version);
    }

    public static void a(ValueOutput output, int dataVersion) {
        output.a("DataVersion", dataVersion);
    }

    public static int f(NBTTagCompound tag) {
        return GameProfileSerializer.b(tag, -1);
    }

    public static int b(NBTTagCompound tag, int defaultValue) {
        return tag.b("DataVersion", defaultValue);
    }

    public static int b(Dynamic<?> tag, int defaultValue) {
        return tag.get("DataVersion").asInt(defaultValue);
    }
}

