/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.SystemUtils;
import org.jspecify.annotations.Nullable;
import org.spigotmc.LimitStream;

public class NBTCompressedStreamTools {
    private static final OpenOption[] a = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static NBTTagCompound a(Path path, NBTReadLimiter accounter) throws IOException {
        NBTTagCompound var4;
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream inputStream1 = new FastBufferedInputStream(inputStream);){
            var4 = NBTCompressedStreamTools.a(inputStream1, accounter);
        }
        return var4;
    }

    private static DataInputStream a(InputStream zippedStream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(zippedStream)));
    }

    private static DataOutputStream a(OutputStream outputStream) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputStream)));
    }

    public static NBTTagCompound a(InputStream zippedStream, NBTReadLimiter accounter) throws IOException {
        NBTTagCompound var3;
        try (DataInputStream dataInputStream = NBTCompressedStreamTools.a(zippedStream);){
            var3 = NBTCompressedStreamTools.a(dataInputStream, accounter);
        }
        return var3;
    }

    public static void a(Path path, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream inputStream1 = new FastBufferedInputStream(inputStream);){
            NBTCompressedStreamTools.a(inputStream1, visitor, accounter);
        }
    }

    public static void a(InputStream zippedStream, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
        try (DataInputStream dataInputStream = NBTCompressedStreamTools.a(zippedStream);){
            NBTCompressedStreamTools.a((DataInput)dataInputStream, visitor, accounter);
        }
    }

    public static void a(NBTTagCompound tag, Path path) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, a);
             BufferedOutputStream outputStream1 = new BufferedOutputStream(outputStream);){
            NBTCompressedStreamTools.a(tag, outputStream1);
        }
    }

    public static void a(NBTTagCompound tag, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataOutputStream = NBTCompressedStreamTools.a(outputStream);){
            NBTCompressedStreamTools.a(tag, (DataOutput)dataOutputStream);
        }
    }

    public static void b(NBTTagCompound tag, Path path) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, a);
             BufferedOutputStream outputStream1 = new BufferedOutputStream(outputStream);
             DataOutputStream dataOutputStream = new DataOutputStream(outputStream1);){
            NBTCompressedStreamTools.a(tag, (DataOutput)dataOutputStream);
        }
    }

    public static @Nullable NBTTagCompound a(Path path) throws IOException {
        NBTTagCompound var3;
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
             DataInputStream dataInputStream = new DataInputStream(inputStream);){
            var3 = NBTCompressedStreamTools.a(dataInputStream, NBTReadLimiter.c());
        }
        return var3;
    }

    public static NBTTagCompound a(DataInput input) throws IOException {
        return NBTCompressedStreamTools.a(input, NBTReadLimiter.c());
    }

    public static NBTTagCompound a(DataInput input, NBTReadLimiter accounter) throws IOException {
        NBTBase unnamedTag;
        if (input instanceof ByteBufInputStream) {
            ByteBufInputStream byteBufInputStream = (ByteBufInputStream)input;
            input = new DataInputStream(new LimitStream((InputStream)byteBufInputStream, accounter));
        }
        if ((unnamedTag = NBTCompressedStreamTools.c(input, accounter)) instanceof NBTTagCompound) {
            return (NBTTagCompound)unnamedTag;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void a(NBTTagCompound tag, DataOutput output) throws IOException {
        NBTCompressedStreamTools.c(tag, output);
    }

    public static void a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
        NBTTagType<?> type = NBTTagTypes.a(input.readByte());
        if (type == NBTTagEnd.a) {
            if (visitor.b(NBTTagEnd.a) == StreamTagVisitor.b.a) {
                visitor.a();
            }
        } else {
            switch (visitor.b(type)) {
                default: {
                    break;
                }
                case b: {
                    NBTTagString.a(input);
                    type.b(input, accounter);
                    break;
                }
                case a: {
                    NBTTagString.a(input);
                    type.a(input, visitor, accounter);
                }
            }
        }
    }

    public static NBTBase b(DataInput input, NBTReadLimiter accounter) throws IOException {
        byte _byte = input.readByte();
        return _byte == 0 ? NBTTagEnd.b : NBTCompressedStreamTools.a(input, accounter, _byte);
    }

    public static void a(NBTBase tag, DataOutput output) throws IOException {
        output.writeByte(tag.b());
        if (tag.b() != 0) {
            tag.a(output);
        }
    }

    public static void b(NBTBase tag, DataOutput output) throws IOException {
        output.writeByte(tag.b());
        if (tag.b() != 0) {
            output.writeUTF("");
            tag.a(output);
        }
    }

    public static void c(NBTBase tag, DataOutput output) throws IOException {
        NBTCompressedStreamTools.b(tag, new a(output));
    }

    @VisibleForTesting
    public static NBTBase c(DataInput input, NBTReadLimiter accounter) throws IOException {
        byte _byte = input.readByte();
        if (_byte == 0) {
            return NBTTagEnd.b;
        }
        NBTTagString.a(input);
        return NBTCompressedStreamTools.a(input, accounter, _byte);
    }

    private static NBTBase a(DataInput input, NBTReadLimiter accounter, byte type) {
        try {
            return NBTTagTypes.a(type).c(input, accounter);
        }
        catch (IOException var6) {
            CrashReport crashReport = CrashReport.a(var6, "Loading NBT data");
            CrashReportSystemDetails crashReportCategory = crashReport.a("NBT Tag");
            crashReportCategory.a("Tag type", type);
            throw new ReportedNbtException(crashReport);
        }
    }

    public static class a
    extends DelegateDataOutput {
        public a(DataOutput parent) {
            super(parent);
        }

        @Override
        public void writeUTF(String value) throws IOException {
            try {
                super.writeUTF(value);
            }
            catch (UTFDataFormatException var3) {
                SystemUtils.a("Failed to write NBT String", (Throwable)var3);
                super.writeUTF("");
            }
        }
    }
}

