/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.nbt.NbtAccounterException;

public class NBTReadLimiter {
    public static final int a = 0x200000;
    public static final int b = 0x6400000;
    private static final int c = 512;
    private final long d;
    private long e;
    private final int f;
    private int g;

    public NBTReadLimiter(long quota, int maxDepth) {
        this.d = quota;
        this.f = maxDepth;
    }

    public static NBTReadLimiter a(long quota) {
        return new NBTReadLimiter(quota, 512);
    }

    public static NBTReadLimiter a() {
        return new NBTReadLimiter(0x200000L, 512);
    }

    public static NBTReadLimiter b() {
        return new NBTReadLimiter(0x6400000L, 512);
    }

    public static NBTReadLimiter c() {
        return new NBTReadLimiter(Long.MAX_VALUE, 512);
    }

    public void a(long bytesPerItem, long items) {
        this.b(bytesPerItem * items);
    }

    public void b(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Tried to account NBT tag with negative size: " + bytes);
        }
        if (this.e + bytes > this.d) {
            throw new NbtAccounterException("Tried to read NBT tag that was too big; tried to allocate: " + this.e + " + " + bytes + " bytes where max allowed: " + this.d);
        }
        this.e += bytes;
    }

    public void d() {
        if (this.g >= this.f) {
            throw new NbtAccounterException("Tried to read NBT tag with too high complexity, depth > " + this.f);
        }
        ++this.g;
    }

    public void e() {
        if (this.g <= 0) {
            throw new NbtAccounterException("NBT-Accounter tried to pop stack-depth at top-level");
        }
        --this.g;
    }

    @VisibleForTesting
    public long f() {
        return this.e;
    }

    @VisibleForTesting
    public int g() {
        return this.g;
    }
}

