/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public final class NBTTagCompound
implements NBTBase {
    private static final Logger c = LogUtils.getLogger();
    public static final Codec<NBTTagCompound> a = Codec.PASSTHROUGH.comapFlatMap(tag -> {
        NBTTagCompound compoundTag;
        NBTBase tag1 = tag.convert(DynamicOpsNBT.a).getValue();
        return tag1 instanceof NBTTagCompound ? DataResult.success((Object)((compoundTag = (NBTTagCompound)tag1) == tag.getValue() ? compoundTag.l() : compoundTag)) : DataResult.error(() -> "Not a compound tag: " + String.valueOf(tag1));
    }, tag -> new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, tag.l()));
    private static final int v = 48;
    private static final int w = 32;
    public static final NBTTagType<NBTTagCompound> b = new NBTTagType.b<NBTTagCompound>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NBTTagCompound a(DataInput input, NBTReadLimiter accounter) throws IOException {
            NBTTagCompound var3;
            accounter.d();
            try {
                var3 = 1.d(input, accounter);
            }
            finally {
                accounter.e();
            }
            return var3;
        }

        private static NBTTagCompound d(DataInput input, NBTReadLimiter nbtAccounter) throws IOException {
            byte b2;
            nbtAccounter.b(48L);
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(8, 0.8f);
            while ((b2 = input.readByte()) != 0) {
                NBTBase namedTagData;
                String string = 1.e(input, nbtAccounter);
                if (map.put((Object)string, (Object)(namedTagData = NBTTagCompound.a(NBTTagTypes.a(b2), string, input, nbtAccounter))) != null) continue;
                nbtAccounter.b(36L);
            }
            return new NBTTagCompound((Map<String, NBTBase>)map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            StreamTagVisitor.b var4;
            accounter.d();
            try {
                var4 = 1.c(input, visitor, accounter);
            }
            finally {
                accounter.e();
            }
            return var4;
        }

        private static StreamTagVisitor.b c(DataInput input, StreamTagVisitor visitor, NBTReadLimiter nbtAccounter) throws IOException {
            byte b2;
            nbtAccounter.b(48L);
            block13: while ((b2 = input.readByte()) != 0) {
                NBTTagType<?> type = NBTTagTypes.a(b2);
                switch (visitor.a(type)) {
                    case d: {
                        return StreamTagVisitor.b.c;
                    }
                    case c: {
                        NBTTagString.a(input);
                        type.b(input, nbtAccounter);
                        break block13;
                    }
                    case b: {
                        NBTTagString.a(input);
                        type.b(input, nbtAccounter);
                        continue block13;
                    }
                    default: {
                        String string = 1.e(input, nbtAccounter);
                        switch (visitor.a(type, string)) {
                            case d: {
                                return StreamTagVisitor.b.c;
                            }
                            case c: {
                                type.b(input, nbtAccounter);
                                break block13;
                            }
                            case b: {
                                type.b(input, nbtAccounter);
                                continue block13;
                            }
                        }
                        nbtAccounter.b(36L);
                        switch (type.a(input, visitor, nbtAccounter)) {
                            case c: {
                                return StreamTagVisitor.b.c;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (b2 != 0) {
                while ((b2 = input.readByte()) != 0) {
                    NBTTagString.a(input);
                    NBTTagTypes.a(b2).b(input, nbtAccounter);
                }
            }
            return visitor.b();
        }

        private static String e(DataInput input, NBTReadLimiter accounter) throws IOException {
            String utf = input.readUTF();
            accounter.b(28L);
            accounter.a(2L, utf.length());
            return utf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.d();
            try {
                byte b2;
                while ((b2 = input.readByte()) != 0) {
                    NBTTagString.a(input);
                    NBTTagTypes.a(b2).b(input, accounter);
                }
            }
            finally {
                accounter.e();
            }
        }

        @Override
        public String a() {
            return "COMPOUND";
        }

        @Override
        public String b() {
            return "TAG_Compound";
        }
    };
    private final Map<String, NBTBase> x;

    NBTTagCompound(Map<String, NBTBase> tags) {
        this.x = tags;
    }

    public NBTTagCompound() {
        this((Map<String, NBTBase>)new Object2ObjectOpenHashMap(8, 0.8f));
    }

    @Override
    public void a(DataOutput output) throws IOException {
        for (String string : this.x.keySet()) {
            NBTBase tag = this.x.get(string);
            NBTTagCompound.a(string, tag, output);
        }
        output.writeByte(0);
    }

    @Override
    public int a() {
        int i2 = 48;
        for (Map.Entry<String, NBTBase> entry : this.x.entrySet()) {
            i2 += 28 + 2 * entry.getKey().length();
            i2 += 36;
            i2 += entry.getValue().a();
        }
        return i2;
    }

    public Set<String> e() {
        return this.x.keySet();
    }

    public Set<Map.Entry<String, NBTBase>> g() {
        return this.x.entrySet();
    }

    public Collection<NBTBase> h() {
        return this.x.values();
    }

    public void a(BiConsumer<String, NBTBase> action) {
        this.x.forEach(action);
    }

    @Override
    public byte b() {
        return 10;
    }

    public NBTTagType<NBTTagCompound> c() {
        return b;
    }

    public int i() {
        return this.x.size();
    }

    public @Nullable NBTBase a(String key, NBTBase value) {
        return this.x.put(key, value);
    }

    public void a(String key, byte value) {
        this.x.put(key, NBTTagByte.a(value));
    }

    public void a(String key, short value) {
        this.x.put(key, NBTTagShort.a(value));
    }

    public void a(String key, int value) {
        this.x.put(key, NBTTagInt.a(value));
    }

    public void a(String key, long value) {
        this.x.put(key, NBTTagLong.a(value));
    }

    public void a(String key, float value) {
        this.x.put(key, NBTTagFloat.a(value));
    }

    public void a(String key, double value) {
        this.x.put(key, NBTTagDouble.a(value));
    }

    public void a(String key, String value) {
        this.x.put(key, NBTTagString.a(value));
    }

    public void a(String key, byte[] value) {
        this.x.put(key, new NBTTagByteArray(value));
    }

    public void a(String key, int[] value) {
        this.x.put(key, new NBTTagIntArray(value));
    }

    public void a(String key, long[] value) {
        this.x.put(key, new NBTTagLongArray(value));
    }

    public void a(String key, boolean value) {
        this.x.put(key, NBTTagByte.a(value));
    }

    public @Nullable NBTBase a(String key) {
        return this.x.get(key);
    }

    public boolean b(String key) {
        return this.x.containsKey(key);
    }

    private Optional<NBTBase> s(String key) {
        return Optional.ofNullable(this.x.get(key));
    }

    public Optional<Byte> c(String key) {
        return this.s(key).flatMap(NBTBase::p);
    }

    public byte b(String key, byte defaultValue) {
        byte by;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            by = numericTag.j();
        } else {
            by = defaultValue;
        }
        return by;
    }

    public Optional<Short> d(String key) {
        return this.s(key).flatMap(NBTBase::q);
    }

    public short b(String key, short defaultValue) {
        short s2;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            s2 = numericTag.i();
        } else {
            s2 = defaultValue;
        }
        return s2;
    }

    public Optional<Integer> e(String key) {
        return this.s(key).flatMap(NBTBase::r);
    }

    public int b(String key, int defaultValue) {
        int n2;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            n2 = numericTag.h();
        } else {
            n2 = defaultValue;
        }
        return n2;
    }

    public Optional<Long> f(String key) {
        return this.s(key).flatMap(NBTBase::s);
    }

    public long b(String key, long defaultValue) {
        long l2;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            l2 = numericTag.g();
        } else {
            l2 = defaultValue;
        }
        return l2;
    }

    public Optional<Float> g(String key) {
        return this.s(key).flatMap(NBTBase::t);
    }

    public float b(String key, float defaultValue) {
        float f2;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            f2 = numericTag.l();
        } else {
            f2 = defaultValue;
        }
        return f2;
    }

    public Optional<Double> h(String key) {
        return this.s(key).flatMap(NBTBase::u);
    }

    public double b(String key, double defaultValue) {
        double d2;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            d2 = numericTag.k();
        } else {
            d2 = defaultValue;
        }
        return d2;
    }

    public Optional<String> i(String key) {
        return this.s(key).flatMap(NBTBase::p_);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String b(String key, String defaultValue) {
        String string;
        NBTBase nBTBase = this.x.get(key);
        if (!(nBTBase instanceof NBTTagString)) {
            string = defaultValue;
            return string;
        }
        NBTTagString nBTTagString = (NBTTagString)nBTBase;
        try {
            String string2;
            String var8;
            string = var8 = (string2 = nBTTagString.k());
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public Optional<byte[]> j(String key) {
        Optional<byte[]> optional;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTTagByteArray) {
            NBTTagByteArray byteArrayTag = (NBTTagByteArray)nBTBase;
            optional = Optional.of(byteArrayTag.e());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<int[]> k(String key) {
        Optional<int[]> optional;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTTagIntArray) {
            NBTTagIntArray intArrayTag = (NBTTagIntArray)nBTBase;
            optional = Optional.of(intArrayTag.g());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<long[]> l(String key) {
        Optional<long[]> optional;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTTagLongArray) {
            NBTTagLongArray longArrayTag = (NBTTagLongArray)nBTBase;
            optional = Optional.of(longArrayTag.g());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<NBTTagCompound> m(String key) {
        Optional<NBTTagCompound> optional;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)nBTBase;
            optional = Optional.of(compoundTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public NBTTagCompound n(String key) {
        return this.m(key).orElseGet(NBTTagCompound::new);
    }

    public Optional<NBTTagList> o(String key) {
        Optional<NBTTagList> optional;
        NBTBase nBTBase = this.x.get(key);
        if (nBTBase instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)nBTBase;
            optional = Optional.of(listTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public NBTTagList p(String key) {
        return this.o(key).orElseGet(NBTTagList::new);
    }

    public Optional<Boolean> q(String key) {
        return this.s(key).flatMap(NBTBase::v);
    }

    public boolean b(String key, boolean defaultValue) {
        return this.b(key, (byte)(defaultValue ? 1 : 0)) != 0;
    }

    public @Nullable NBTBase r(String key) {
        return this.x.remove(key);
    }

    @Override
    public String toString() {
        StringTagVisitor stringTagVisitor = new StringTagVisitor();
        stringTagVisitor.a(this);
        return stringTagVisitor.a();
    }

    public boolean j() {
        return this.x.isEmpty();
    }

    protected NBTTagCompound k() {
        return new NBTTagCompound(new HashMap<String, NBTBase>(this.x));
    }

    public NBTTagCompound l() {
        ObjectIterator iterator;
        Object2ObjectOpenHashMap ret = new Object2ObjectOpenHashMap(this.x.size(), 0.8f);
        ObjectIterator objectIterator = iterator = this.x instanceof Object2ObjectOpenHashMap ? ((Object2ObjectOpenHashMap)this.x).object2ObjectEntrySet().fastIterator() : this.x.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put((Object)((String)entry.getKey()), (Object)((NBTBase)entry.getValue()).d());
        }
        return new NBTTagCompound((Map<String, NBTBase>)ret);
    }

    @Override
    public Optional<NBTTagCompound> s_() {
        return Optional.of(this);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagCompound && Objects.equals(this.x, ((NBTTagCompound)other).x);
    }

    public int hashCode() {
        return this.x.hashCode();
    }

    private static void a(String name, NBTBase tag, DataOutput output) throws IOException {
        output.writeByte(tag.b());
        if (tag.b() != 0) {
            output.writeUTF(name);
            tag.a(output);
        }
    }

    static NBTBase a(NBTTagType<?> type, String name, DataInput input, NBTReadLimiter accounter) {
        try {
            return type.c(input, accounter);
        }
        catch (IOException var7) {
            CrashReport crashReport = CrashReport.a(var7, "Loading NBT data");
            CrashReportSystemDetails crashReportCategory = crashReport.a("NBT Tag");
            crashReportCategory.a("Tag name", name);
            crashReportCategory.a("Tag type", type.a());
            throw new ReportedNbtException(crashReport);
        }
    }

    public NBTTagCompound a(NBTTagCompound other) {
        for (String string : other.x.keySet()) {
            NBTBase tag = other.x.get(string);
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                NBTBase nBTBase = this.x.get(string);
                if (nBTBase instanceof NBTTagCompound) {
                    NBTTagCompound compoundTag1 = (NBTTagCompound)nBTBase;
                    compoundTag1.a(compoundTag);
                    continue;
                }
            }
            this.a(string, tag.d());
        }
        return this;
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        block14: for (Map.Entry<String, NBTBase> entry : this.x.entrySet()) {
            NBTBase tag = entry.getValue();
            NBTTagType<?> type = tag.c();
            StreamTagVisitor.a entryResult = visitor.a(type);
            switch (entryResult) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                case b: {
                    continue block14;
                }
            }
            entryResult = visitor.a(type, entry.getKey());
            switch (entryResult) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                case b: {
                    continue block14;
                }
            }
            StreamTagVisitor.b valueResult = tag.a(visitor);
            switch (valueResult) {
                case c: {
                    return StreamTagVisitor.b.c;
                }
                case b: {
                    return visitor.b();
                }
            }
        }
        return visitor.b();
    }

    public <T> void a(String key, Codec<T> codec, T data) {
        this.a(key, codec, DynamicOpsNBT.a, data);
    }

    public <T> void b(String key, Codec<T> codec, @Nullable T data) {
        if (data != null) {
            this.a(key, codec, data);
        }
    }

    public <T> void a(String key, Codec<T> codec, DynamicOps<NBTBase> ops, T data) {
        this.a(key, (NBTBase)codec.encodeStart(ops, data).getOrThrow());
    }

    public <T> void b(String key, Codec<T> codec, DynamicOps<NBTBase> ops, @Nullable T data) {
        if (data != null) {
            this.a(key, codec, ops, data);
        }
    }

    public <T> void a(MapCodec<T> mapCodec, T data) {
        this.a(mapCodec, DynamicOpsNBT.a, data);
    }

    public <T> void a(MapCodec<T> mapCodec, DynamicOps<NBTBase> ops, T data) {
        this.a((NBTTagCompound)mapCodec.encoder().encodeStart(ops, data).getOrThrow());
    }

    public <T> Optional<T> a(String key, Codec<T> codec) {
        return this.a(key, codec, DynamicOpsNBT.a);
    }

    public <T> Optional<T> a(String key, Codec<T> codec, DynamicOps<NBTBase> ops) {
        NBTBase tag = this.a(key);
        return tag == null ? Optional.empty() : codec.parse(ops, (Object)tag).resultOrPartial(string -> c.error("Failed to read field ({}={}): {}", new Object[]{key, tag, string}));
    }

    public <T> Optional<T> a(MapCodec<T> mapCodec) {
        return this.a(mapCodec, DynamicOpsNBT.a);
    }

    public <T> Optional<T> a(MapCodec<T> mapCodec, DynamicOps<NBTBase> ops) {
        return mapCodec.decode(ops, (MapLike)ops.getMap((Object)this).getOrThrow()).resultOrPartial(string -> c.error("Failed to read value ({}): {}", (Object)this, string));
    }

    public <T> Optional<T> readQuiet(String key, Codec<T> codec) {
        return this.readQuiet(key, codec, DynamicOpsNBT.a);
    }

    public <T> Optional<T> readQuiet(String key, Codec<T> codec, DynamicOps<NBTBase> ops) {
        NBTBase tag = this.a(key);
        return tag == null ? Optional.empty() : codec.parse(ops, (Object)tag).resultOrPartial();
    }

    public <T> Optional<T> readQuiet(MapCodec<T> mapCodec) {
        return this.readQuiet(mapCodec, DynamicOpsNBT.a);
    }

    public <T> Optional<T> readQuiet(MapCodec<T> mapCodec, DynamicOps<NBTBase> ops) {
        return mapCodec.decode(ops, (MapLike)ops.getMap((Object)this).getOrThrow()).resultOrPartial();
    }
}

