/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.jspecify.annotations.Nullable;

public final class NBTTagList
extends AbstractList<NBTBase>
implements NBTList {
    private static final String b = "";
    private static final int c = 36;
    public static final NBTTagType<NBTTagList> a = new NBTTagType.b<NBTTagList>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NBTTagList a(DataInput input, NBTReadLimiter accounter) throws IOException {
            NBTTagList var3;
            accounter.d();
            try {
                var3 = 1.d(input, accounter);
            }
            finally {
                accounter.e();
            }
            return var3;
        }

        private static NBTTagList d(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b(36L);
            byte _byte = input.readByte();
            int listCount = 1.a(input);
            if (_byte == 0 && listCount > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            accounter.a(4L, listCount);
            NBTTagType<?> type = NBTTagTypes.a(_byte);
            NBTTagList listTag = new NBTTagList(new ArrayList<NBTBase>(listCount));
            for (int i2 = 0; i2 < listCount; ++i2) {
                listTag.a((NBTBase)type.c(input, accounter));
            }
            return listTag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            StreamTagVisitor.b var4;
            accounter.d();
            try {
                var4 = 1.c(input, visitor, accounter);
            }
            finally {
                accounter.e();
            }
            return var4;
        }

        private static StreamTagVisitor.b c(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            accounter.b(36L);
            NBTTagType<?> type = NBTTagTypes.a(input.readByte());
            int listCount = 1.a(input);
            switch (visitor.a(type, listCount)) {
                case c: {
                    return StreamTagVisitor.b.c;
                }
                case b: {
                    type.a(input, listCount, accounter);
                    return visitor.b();
                }
            }
            accounter.a(4L, listCount);
            int i2 = 0;
            while (true) {
                block16: {
                    int i1;
                    block15: {
                        if (i2 >= listCount) break block15;
                        block4 : switch (visitor.b(type, i2)) {
                            case d: {
                                return StreamTagVisitor.b.c;
                            }
                            case c: {
                                type.b(input, accounter);
                                break;
                            }
                            case b: {
                                type.b(input, accounter);
                                break block16;
                            }
                            default: {
                                switch (type.a(input, visitor, accounter)) {
                                    case c: {
                                        return StreamTagVisitor.b.c;
                                    }
                                    case b: {
                                        break block4;
                                    }
                                }
                                break block16;
                            }
                        }
                    }
                    if ((i1 = listCount - 1 - i2) > 0) {
                        type.a(input, i1, accounter);
                    }
                    return visitor.b();
                }
                ++i2;
            }
        }

        private static int a(DataInput dataInput) throws IOException {
            int _int = dataInput.readInt();
            if (_int < 0) {
                throw new NbtFormatException("ListTag length cannot be negative: " + _int);
            }
            return _int;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.d();
            try {
                NBTTagType<?> type = NBTTagTypes.a(input.readByte());
                int _int = input.readInt();
                type.a(input, _int, accounter);
            }
            finally {
                accounter.e();
            }
        }

        @Override
        public String a() {
            return "LIST";
        }

        @Override
        public String b() {
            return "TAG_List";
        }
    };
    private final List<NBTBase> v;

    public NBTTagList() {
        this(new ArrayList<NBTBase>());
    }

    public NBTTagList(List<NBTBase> list) {
        this.v = list;
    }

    private static NBTBase a(NBTTagCompound tag) {
        NBTBase tag1;
        if (tag.i() == 1 && (tag1 = tag.a(b)) != null) {
            return tag1;
        }
        return tag;
    }

    private static boolean b(NBTTagCompound tag) {
        return tag.i() == 1 && tag.b(b);
    }

    private static NBTBase a(byte elementType, NBTBase tag) {
        NBTTagCompound compoundTag;
        if (elementType != 10) {
            return tag;
        }
        return tag instanceof NBTTagCompound && !NBTTagList.b(compoundTag = (NBTTagCompound)tag) ? compoundTag : NBTTagList.b(tag);
    }

    private static NBTTagCompound b(NBTBase tag) {
        return new NBTTagCompound(Map.of(b, tag));
    }

    @Override
    public void a(DataOutput output) throws IOException {
        byte b2 = this.e();
        output.writeByte(b2);
        output.writeInt(this.v.size());
        for (NBTBase tag : this.v) {
            NBTTagList.a(b2, tag).a(output);
        }
    }

    @VisibleForTesting
    public byte e() {
        byte b2 = 0;
        for (NBTBase tag : this.v) {
            byte id = tag.b();
            if (b2 == 0) {
                b2 = id;
                continue;
            }
            if (b2 == id) continue;
            return 10;
        }
        return b2;
    }

    public void a(NBTBase tag) {
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            this.add(NBTTagList.a(compoundTag));
        } else {
            this.add(tag);
        }
    }

    @Override
    public int a() {
        int i2 = 36;
        i2 += 4 * this.v.size();
        for (NBTBase tag : this.v) {
            i2 += tag.a();
        }
        return i2;
    }

    @Override
    public byte b() {
        return 9;
    }

    public NBTTagType<NBTTagList> c() {
        return a;
    }

    @Override
    public String toString() {
        StringTagVisitor stringTagVisitor = new StringTagVisitor();
        stringTagVisitor.a(this);
        return stringTagVisitor.a();
    }

    @Override
    public NBTBase d(int index) {
        return this.v.remove(index);
    }

    @Override
    public boolean isEmpty() {
        return this.v.isEmpty();
    }

    public Optional<NBTTagCompound> a(int index) {
        Optional<NBTTagCompound> optional;
        NBTBase nBTBase = this.n(index);
        if (nBTBase instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)nBTBase;
            optional = Optional.of(compoundTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public NBTTagCompound b(int index) {
        return this.a(index).orElseGet(NBTTagCompound::new);
    }

    public Optional<NBTTagList> e(int index) {
        Optional<NBTTagList> optional;
        NBTBase nBTBase = this.n(index);
        if (nBTBase instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)nBTBase;
            optional = Optional.of(listTag);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public NBTTagList f(int index) {
        return this.e(index).orElseGet(NBTTagList::new);
    }

    public Optional<Short> g(int index) {
        return this.o(index).flatMap(NBTBase::q);
    }

    public short a(int index, short defaultValue) {
        short s2;
        NBTBase nBTBase = this.n(index);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            s2 = numericTag.i();
        } else {
            s2 = defaultValue;
        }
        return s2;
    }

    public Optional<Integer> h(int index) {
        return this.o(index).flatMap(NBTBase::r);
    }

    public int a(int index, int defaultValue) {
        int n2;
        NBTBase nBTBase = this.n(index);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            n2 = numericTag.h();
        } else {
            n2 = defaultValue;
        }
        return n2;
    }

    public Optional<int[]> i(int index) {
        Optional<int[]> optional;
        NBTBase nBTBase = this.n(index);
        if (nBTBase instanceof NBTTagIntArray) {
            NBTTagIntArray intArrayTag = (NBTTagIntArray)nBTBase;
            optional = Optional.of(intArrayTag.g());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<long[]> j(int index) {
        Optional<long[]> optional;
        NBTBase nBTBase = this.n(index);
        if (nBTBase instanceof NBTTagLongArray) {
            NBTTagLongArray longArrayTag = (NBTTagLongArray)nBTBase;
            optional = Optional.of(longArrayTag.g());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    public Optional<Double> k(int index) {
        return this.o(index).flatMap(NBTBase::u);
    }

    public double a(int index, double defaultValue) {
        double d2;
        NBTBase nBTBase = this.n(index);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            d2 = numericTag.k();
        } else {
            d2 = defaultValue;
        }
        return d2;
    }

    public Optional<Float> l(int index) {
        return this.o(index).flatMap(NBTBase::t);
    }

    public float a(int index, float defaultValue) {
        float f2;
        NBTBase nBTBase = this.n(index);
        if (nBTBase instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)nBTBase;
            f2 = numericTag.l();
        } else {
            f2 = defaultValue;
        }
        return f2;
    }

    public Optional<String> m(int index) {
        return this.o(index).flatMap(NBTBase::p_);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String a(int index, String defaultValue) {
        String string;
        NBTBase nBTBase = this.n(index);
        if (!(nBTBase instanceof NBTTagString)) {
            string = defaultValue;
            return string;
        }
        NBTTagString nBTTagString = (NBTTagString)nBTBase;
        try {
            String string2;
            String var8;
            string = var8 = (string2 = nBTTagString.k());
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private @Nullable NBTBase n(int index) {
        return index >= 0 && index < this.v.size() ? this.v.get(index) : null;
    }

    private Optional<NBTBase> o(int index) {
        return Optional.ofNullable(this.n(index));
    }

    @Override
    public int size() {
        return this.v.size();
    }

    @Override
    public NBTBase c(int index) {
        return this.v.get(index);
    }

    public NBTBase c(int i2, NBTBase tag) {
        return this.v.set(i2, tag);
    }

    public void d(int i2, NBTBase tag) {
        this.v.add(i2, tag);
    }

    @Override
    public boolean a(int index, NBTBase tag) {
        this.v.set(index, tag);
        return true;
    }

    @Override
    public boolean b(int index, NBTBase tag) {
        this.v.add(index, tag);
        return true;
    }

    public NBTTagList g() {
        ArrayList<NBTBase> list = new ArrayList<NBTBase>(this.v.size());
        for (NBTBase tag : this.v) {
            list.add(tag.d());
        }
        return new NBTTagList(list);
    }

    @Override
    public Optional<NBTTagList> t_() {
        return Optional.of(this);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagList && Objects.equals(this.v, ((NBTTagList)other).v);
    }

    @Override
    public int hashCode() {
        return this.v.hashCode();
    }

    @Override
    public Stream<NBTBase> stream() {
        return super.stream();
    }

    public Stream<NBTTagCompound> j() {
        return this.stream().mapMulti((tag, consumer) -> {
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                consumer.accept(compoundTag);
            }
        });
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    public void clear() {
        this.v.clear();
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        byte b2 = this.e();
        switch (visitor.a(NBTTagTypes.a(b2), this.v.size())) {
            case c: {
                return StreamTagVisitor.b.c;
            }
            case b: {
                return visitor.b();
            }
        }
        for (int i2 = 0; i2 < this.v.size(); ++i2) {
            NBTBase tag = NBTTagList.a(b2, this.v.get(i2));
            switch (visitor.b(tag.c(), i2)) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                default: {
                    switch (tag.a(visitor)) {
                        case c: {
                            return StreamTagVisitor.b.c;
                        }
                        case b: {
                            return visitor.b();
                        }
                    }
                }
                case b: 
            }
        }
        return visitor.b();
    }
}

