/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketDecoder<T extends PacketListener>
extends ByteToMessageDecoder
implements ProtocolSwapHandler {
    private static final Logger a = LogUtils.getLogger();
    private final ProtocolInfo<T> b;

    public PacketDecoder(ProtocolInfo<T> protocolInfo) {
        this.b = protocolInfo;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Packet packet;
        int i2 = in.readableBytes();
        try {
            packet = (Packet)this.b.c().decode(in);
        }
        catch (Exception var7) {
            if (var7 instanceof SkipEncodeException) {
                in.skipBytes(in.readableBytes());
            }
            throw var7;
        }
        PacketType packetType = packet.a();
        JvmProfiler.f.a(this.b.a(), packetType, ctx.channel().remoteAddress(), i2);
        if (in.readableBytes() > 0) {
            throw new IOException("Packet " + this.b.a().a() + "/" + String.valueOf(packetType) + " (" + packet.getClass().getSimpleName() + ") was larger than I expected, found " + in.readableBytes() + " bytes extra whilst reading packet " + String.valueOf(packetType));
        }
        out.add(packet);
        if (a.isDebugEnabled()) {
            a.debug(NetworkManager.c, " IN: [{}:{}] {} -> {} bytes", new Object[]{this.b.a().a(), packetType, packet.getClass().getName(), i2});
        }
        ProtocolSwapHandler.a(ctx, packet);
    }
}

