/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import org.slf4j.Logger;

public class PacketProcessor
implements AutoCloseable {
    static final Logger a = LogUtils.getLogger();
    private final Queue<a<?>> b = Queues.newConcurrentLinkedQueue();
    private final Thread c;
    private boolean d;
    public static final ConcurrentLinkedDeque<PacketListener> packetProcessing = new ConcurrentLinkedDeque();
    static final AtomicLong totalMainThreadPacketsProcessed = new AtomicLong();

    public PacketProcessor(Thread runningThread) {
        this.c = runningThread;
    }

    public final boolean executeSinglePacket() {
        if (this.d) {
            return false;
        }
        a<?> task = this.b.poll();
        if (task == null) {
            return false;
        }
        task.a();
        return true;
    }

    public boolean a() {
        return Thread.currentThread() == this.c;
    }

    public <T extends PacketListener> void a(T listener, Packet<T> packet) {
        if (this.d) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        boolean isEmpty = this.b.isEmpty();
        a<T> toAdd = new a<T>(listener, packet);
        this.b.add(toAdd);
        if (isEmpty || this.b.peek() == toAdd) {
            LockSupport.unpark(this.c);
        }
    }

    public void b() {
        if (!this.d) {
            while (!this.b.isEmpty()) {
                this.b.poll().a();
            }
        }
    }

    @Override
    public void close() {
        this.d = true;
    }

    public static long getTotalProcessedPackets() {
        return totalMainThreadPacketsProcessed.get();
    }

    public static List<PacketListener> getCurrentPacketProcessors() {
        ArrayList<PacketListener> listeners = new ArrayList<PacketListener>(4);
        for (PacketListener listener : packetProcessing) {
            listeners.add(listener);
        }
        return listeners;
    }

    record a<T extends PacketListener>(T a, Packet<T> b) {
        private final T a;
        private final Packet<T> b;

        public void a() {
            packetProcessing.push((PacketListener)this.a);
            try {
                T t2 = this.a;
                if (t2 instanceof ServerCommonPacketListenerImpl) {
                    ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)t2;
                    if (serverCommonPacketListener.processedDisconnect) {
                        return;
                    }
                }
                if (this.a.a(this.b)) {
                    try {
                        this.b.a(this.a);
                    }
                    catch (Exception var3) {
                        ReportedException reportedException;
                        if (var3 instanceof ReportedException && (reportedException = (ReportedException)var3).getCause() instanceof OutOfMemoryError) {
                            throw PlayerConnectionUtils.a(var3, this.b, this.a);
                        }
                        this.a.a(this.b, var3);
                    }
                } else {
                    a.debug("Ignoring packet due to disconnection: {}", this.b);
                }
            }
            finally {
                totalMainThreadPacketsProcessed.getAndIncrement();
                packetProcessing.pop();
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "listener;packet", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "listener;packet", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "listener;packet", "a", "b"}, this, o2);
        }

        public T b() {
            return this.a;
        }

        public Packet<T> c() {
            return this.b;
        }
    }
}

