/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.channel.ChannelFutureListener;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class PacketSendListener {
    private static final Logger a = LogUtils.getLogger();

    public static ChannelFutureListener a(Runnable action) {
        return channelFuture -> {
            action.run();
            if (!channelFuture.isSuccess()) {
                channelFuture.channel().pipeline().fireExceptionCaught(channelFuture.cause());
            }
        };
    }

    public static ChannelFutureListener a(Supplier<@Nullable Packet<?>> packetSupplier) {
        return channelFuture -> {
            if (!channelFuture.isSuccess()) {
                Packet packet = (Packet)packetSupplier.get();
                if (packet != null) {
                    a.warn("Failed to deliver packet, sending fallback {}", packet.a(), (Object)channelFuture.cause());
                    channelFuture.channel().writeAndFlush((Object)packet, channelFuture.channel().voidPromise());
                } else {
                    channelFuture.channel().pipeline().fireExceptionCaught(channelFuture.cause());
                }
            }
        };
    }
}

