/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.annotation.DoNotUse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;
import org.jspecify.annotations.Nullable;

public class ChatComponentUtils {
    public static final String a = ", ";
    public static final IChatBaseComponent b = IChatBaseComponent.b(", ").a(EnumChatFormat.h);
    public static final IChatBaseComponent c = IChatBaseComponent.b(", ");

    @CheckReturnValue
    public static IChatMutableComponent a(IChatMutableComponent component, ChatModifier style) {
        if (style.h()) {
            return component;
        }
        ChatModifier style1 = component.a();
        if (style1.h()) {
            return component.b(style);
        }
        return style1.equals(style) ? component : component.b(style1.a(style));
    }

    @CheckReturnValue
    public static IChatBaseComponent a(IChatBaseComponent component, ChatModifier style) {
        if (style.h()) {
            return component;
        }
        ChatModifier style1 = component.a();
        if (style1.h()) {
            return component.f().b(style);
        }
        return style1.equals(style) ? component : component.f().b(style1.a(style));
    }

    @Deprecated
    @DoNotUse
    public static Optional<IChatMutableComponent> a(@Nullable CommandListenerWrapper source, Optional<IChatBaseComponent> optionalComponent, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        return optionalComponent.isPresent() ? Optional.of(ChatComponentUtils.a(source, optionalComponent.get(), entity, recursionDepth)) : Optional.empty();
    }

    public static Optional<IChatMutableComponent> updateSeparatorForEntity(@Nullable CommandListenerWrapper source, Optional<IChatBaseComponent> text, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (text.isEmpty() || !ChatComponentUtils.isValidSelector(text.get())) {
            return Optional.empty();
        }
        return Optional.of(ChatComponentUtils.a(source, text.get(), sender, depth));
    }

    public static boolean isValidSelector(IChatBaseComponent component) {
        ComponentContents contents = component.b();
        if (contents instanceof NbtContents || contents instanceof SelectorContents) {
            return false;
        }
        if (contents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)contents;
            for (Object arg : translatableContents.d()) {
                IChatBaseComponent argumentAsComponent;
                if (!(arg instanceof IChatBaseComponent) || ChatComponentUtils.isValidSelector(argumentAsComponent = (IChatBaseComponent)arg)) continue;
                return false;
            }
        }
        return true;
    }

    public static IChatMutableComponent a(@Nullable CommandListenerWrapper source, IChatBaseComponent component, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        if (recursionDepth > 100) {
            return component.f();
        }
        if (component instanceof AdventureComponent) {
            AdventureComponent adventureComponent = (AdventureComponent)component;
            component = adventureComponent.deepConverted();
        }
        IChatMutableComponent mutableComponent = component.b().a(source, entity, recursionDepth + 1);
        for (IChatBaseComponent component1 : component.c()) {
            mutableComponent.b(ChatComponentUtils.a(source, component1, entity, recursionDepth + 1));
        }
        return mutableComponent.c(ChatComponentUtils.a(source, component.a(), entity, recursionDepth));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ChatModifier a(@Nullable CommandListenerWrapper source, ChatModifier style, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        ChatHoverable chatHoverable = style.j();
        if (!(chatHoverable instanceof ChatHoverable.e)) return style;
        ChatHoverable.e e2 = (ChatHoverable.e)chatHoverable;
        try {
            IChatBaseComponent iChatBaseComponent;
            IChatBaseComponent hoverEvent1 = iChatBaseComponent = e2.b();
            ChatHoverable.e hoverEvent1x = new ChatHoverable.e(ChatComponentUtils.a(source, hoverEvent1, entity, recursionDepth + 1));
            return style.a(hoverEvent1x);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static IChatBaseComponent a(Collection<String> elements) {
        return ChatComponentUtils.a(elements, (T content) -> IChatBaseComponent.b(content).a(EnumChatFormat.k));
    }

    public static <T extends Comparable<T>> IChatBaseComponent a(Collection<T> elements, Function<T, IChatBaseComponent> componentExtractor) {
        if (elements.isEmpty()) {
            return CommonComponents.a;
        }
        if (elements.size() == 1) {
            return componentExtractor.apply((Comparable)elements.iterator().next());
        }
        ArrayList list = Lists.newArrayList(elements);
        list.sort(Comparable::compareTo);
        return ChatComponentUtils.b(list, componentExtractor);
    }

    public static <T> IChatBaseComponent b(Collection<? extends T> elements, Function<T, IChatBaseComponent> componentExtractor) {
        return ChatComponentUtils.a(elements, b, componentExtractor);
    }

    public static <T> IChatMutableComponent a(Collection<? extends T> elements, Optional<? extends IChatBaseComponent> optionalSeparator, Function<T, IChatBaseComponent> componentExtractor) {
        return ChatComponentUtils.a(elements, (IChatBaseComponent)DataFixUtils.orElse(optionalSeparator, (Object)b), componentExtractor);
    }

    public static IChatBaseComponent a(Collection<? extends IChatBaseComponent> elements, IChatBaseComponent separator) {
        return ChatComponentUtils.a(elements, separator, Function.identity());
    }

    public static <T> IChatMutableComponent a(Collection<? extends T> elements, IChatBaseComponent separator, Function<T, IChatBaseComponent> componentExtractor) {
        if (elements.isEmpty()) {
            return IChatBaseComponent.i();
        }
        if (elements.size() == 1) {
            return componentExtractor.apply(elements.iterator().next()).f();
        }
        IChatMutableComponent mutableComponent = IChatBaseComponent.i();
        boolean flag = true;
        for (T object : elements) {
            if (!flag) {
                mutableComponent.b(separator);
            }
            mutableComponent.b(componentExtractor.apply(object));
            flag = false;
        }
        return mutableComponent;
    }

    public static IChatMutableComponent a(IChatBaseComponent toWrap) {
        return IChatBaseComponent.a("chat.square_brackets", toWrap);
    }

    public static IChatBaseComponent a(Message message) {
        IChatBaseComponent iChatBaseComponent;
        if (message instanceof IChatBaseComponent) {
            IChatBaseComponent component = (IChatBaseComponent)message;
            iChatBaseComponent = component;
        } else {
            iChatBaseComponent = IChatBaseComponent.b(message.getString());
        }
        return iChatBaseComponent;
    }

    public static boolean b(@Nullable IChatBaseComponent component) {
        ComponentContents componentContents;
        if (component != null && (componentContents = component.b()) instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            String key = translatableContents.b();
            String fallback = translatableContents.c();
            return fallback != null || LocaleLanguage.a().b(key);
        }
        return true;
    }

    public static IChatMutableComponent a(String text) {
        return ChatComponentUtils.a(IChatBaseComponent.b(text).a(style -> style.a(EnumChatFormat.k).a(new ChatClickable.CopyToClipboard(text)).a(new ChatHoverable.e(IChatBaseComponent.c("chat.copy.click"))).a(text)));
    }
}

