/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.FontDescription;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import org.jspecify.annotations.Nullable;

public final class ChatModifier {
    public static final ChatModifier a = new ChatModifier(null, null, null, null, null, null, null, null, null, null, null);
    public static final int b = 0;
    final @Nullable ChatHexColor c;
    final @Nullable Integer d;
    final @Nullable Boolean e;
    final @Nullable Boolean f;
    final @Nullable Boolean g;
    final @Nullable Boolean h;
    final @Nullable Boolean i;
    final @Nullable ChatClickable j;
    final @Nullable ChatHoverable k;
    final @Nullable String l;
    final @Nullable FontDescription m;

    private static ChatModifier a(Optional<ChatHexColor> color, Optional<Integer> shadowColor, Optional<Boolean> bold, Optional<Boolean> italic, Optional<Boolean> underlined, Optional<Boolean> strikethrough, Optional<Boolean> obfuscated, Optional<ChatClickable> clickEvent, Optional<ChatHoverable> hoverEvent, Optional<String> insertion, Optional<FontDescription> font) {
        ChatModifier style = new ChatModifier(color.orElse(null), shadowColor.orElse(null), bold.orElse(null), italic.orElse(null), underlined.orElse(null), strikethrough.orElse(null), obfuscated.orElse(null), clickEvent.orElse(null), hoverEvent.orElse(null), insertion.orElse(null), font.orElse(null));
        return style.equals(a) ? a : style;
    }

    private ChatModifier(@Nullable ChatHexColor color, @Nullable Integer shadowColor, @Nullable Boolean bold, @Nullable Boolean italic, @Nullable Boolean underlined, @Nullable Boolean strikethrough, @Nullable Boolean obfuscated, @Nullable ChatClickable clickEvent, @Nullable ChatHoverable hoverEvent, @Nullable String insertion, @Nullable FontDescription font) {
        this.c = color;
        this.d = shadowColor;
        this.e = bold;
        this.f = italic;
        this.g = underlined;
        this.h = strikethrough;
        this.i = obfuscated;
        this.j = clickEvent;
        this.k = hoverEvent;
        this.l = insertion;
        this.m = font;
    }

    public @Nullable ChatHexColor a() {
        return this.c;
    }

    public @Nullable Integer b() {
        return this.d;
    }

    public boolean c() {
        return this.e == Boolean.TRUE;
    }

    public boolean d() {
        return this.f == Boolean.TRUE;
    }

    public boolean e() {
        return this.h == Boolean.TRUE;
    }

    public boolean f() {
        return this.g == Boolean.TRUE;
    }

    public boolean g() {
        return this.i == Boolean.TRUE;
    }

    public boolean h() {
        return this == a;
    }

    public @Nullable ChatClickable i() {
        return this.j;
    }

    public @Nullable ChatHoverable j() {
        return this.k;
    }

    public @Nullable String k() {
        return this.l;
    }

    public FontDescription l() {
        return this.m != null ? this.m : FontDescription.b;
    }

    private static <T> ChatModifier a(ChatModifier style, @Nullable T oldValue, @Nullable T newValue) {
        return oldValue != null && newValue == null && style.equals(a) ? a : style;
    }

    public ChatModifier a(@Nullable ChatHexColor color) {
        return Objects.equals(this.c, color) ? this : ChatModifier.a(new ChatModifier(color, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m), this.c, color);
    }

    public ChatModifier a(@Nullable EnumChatFormat formatting) {
        return this.a(formatting != null ? ChatHexColor.a(formatting) : null);
    }

    public ChatModifier a(int color) {
        return this.a(ChatHexColor.a(color));
    }

    public ChatModifier b(int color) {
        return Objects.equals(this.d, color) ? this : ChatModifier.a(new ChatModifier(this.c, color, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m), this.d, color);
    }

    public ChatModifier m() {
        return this.b(0);
    }

    public ChatModifier a(@Nullable Boolean bold) {
        return Objects.equals(this.e, bold) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, bold, this.f, this.g, this.h, this.i, this.j, this.k, this.l, this.m), this.e, bold);
    }

    public ChatModifier b(@Nullable Boolean italic) {
        return Objects.equals(this.f, italic) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, this.e, italic, this.g, this.h, this.i, this.j, this.k, this.l, this.m), this.f, italic);
    }

    public ChatModifier c(@Nullable Boolean underlined) {
        return Objects.equals(this.g, underlined) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, underlined, this.h, this.i, this.j, this.k, this.l, this.m), this.g, underlined);
    }

    public ChatModifier d(@Nullable Boolean strikethrough) {
        return Objects.equals(this.h, strikethrough) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, strikethrough, this.i, this.j, this.k, this.l, this.m), this.h, strikethrough);
    }

    public ChatModifier e(@Nullable Boolean obfuscated) {
        return Objects.equals(this.i, obfuscated) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, obfuscated, this.j, this.k, this.l, this.m), this.i, obfuscated);
    }

    public ChatModifier a(@Nullable ChatClickable clickEvent) {
        return Objects.equals(this.j, clickEvent) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, clickEvent, this.k, this.l, this.m), this.j, clickEvent);
    }

    public ChatModifier a(@Nullable ChatHoverable hoverEvent) {
        return Objects.equals(this.k, hoverEvent) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, hoverEvent, this.l, this.m), this.k, hoverEvent);
    }

    public ChatModifier a(@Nullable String insertion) {
        return Objects.equals(this.l, insertion) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, insertion, this.m), this.l, insertion);
    }

    public ChatModifier a(@Nullable FontDescription font) {
        return Objects.equals(this.m, font) ? this : ChatModifier.a(new ChatModifier(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l, font), this.m, font);
    }

    public ChatModifier b(EnumChatFormat formatting) {
        ChatHexColor textColor = this.c;
        Boolean _boolean = this.e;
        Boolean _boolean1 = this.f;
        Boolean _boolean2 = this.h;
        Boolean _boolean3 = this.g;
        Boolean _boolean4 = this.i;
        switch (formatting) {
            case q: {
                _boolean4 = true;
                break;
            }
            case r: {
                _boolean = true;
                break;
            }
            case s: {
                _boolean2 = true;
                break;
            }
            case t: {
                _boolean3 = true;
                break;
            }
            case u: {
                _boolean1 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, this.d, _boolean, _boolean1, _boolean3, _boolean2, _boolean4, this.j, this.k, this.l, this.m);
    }

    public ChatModifier c(EnumChatFormat formatting) {
        ChatHexColor textColor = this.c;
        Boolean _boolean = this.e;
        Boolean _boolean1 = this.f;
        Boolean _boolean2 = this.h;
        Boolean _boolean3 = this.g;
        Boolean _boolean4 = this.i;
        switch (formatting) {
            case q: {
                _boolean4 = true;
                break;
            }
            case r: {
                _boolean = true;
                break;
            }
            case s: {
                _boolean2 = true;
                break;
            }
            case t: {
                _boolean3 = true;
                break;
            }
            case u: {
                _boolean1 = true;
                break;
            }
            case v: {
                return a;
            }
            default: {
                _boolean4 = false;
                _boolean = false;
                _boolean2 = false;
                _boolean3 = false;
                _boolean1 = false;
                textColor = ChatHexColor.a(formatting);
            }
        }
        return new ChatModifier(textColor, this.d, _boolean, _boolean1, _boolean3, _boolean2, _boolean4, this.j, this.k, this.l, this.m);
    }

    public ChatModifier a(EnumChatFormat ... formats) {
        ChatHexColor textColor = this.c;
        Boolean _boolean = this.e;
        Boolean _boolean1 = this.f;
        Boolean _boolean2 = this.h;
        Boolean _boolean3 = this.g;
        Boolean _boolean4 = this.i;
        block8: for (EnumChatFormat chatFormatting : formats) {
            switch (chatFormatting) {
                case q: {
                    _boolean4 = true;
                    continue block8;
                }
                case r: {
                    _boolean = true;
                    continue block8;
                }
                case s: {
                    _boolean2 = true;
                    continue block8;
                }
                case t: {
                    _boolean3 = true;
                    continue block8;
                }
                case u: {
                    _boolean1 = true;
                    continue block8;
                }
                case v: {
                    return a;
                }
                default: {
                    textColor = ChatHexColor.a(chatFormatting);
                }
            }
        }
        return new ChatModifier(textColor, this.d, _boolean, _boolean1, _boolean3, _boolean2, _boolean4, this.j, this.k, this.l, this.m);
    }

    public ChatModifier a(ChatModifier style) {
        if (this == a) {
            return style;
        }
        return style == a ? this : new ChatModifier(this.c != null ? this.c : style.c, this.d != null ? this.d : style.d, this.e != null ? this.e : style.e, this.f != null ? this.f : style.f, this.g != null ? this.g : style.g, this.h != null ? this.h : style.h, this.i != null ? this.i : style.i, this.j != null ? this.j : style.j, this.k != null ? this.k : style.k, this.l != null ? this.l : style.l, this.m != null ? this.m : style.m);
    }

    public String toString() {
        final StringBuilder stringBuilder = new StringBuilder("{");
        class A {
            private boolean b;

            A() {
            }

            private void a() {
                if (this.b) {
                    stringBuilder.append(',');
                }
                this.b = true;
            }

            void a(String key, @Nullable Boolean value) {
                if (value != null) {
                    this.a();
                    if (!value.booleanValue()) {
                        stringBuilder.append('!');
                    }
                    stringBuilder.append(key);
                }
            }

            void a(String key, @Nullable Object value) {
                if (value != null) {
                    this.a();
                    stringBuilder.append(key);
                    stringBuilder.append('=');
                    stringBuilder.append(value);
                }
            }
        }
        A collector = new A();
        collector.a("color", this.c);
        collector.a("shadowColor", this.d);
        collector.a("bold", this.e);
        collector.a("italic", this.f);
        collector.a("underlined", this.g);
        collector.a("strikethrough", this.h);
        collector.a("obfuscated", this.i);
        collector.a("clickEvent", this.j);
        collector.a("hoverEvent", this.k);
        collector.a("insertion", this.l);
        collector.a("font", this.m);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ChatModifier)) return false;
        ChatModifier style = (ChatModifier)other;
        if (this.e != style.e) return false;
        if (!Objects.equals(this.a(), style.a())) return false;
        if (!Objects.equals(this.b(), style.b())) return false;
        if (this.f != style.f) return false;
        if (this.i != style.i) return false;
        if (this.h != style.h) return false;
        if (this.g != style.g) return false;
        if (!Objects.equals(this.j, style.j)) return false;
        if (!Objects.equals(this.k, style.k)) return false;
        if (!Objects.equals(this.l, style.l)) return false;
        if (!Objects.equals(this.m, style.m)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.c, this.d, this.e, this.f, this.g, this.h, this.i, this.j, this.k, this.l);
    }

    public static class ChatModifierSerializer {
        public static final MapCodec<ChatModifier> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChatHexColor.a.optionalFieldOf("color").forGetter(serializer -> Optional.ofNullable(serializer.c)), (App)ExtraCodecs.m.optionalFieldOf("shadow_color").forGetter(serializer -> Optional.ofNullable(serializer.d)), (App)Codec.BOOL.optionalFieldOf("bold").forGetter(serializer -> Optional.ofNullable(serializer.e)), (App)Codec.BOOL.optionalFieldOf("italic").forGetter(serializer -> Optional.ofNullable(serializer.f)), (App)Codec.BOOL.optionalFieldOf("underlined").forGetter(serializer -> Optional.ofNullable(serializer.g)), (App)Codec.BOOL.optionalFieldOf("strikethrough").forGetter(serializer -> Optional.ofNullable(serializer.h)), (App)Codec.BOOL.optionalFieldOf("obfuscated").forGetter(serializer -> Optional.ofNullable(serializer.i)), (App)ChatClickable.a.optionalFieldOf("click_event").forGetter(serializer -> Optional.ofNullable(serializer.j)), (App)ChatHoverable.a.optionalFieldOf("hover_event").forGetter(serializer -> Optional.ofNullable(serializer.k)), (App)Codec.STRING.optionalFieldOf("insertion").forGetter(serializer -> Optional.ofNullable(serializer.l)), (App)FontDescription.a.optionalFieldOf("font").forGetter(serializer -> Optional.ofNullable(serializer.m))).apply((Applicative)instance, ChatModifier::a));
        public static final Codec<ChatModifier> b = a.codec();
        public static final StreamCodec<RegistryFriendlyByteBuf, ChatModifier> c = ByteBufCodecs.c(b);
    }
}

