/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.util.Either;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ObjectContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.chat.contents.data.DataSource;
import net.minecraft.network.chat.contents.objects.ObjectInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.FormattedString;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.jspecify.annotations.Nullable;

public interface IChatBaseComponent
extends Message,
IChatFormatted,
Iterable<IChatBaseComponent> {
    default public Stream<IChatBaseComponent> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.c().stream().flatMap(IChatBaseComponent::stream)});
    }

    @Override
    default public Iterator<IChatBaseComponent> iterator() {
        return this.stream().iterator();
    }

    public ChatModifier a();

    public ComponentContents b();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String a(int maxLength) {
        StringBuilder stringBuilder = new StringBuilder();
        this.a((String content) -> {
            int i2 = maxLength - stringBuilder.length();
            if (i2 <= 0) {
                return a;
            }
            stringBuilder.append(content.length() <= i2 ? content : content.substring(0, i2));
            return Optional.empty();
        });
        return stringBuilder.toString();
    }

    public List<IChatBaseComponent> c();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public @Nullable String d() {
        ComponentContents componentContents = this.b();
        if (!(componentContents instanceof LiteralContents)) return null;
        LiteralContents plainTextContents = (LiteralContents)componentContents;
        if (!this.c().isEmpty()) return null;
        if (!this.a().h()) return null;
        String string = plainTextContents.b();
        return string;
    }

    default public IChatMutableComponent e() {
        return IChatMutableComponent.a(this.b());
    }

    default public IChatMutableComponent f() {
        return new IChatMutableComponent(this.b(), new ArrayList<IChatBaseComponent>(this.c()), this.a());
    }

    public FormattedString g();

    @Override
    default public <T> Optional<T> a(IChatFormatted.b<T> acceptor, ChatModifier style) {
        ChatModifier style1 = this.a().a(style);
        Optional<T> optional = this.b().a(acceptor, style1);
        if (optional.isPresent()) {
            return optional;
        }
        for (IChatBaseComponent component : this.c()) {
            Optional<T> optional1 = component.a(acceptor, style1);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> a(IChatFormatted.a<T> acceptor) {
        Optional<T> optional = this.b().a(acceptor);
        if (optional.isPresent()) {
            return optional;
        }
        for (IChatBaseComponent component : this.c()) {
            Optional<T> optional1 = component.a(acceptor);
            if (!optional1.isPresent()) continue;
            return optional1;
        }
        return Optional.empty();
    }

    default public List<IChatBaseComponent> h() {
        return this.a(ChatModifier.a);
    }

    default public List<IChatBaseComponent> a(ChatModifier style) {
        ArrayList list = Lists.newArrayList();
        this.a((style1, content) -> {
            if (!content.isEmpty()) {
                list.add(IChatBaseComponent.b(content).c(style1));
            }
            return Optional.empty();
        }, style);
        return list;
    }

    default public boolean a(IChatBaseComponent other) {
        List<IChatBaseComponent> list1;
        if (this.equals(other)) {
            return true;
        }
        List<IChatBaseComponent> list = this.h();
        return Collections.indexOfSubList(list, list1 = other.a(this.a())) != -1;
    }

    public static IChatBaseComponent a(@Nullable String text) {
        return text != null ? IChatBaseComponent.b(text) : CommonComponents.a;
    }

    public static IChatMutableComponent b(String text) {
        return IChatMutableComponent.a(LiteralContents.a(text));
    }

    public static IChatMutableComponent c(String key) {
        return IChatMutableComponent.a(new TranslatableContents(key, null, TranslatableContents.a));
    }

    public static IChatMutableComponent a(String key, Object ... args) {
        return IChatMutableComponent.a(new TranslatableContents(key, null, args));
    }

    public static IChatMutableComponent b(String key, Object ... args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            Object object = args[i2];
            if (TranslatableContents.a(object) || object instanceof IChatBaseComponent) continue;
            args[i2] = String.valueOf(object);
        }
        return IChatBaseComponent.a(key, args);
    }

    public static IChatMutableComponent a(String key, @Nullable String fallback) {
        return IChatMutableComponent.a(new TranslatableContents(key, fallback, TranslatableContents.a));
    }

    public static IChatMutableComponent a(String key, @Nullable String fallback, Object ... args) {
        return IChatMutableComponent.a(new TranslatableContents(key, fallback, args));
    }

    public static IChatMutableComponent i() {
        return IChatMutableComponent.a(LiteralContents.b);
    }

    public static IChatMutableComponent d(String name) {
        return IChatMutableComponent.a(new KeybindContents(name));
    }

    public static IChatMutableComponent a(String nbtPathPattern, boolean interpreting, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        return IChatMutableComponent.a(new NbtContents(nbtPathPattern, interpreting, separator, dataSource));
    }

    public static IChatMutableComponent a(SelectorPattern selectorPattern, String objective) {
        return IChatMutableComponent.a(new ScoreContents(Either.left(selectorPattern), objective));
    }

    public static IChatMutableComponent b(String name, String objective) {
        return IChatMutableComponent.a(new ScoreContents(Either.right(name), objective));
    }

    public static IChatMutableComponent a(SelectorPattern selectorPattern, Optional<IChatBaseComponent> separator) {
        return IChatMutableComponent.a(new SelectorContents(selectorPattern, separator));
    }

    public static IChatMutableComponent a(ObjectInfo contents) {
        return IChatMutableComponent.a(new ObjectContents(contents));
    }

    public static IChatBaseComponent a(Date date) {
        return IChatBaseComponent.b(date.toString());
    }

    public static IChatBaseComponent a(Message message) {
        IChatBaseComponent iChatBaseComponent;
        if (message instanceof IChatBaseComponent) {
            IChatBaseComponent component = (IChatBaseComponent)message;
            iChatBaseComponent = component;
        } else {
            iChatBaseComponent = IChatBaseComponent.b(message.getString());
        }
        return iChatBaseComponent;
    }

    public static IChatBaseComponent a(UUID uuid) {
        return IChatBaseComponent.b(uuid.toString());
    }

    public static IChatBaseComponent a(MinecraftKey location) {
        return IChatBaseComponent.b(location.toString());
    }

    public static IChatBaseComponent a(ChunkCoordIntPair chunkPos) {
        return IChatBaseComponent.b(chunkPos.toString());
    }

    public static IChatBaseComponent a(URI uri) {
        return IChatBaseComponent.b(uri.toString());
    }
}

