/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.MathHelper;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public interface ByteBufCodecs {
    public static final int a = 65536;
    public static final StreamCodec<ByteBuf, Boolean> b = new StreamCodec<ByteBuf, Boolean>(){

        public Boolean a(ByteBuf buffer) {
            return buffer.readBoolean();
        }

        public void a(ByteBuf buffer, Boolean value) {
            buffer.writeBoolean(value.booleanValue());
        }
    };
    public static final StreamCodec<ByteBuf, Byte> c = new StreamCodec<ByteBuf, Byte>(){

        public Byte a(ByteBuf buffer) {
            return buffer.readByte();
        }

        public void a(ByteBuf buffer, Byte value) {
            buffer.writeByte((int)value.byteValue());
        }
    };
    public static final StreamCodec<ByteBuf, Float> d = c.a(MathHelper::a, MathHelper::e);
    public static final StreamCodec<ByteBuf, Short> e = new StreamCodec<ByteBuf, Short>(){

        public Short a(ByteBuf buffer) {
            return buffer.readShort();
        }

        public void a(ByteBuf buffer, Short value) {
            buffer.writeShort((int)value.shortValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> f = new StreamCodec<ByteBuf, Integer>(){

        public Integer a(ByteBuf buffer) {
            return buffer.readUnsignedShort();
        }

        public void a(ByteBuf buffer, Integer value) {
            buffer.writeShort(value.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> g = new StreamCodec<ByteBuf, Integer>(){

        public Integer a(ByteBuf buffer) {
            return buffer.readInt();
        }

        public void a(ByteBuf buffer, Integer value) {
            buffer.writeInt(value.intValue());
        }
    };
    public static final StreamCodec<ByteBuf, Integer> h = new StreamCodec<ByteBuf, Integer>(){

        public Integer a(ByteBuf buffer) {
            return VarInt.a(buffer);
        }

        public void a(ByteBuf buffer, Integer value) {
            VarInt.a(buffer, value);
        }
    };
    public static final StreamCodec<ByteBuf, OptionalInt> i = h.a(value -> value == 0 ? OptionalInt.empty() : OptionalInt.of(value - 1), optionalInt -> optionalInt.isPresent() ? optionalInt.getAsInt() + 1 : 0);
    public static final StreamCodec<ByteBuf, Long> j = new StreamCodec<ByteBuf, Long>(){

        public Long a(ByteBuf buffer) {
            return buffer.readLong();
        }

        public void a(ByteBuf buffer, Long value) {
            buffer.writeLong(value.longValue());
        }
    };
    public static final StreamCodec<ByteBuf, Long> k = new StreamCodec<ByteBuf, Long>(){

        public Long a(ByteBuf buffer) {
            return VarLong.a(buffer);
        }

        public void a(ByteBuf buffer, Long value) {
            VarLong.a(buffer, value);
        }
    };
    public static final StreamCodec<ByteBuf, Float> l = new StreamCodec<ByteBuf, Float>(){

        public Float a(ByteBuf buffer) {
            return Float.valueOf(buffer.readFloat());
        }

        public void a(ByteBuf buffer, Float value) {
            buffer.writeFloat(value.floatValue());
        }
    };
    public static final StreamCodec<ByteBuf, Double> m = new StreamCodec<ByteBuf, Double>(){

        public Double a(ByteBuf buffer) {
            return buffer.readDouble();
        }

        public void a(ByteBuf buffer, Double value) {
            buffer.writeDouble(value.doubleValue());
        }
    };
    public static final StreamCodec<ByteBuf, byte[]> n = new StreamCodec<ByteBuf, byte[]>(){

        public byte[] a(ByteBuf buffer) {
            return PacketDataSerializer.a(buffer);
        }

        public void a(ByteBuf buffer, byte[] data) {
            PacketDataSerializer.a(buffer, data);
        }
    };
    public static final StreamCodec<ByteBuf, long[]> o = new StreamCodec<ByteBuf, long[]>(){

        @Override
        public long[] decode(ByteBuf buffer) {
            return PacketDataSerializer.b(buffer);
        }

        @Override
        public void encode(ByteBuf buffer, long[] data) {
            PacketDataSerializer.a(buffer, data);
        }
    };
    public static final StreamCodec<ByteBuf, String> p = ByteBufCodecs.b(Short.MAX_VALUE);
    public static final StreamCodec<ByteBuf, NBTBase> q = ByteBufCodecs.b(NBTReadLimiter::a);
    public static final StreamCodec<ByteBuf, NBTBase> r = ByteBufCodecs.b(NBTReadLimiter::c);
    public static final StreamCodec<ByteBuf, NBTTagCompound> s = ByteBufCodecs.c(NBTReadLimiter::a);
    public static final StreamCodec<ByteBuf, NBTTagCompound> t = ByteBufCodecs.c(NBTReadLimiter::c);
    public static final StreamCodec<ByteBuf, Optional<NBTTagCompound>> u = new StreamCodec<ByteBuf, Optional<NBTTagCompound>>(){

        @Override
        public Optional<NBTTagCompound> decode(ByteBuf buffer) {
            return Optional.ofNullable(PacketDataSerializer.i(buffer));
        }

        @Override
        public void encode(ByteBuf buffer, Optional<NBTTagCompound> value) {
            PacketDataSerializer.a(buffer, value.orElse(null));
        }
    };
    public static final StreamCodec<ByteBuf, Vector3fc> v = new StreamCodec<ByteBuf, Vector3fc>(){

        @Override
        public Vector3fc decode(ByteBuf buffer) {
            return PacketDataSerializer.e(buffer);
        }

        @Override
        public void encode(ByteBuf buffer, Vector3fc value) {
            PacketDataSerializer.a(buffer, value);
        }
    };
    public static final StreamCodec<ByteBuf, Quaternionfc> w = new StreamCodec<ByteBuf, Quaternionfc>(){

        @Override
        public Quaternionfc decode(ByteBuf buffer) {
            return PacketDataSerializer.f(buffer);
        }

        @Override
        public void encode(ByteBuf buffer, Quaternionfc value) {
            PacketDataSerializer.a(buffer, value);
        }
    };
    public static final StreamCodec<ByteBuf, Integer> x = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf buffer) {
            return PacketDataSerializer.j(buffer);
        }

        @Override
        public void encode(ByteBuf buffer, Integer value) {
            PacketDataSerializer.b(buffer, value);
        }
    };
    public static final StreamCodec<ByteBuf, PropertyMap> y = new StreamCodec<ByteBuf, PropertyMap>(){

        @Override
        public PropertyMap decode(ByteBuf buffer) {
            int count = ByteBufCodecs.a(buffer, 16);
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (int i2 = 0; i2 < count; ++i2) {
                String string = Utf8String.a(buffer, 64);
                String string1 = Utf8String.a(buffer, Short.MAX_VALUE);
                String string2 = PacketDataSerializer.a(buffer, (? super B buffer1) -> Utf8String.a(buffer1, 1024));
                Property property = new Property(string, string1, string2);
                builder.put((Object)property.name(), (Object)property);
            }
            return new PropertyMap((Multimap)builder.build());
        }

        @Override
        public void encode(ByteBuf buffer, PropertyMap value) {
            ByteBufCodecs.a(buffer, value.size(), 16);
            for (Property property : value.values()) {
                Utf8String.a(buffer, property.name(), 64);
                Utf8String.a(buffer, property.value(), Short.MAX_VALUE);
                PacketDataSerializer.a(buffer, property.signature(), (? super B buffer1, T value1) -> Utf8String.a(buffer1, value1, 1024));
            }
        }
    };
    public static final StreamCodec<ByteBuf, String> z = ByteBufCodecs.b(16);
    public static final StreamCodec<ByteBuf, GameProfile> A = StreamCodec.a(UUIDUtil.g, GameProfile::id, z, GameProfile::name, y, GameProfile::properties, GameProfile::new);
    public static final StreamCodec<ByteBuf, Integer> B = new StreamCodec<ByteBuf, Integer>(){

        @Override
        public Integer decode(ByteBuf buffer) {
            return ARGB.a(buffer.readByte() & 0xFF, buffer.readByte() & 0xFF, buffer.readByte() & 0xFF);
        }

        @Override
        public void encode(ByteBuf buffer, Integer value) {
            buffer.writeByte(ARGB.c(value));
            buffer.writeByte(ARGB.d(value));
            buffer.writeByte(ARGB.e(value));
        }
    };

    public static StreamCodec<ByteBuf, byte[]> a(final int maxSize) {
        return new StreamCodec<ByteBuf, byte[]>(){

            @Override
            public byte[] decode(ByteBuf buffer) {
                return PacketDataSerializer.a(buffer, maxSize);
            }

            @Override
            public void encode(ByteBuf buffer, byte[] value) {
                if (value.length > maxSize) {
                    throw new EncoderException("ByteArray with size " + value.length + " is bigger than allowed " + maxSize);
                }
                PacketDataSerializer.a(buffer, value);
            }
        };
    }

    public static StreamCodec<ByteBuf, String> b(final int maxLength) {
        return new StreamCodec<ByteBuf, String>(){

            @Override
            public String decode(ByteBuf buffer) {
                return Utf8String.a(buffer, maxLength);
            }

            @Override
            public void encode(ByteBuf buffer, String value) {
                Utf8String.a(buffer, value, maxLength);
            }
        };
    }

    public static StreamCodec<ByteBuf, Optional<NBTBase>> a(final Supplier<NBTReadLimiter> accounter) {
        return new StreamCodec<ByteBuf, Optional<NBTBase>>(){

            @Override
            public Optional<NBTBase> decode(ByteBuf buffer) {
                return Optional.ofNullable(PacketDataSerializer.a(buffer, (NBTReadLimiter)accounter.get()));
            }

            @Override
            public void encode(ByteBuf buffer, Optional<NBTBase> value) {
                PacketDataSerializer.a(buffer, value.orElse(null));
            }
        };
    }

    public static StreamCodec<ByteBuf, NBTBase> b(final Supplier<NBTReadLimiter> accounter) {
        return new StreamCodec<ByteBuf, NBTBase>(){

            @Override
            public NBTBase decode(ByteBuf buffer) {
                NBTBase nbt = PacketDataSerializer.a(buffer, (NBTReadLimiter)accounter.get());
                if (nbt == null) {
                    throw new DecoderException("Expected non-null compound tag");
                }
                return nbt;
            }

            @Override
            public void encode(ByteBuf buffer, NBTBase value) {
                if (value == NBTTagEnd.b) {
                    throw new EncoderException("Expected non-null compound tag");
                }
                PacketDataSerializer.a(buffer, value);
            }
        };
    }

    public static StreamCodec<ByteBuf, NBTTagCompound> c(Supplier<NBTReadLimiter> accounterSupplier) {
        return ByteBufCodecs.b(accounterSupplier).a(tag -> {
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                return compoundTag;
            }
            throw new DecoderException("Not a compound tag: " + String.valueOf(tag));
        }, tag -> tag);
    }

    public static <T> StreamCodec<ByteBuf, T> a(Codec<T> codec) {
        return ByteBufCodecs.a(codec, NBTReadLimiter::c);
    }

    public static <T> StreamCodec<ByteBuf, T> b(Codec<T> codec) {
        return ByteBufCodecs.a(codec, NBTReadLimiter::a);
    }

    public static <T, B extends ByteBuf, V> StreamCodec.a<B, T, V> a(final DynamicOps<T> ops, final Codec<V> codec) {
        return codec1 -> new StreamCodec<B, V>(){

            @Override
            public V decode(B buffer) {
                Object object = codec1.decode(buffer);
                return codec.parse(ops, object).getOrThrow(string -> new DecoderException("Failed to decode: " + string + " " + String.valueOf(object)));
            }

            @Override
            public void encode(B buffer, V value) {
                Object orThrow = codec.encodeStart(ops, value).getOrThrow(string -> new EncoderException("Failed to encode: " + string + " " + String.valueOf(value)));
                codec1.encode(buffer, orThrow);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> a(Codec<T> codec, Supplier<NBTReadLimiter> accounterSupplier) {
        return ByteBufCodecs.b(accounterSupplier).a(ByteBufCodecs.a(DynamicOpsNBT.a, codec));
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> c(Codec<T> codec) {
        return ByteBufCodecs.b(codec, NBTReadLimiter::c);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> d(Codec<T> codec) {
        return ByteBufCodecs.b(codec, NBTReadLimiter::a);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> b(final Codec<T> codec, Supplier<NBTReadLimiter> accounterSupplier) {
        final StreamCodec<ByteBuf, NBTBase> streamCodec = ByteBufCodecs.b(accounterSupplier);
        return new StreamCodec<RegistryFriendlyByteBuf, T>(){

            @Override
            public T decode(RegistryFriendlyByteBuf buffer) {
                NBTBase tag = (NBTBase)streamCodec.decode(buffer);
                RegistryOps<NBTBase> registryOps = buffer.G().a(DynamicOpsNBT.a);
                return codec.parse(registryOps, (Object)tag).getOrThrow(string -> new DecoderException("Failed to decode: " + string + " " + String.valueOf(tag)));
            }

            @Override
            public void encode(RegistryFriendlyByteBuf buffer, T value) {
                RegistryOps<NBTBase> registryOps = buffer.G().a(DynamicOpsNBT.a);
                NBTBase tag = (NBTBase)codec.encodeStart(registryOps, value).getOrThrow(string -> new EncoderException("Failed to encode: " + string + " " + String.valueOf(value)));
                streamCodec.encode(buffer, tag);
            }
        };
    }

    public static <B extends PacketDataSerializer, V> StreamCodec<B, V> trackDepth(final StreamCodec<B, V> codec) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B buffer) {
                ((PacketDataSerializer)((Object)buffer)).trackCodecDepth = true;
                try {
                    Object t2 = codec.decode(buffer);
                    return t2;
                }
                finally {
                    ((PacketDataSerializer)((Object)buffer)).trackCodecDepth = false;
                    ((PacketDataSerializer)((Object)buffer)).codecDepth = 0;
                }
            }

            @Override
            public void encode(B buffer, V value) {
                codec.encode(buffer, value);
            }
        };
    }

    public static <B extends PacketDataSerializer, V> StreamCodec<B, V> increaseDepth(final StreamCodec<B, V> codec) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B buffer) {
                if (!((PacketDataSerializer)((Object)buffer)).trackCodecDepth) {
                    return codec.decode(buffer);
                }
                ((PacketDataSerializer)((Object)buffer)).codecDepth = (byte)(((PacketDataSerializer)((Object)buffer)).codecDepth + 1);
                if (((PacketDataSerializer)((Object)buffer)).codecDepth > 64) {
                    throw new DecoderException("Too deep");
                }
                return codec.decode(buffer);
            }

            @Override
            public void encode(B buffer, V value) {
                codec.encode(buffer, value);
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, Optional<V>> a(final StreamCodec<? super B, V> codec) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            public Optional<V> decode(B buffer) {
                return buffer.readBoolean() ? Optional.of(codec.decode(buffer)) : Optional.empty();
            }

            @Override
            public void encode(B buffer, Optional<V> value) {
                if (value.isPresent()) {
                    buffer.writeBoolean(true);
                    codec.encode(buffer, value.get());
                } else {
                    buffer.writeBoolean(false);
                }
            }
        };
    }

    public static int a(ByteBuf buffer, int maxSize) {
        int i2 = VarInt.a(buffer);
        if (i2 > maxSize) {
            throw new DecoderException(i2 + " elements exceeded max size of: " + maxSize);
        }
        return i2;
    }

    public static void a(ByteBuf buffer, int count, int maxSize) {
        if (count > maxSize) {
            throw new EncoderException(count + " elements exceeded max size of: " + maxSize);
        }
        VarInt.a(buffer, count);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> a(IntFunction<C> factory, StreamCodec<? super B, V> codec) {
        return ByteBufCodecs.a(factory, codec, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec<B, C> a(final IntFunction<C> factory, final StreamCodec<? super B, V> codec, final int maxSize) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buffer) {
                int count = ByteBufCodecs.a(buffer, maxSize);
                Collection collection = (Collection)factory.apply(Math.min(count, 65536));
                for (int i2 = 0; i2 < count; ++i2) {
                    collection.add(codec.decode(buffer));
                }
                return collection;
            }

            @Override
            public void encode(B buffer, C value) {
                ByteBufCodecs.a(buffer, value.size(), maxSize);
                for (Object object : value) {
                    codec.encode(buffer, object);
                }
            }
        };
    }

    public static <B extends ByteBuf, V, C extends Collection<V>> StreamCodec.a<B, V, C> a(IntFunction<C> factory) {
        return codec -> ByteBufCodecs.a(factory, codec);
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, List<V>> a() {
        return codec -> ByteBufCodecs.a(ArrayList::new, codec);
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, List<V>> c(int maxSize) {
        return codec -> ByteBufCodecs.a(ArrayList::new, codec, maxSize);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> a(IntFunction<? extends M> factory, StreamCodec<? super B, K> keyCodec, StreamCodec<? super B, V> valueCodec) {
        return ByteBufCodecs.a(factory, keyCodec, valueCodec, Integer.MAX_VALUE);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> a(final IntFunction<? extends M> factory, final StreamCodec<? super B, K> keyCodec, final StreamCodec<? super B, V> valueCodec, final int maxSize) {
        return new StreamCodec<B, M>(){

            @Override
            public void encode(B buffer, M value) {
                ByteBufCodecs.a(buffer, value.size(), maxSize);
                value.forEach((object, object1) -> {
                    keyCodec.encode(buffer, object);
                    valueCodec.encode(buffer, object1);
                });
            }

            @Override
            public M decode(B buffer) {
                int count = ByteBufCodecs.a(buffer, maxSize);
                Map map = (Map)factory.apply(Math.min(count, 65536));
                for (int i2 = 0; i2 < count; ++i2) {
                    Object object = keyCodec.decode(buffer);
                    Object object1 = valueCodec.decode(buffer);
                    map.put(object, object1);
                }
                return map;
            }
        };
    }

    public static <B extends ByteBuf, L, R> StreamCodec<B, Either<L, R>> a(final StreamCodec<? super B, L> leftCodec, final StreamCodec<? super B, R> rightCodec) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            public Either<L, R> decode(B buffer) {
                return buffer.readBoolean() ? Either.left(leftCodec.decode(buffer)) : Either.right(rightCodec.decode(buffer));
            }

            @Override
            public void encode(B buffer, Either<L, R> value) {
                value.ifLeft(object -> {
                    buffer.writeBoolean(true);
                    leftCodec.encode(buffer, object);
                }).ifRight(object -> {
                    buffer.writeBoolean(false);
                    rightCodec.encode(buffer, object);
                });
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec.a<B, V, V> a(final int maxLength, final BiFunction<B, ByteBuf, B> function) {
        return codec -> new StreamCodec<B, V>(){

            @Override
            public V decode(B buffer) {
                int i2 = VarInt.a(buffer);
                if (i2 > maxLength) {
                    throw new DecoderException("Buffer size " + i2 + " is larger than allowed limit of " + maxLength);
                }
                int i1 = buffer.readerIndex();
                ByteBuf byteBuf = (ByteBuf)function.apply(buffer, buffer.slice(i1, i2));
                buffer.readerIndex(i1 + i2);
                return codec.decode(byteBuf);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void encode(B buffer, V value) {
                ByteBuf byteBuf = (ByteBuf)function.apply(buffer, buffer.alloc().buffer());
                try {
                    codec.encode(byteBuf, value);
                    int i2 = byteBuf.readableBytes();
                    if (i2 > maxLength) {
                        throw new EncoderException("Buffer size " + i2 + " is  larger than allowed limit of " + maxLength);
                    }
                    VarInt.a(buffer, i2);
                    buffer.writeBytes(byteBuf);
                }
                finally {
                    byteBuf.release();
                }
            }
        };
    }

    public static <V> StreamCodec.a<ByteBuf, V, V> d(int length) {
        return ByteBufCodecs.a(length, (B byteBuf, ByteBuf byteBuf1) -> byteBuf1);
    }

    public static <V> StreamCodec.a<RegistryFriendlyByteBuf, V, V> e(int length) {
        return ByteBufCodecs.a(length, (B registryFriendlyByteBuf, ByteBuf byteBuf) -> new RegistryFriendlyByteBuf((ByteBuf)byteBuf, registryFriendlyByteBuf.G()));
    }

    public static <T> StreamCodec<ByteBuf, T> a(final IntFunction<T> idLookup, final ToIntFunction<T> idGetter) {
        return new StreamCodec<ByteBuf, T>(){

            @Override
            public T decode(ByteBuf buffer) {
                int i2 = VarInt.a(buffer);
                return idLookup.apply(i2);
            }

            @Override
            public void encode(ByteBuf buffer, T value) {
                int i2 = idGetter.applyAsInt(value);
                VarInt.a(buffer, i2);
            }
        };
    }

    public static <T> StreamCodec<ByteBuf, T> a(Registry<T> idMap) {
        return ByteBufCodecs.a(idMap::b, idMap::c);
    }

    private static <T, R> StreamCodec<RegistryFriendlyByteBuf, R> a(final ResourceKey<? extends IRegistry<T>> registryKey, final Function<IRegistry<T>, Registry<R>> idGetter) {
        return new StreamCodec<RegistryFriendlyByteBuf, R>(){

            private Registry<R> getRegistryOrThrow(RegistryFriendlyByteBuf buffer) {
                return (Registry)idGetter.apply(buffer.G().f(registryKey));
            }

            @Override
            public R decode(RegistryFriendlyByteBuf buffer) {
                int i2 = VarInt.a(buffer);
                return this.getRegistryOrThrow(buffer).b(i2);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf buffer, R value) {
                int idOrThrow = this.getRegistryOrThrow(buffer).c(value);
                VarInt.a(buffer, idOrThrow);
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, T> a(ResourceKey<? extends IRegistry<T>> registryKey) {
        return ByteBufCodecs.a(registryKey, (IRegistry<T> registry) -> registry);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> b(ResourceKey<? extends IRegistry<T>> registryKey) {
        return ByteBufCodecs.a(registryKey, IRegistry::t);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, Holder<T>> a(final ResourceKey<? extends IRegistry<T>> registryKey, final StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        return new StreamCodec<RegistryFriendlyByteBuf, Holder<T>>(){
            private static final int DIRECT_HOLDER_ID = 0;

            private Registry<Holder<T>> getRegistryOrThrow(RegistryFriendlyByteBuf buffer) {
                return buffer.G().f(registryKey).t();
            }

            @Override
            public Holder<T> decode(RegistryFriendlyByteBuf buffer) {
                int i2 = VarInt.a(buffer);
                return i2 == 0 ? Holder.a(codec.decode(buffer)) : this.getRegistryOrThrow(buffer).b(i2 - 1);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf buffer, Holder<T> value) {
                switch (value.f()) {
                    case a: {
                        int idOrThrow = this.getRegistryOrThrow(buffer).c(value);
                        VarInt.a(buffer, idOrThrow + 1);
                        break;
                    }
                    case b: {
                        VarInt.a(buffer, 0);
                        codec.encode(buffer, value.a());
                    }
                }
            }
        };
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>> c(final ResourceKey<? extends IRegistry<T>> registryKey) {
        return new StreamCodec<RegistryFriendlyByteBuf, HolderSet<T>>(){
            private static final int NAMED_SET = -1;
            private final StreamCodec<RegistryFriendlyByteBuf, Holder<T>> holderCodec;
            {
                this.holderCodec = ByteBufCodecs.b(registryKey);
            }

            @Override
            public HolderSet<T> decode(RegistryFriendlyByteBuf buffer) {
                int i2 = VarInt.a(buffer) - 1;
                if (i2 == -1) {
                    IRegistry registry = buffer.G().f(registryKey);
                    return (HolderSet)registry.a(TagKey.a(registryKey, (MinecraftKey)MinecraftKey.b.decode(buffer))).orElseThrow();
                }
                ArrayList<Holder> list = new ArrayList<Holder>(Math.min(i2, 65536));
                for (int i1 = 0; i1 < i2; ++i1) {
                    list.add((Holder)this.holderCodec.decode(buffer));
                }
                return HolderSet.a(list);
            }

            @Override
            public void encode(RegistryFriendlyByteBuf buffer, HolderSet<T> value) {
                Optional optional = value.e();
                if (optional.isPresent()) {
                    VarInt.a(buffer, 0);
                    MinecraftKey.b.encode(buffer, optional.get().b());
                } else {
                    VarInt.a(buffer, value.b() + 1);
                    for (Holder holder : value) {
                        this.holderCodec.encode(buffer, holder);
                    }
                }
            }
        };
    }

    public static StreamCodec<ByteBuf, JsonElement> f(final int maxLength) {
        return new StreamCodec<ByteBuf, JsonElement>(){
            private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

            @Override
            public JsonElement decode(ByteBuf buffer) {
                String string = Utf8String.a(buffer, maxLength);
                try {
                    return LenientJsonParser.a(string);
                }
                catch (JsonSyntaxException var4) {
                    throw new DecoderException("Failed to parse JSON", (Throwable)var4);
                }
            }

            @Override
            public void encode(ByteBuf buffer, JsonElement value) {
                String string = GSON.toJson(value);
                Utf8String.a(buffer, string, maxLength);
            }
        };
    }
}

