/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public final class ClientboundDamageEventPacket
extends Record
implements Packet<PacketListenerPlayOut> {
    private final int b;
    private final Holder<DamageType> c;
    private final int d;
    private final int e;
    private final Optional<Vec3D> f;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundDamageEventPacket> a = Packet.a(ClientboundDamageEventPacket::a, ClientboundDamageEventPacket::new);

    public ClientboundDamageEventPacket(Entity entity, DamageSource damageSource) {
        this(entity.aA(), damageSource.l(), damageSource.d() != null ? damageSource.d().aA() : -1, damageSource.c() != null ? damageSource.c().aA() : -1, Optional.ofNullable(damageSource.j()));
    }

    private ClientboundDamageEventPacket(RegistryFriendlyByteBuf buffer) {
        this(buffer.l(), (Holder)DamageType.c.decode(buffer), ClientboundDamageEventPacket.a(buffer), ClientboundDamageEventPacket.a(buffer), buffer.b(buffer1 -> new Vec3D(buffer1.readDouble(), buffer1.readDouble(), buffer1.readDouble())));
    }

    public ClientboundDamageEventPacket(int entityId, Holder<DamageType> sourceType, int sourceCauseId, int sourceDirectId, Optional<Vec3D> sourcePosition) {
        this.b = entityId;
        this.c = sourceType;
        this.d = sourceCauseId;
        this.e = sourceDirectId;
        this.f = sourcePosition;
    }

    private static void a(PacketDataSerializer buffer, int optionalEntityId) {
        buffer.c(optionalEntityId + 1);
    }

    private static int a(PacketDataSerializer buffer) {
        return buffer.l() - 1;
    }

    @Override
    private void a(RegistryFriendlyByteBuf buffer) {
        buffer.c(this.b);
        DamageType.c.encode(buffer, this.c);
        ClientboundDamageEventPacket.a((PacketDataSerializer)buffer, this.d);
        ClientboundDamageEventPacket.a((PacketDataSerializer)buffer, this.e);
        buffer.a(this.f, (buffer1, vec3) -> {
            buffer1.a(vec3.a());
            buffer1.a(vec3.b());
            buffer1.a(vec3.c());
        });
    }

    @Override
    public PacketType<ClientboundDamageEventPacket> a() {
        return GamePacketTypes.y;
    }

    @Override
    public void a(PacketListenerPlayOut handler) {
        handler.a(this);
    }

    public DamageSource a(World level) {
        if (this.f.isPresent()) {
            return new DamageSource(this.c, this.f.get());
        }
        Entity entity = level.a(this.d);
        Entity entity1 = level.a(this.e);
        return new DamageSource(this.c, entity1, entity);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ClientboundDamageEventPacket.class, "entityId;sourceType;sourceCauseId;sourceDirectId;sourcePosition", "b", "c", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ClientboundDamageEventPacket.class, "entityId;sourceType;sourceCauseId;sourceDirectId;sourcePosition", "b", "c", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ClientboundDamageEventPacket.class, "entityId;sourceType;sourceCauseId;sourceDirectId;sourcePosition", "b", "c", "d", "e", "f"}, this, o2);
    }

    public int b() {
        return this.b;
    }

    public Holder<DamageType> e() {
        return this.c;
    }

    public int f() {
        return this.d;
    }

    public int g() {
        return this.e;
    }

    public Optional<Vec3D> h() {
        return this.f;
    }
}

