/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.antixray.ChunkPacketInfo;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.levelgen.HeightMap;
import org.jspecify.annotations.Nullable;

public class ClientboundLevelChunkPacketData {
    private static final StreamCodec<ByteBuf, Map<HeightMap.Type, long[]>> a = ByteBufCodecs.a(i2 -> new EnumMap(HeightMap.Type.class), HeightMap.Type.h, ByteBufCodecs.o);
    private static final int b = 0x200000;
    private final Map<HeightMap.Type, long[]> c;
    private final byte[] d;
    private final List<a> e;
    private final List<Packet<?>> extraPackets = new ArrayList();
    private static final int BLOCK_ENTITY_LIMIT = Integer.getInteger("Paper.excessiveTELimit", 750);

    public List<Packet<?>> getExtraPackets() {
        return this.extraPackets;
    }

    @Deprecated
    @DoNotUse
    public ClientboundLevelChunkPacketData(Chunk levelChunk) {
        this(levelChunk, null);
    }

    public ClientboundLevelChunkPacketData(Chunk levelChunk, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        this.c = levelChunk.e().stream().filter(entry1 -> ((HeightMap.Type)entry1.getKey()).b()).collect(Collectors.toMap(Map.Entry::getKey, entry1 -> (long[])((HeightMap)entry1.getValue()).a().clone()));
        this.d = new byte[ClientboundLevelChunkPacketData.a(levelChunk)];
        if (chunkPacketInfo != null) {
            chunkPacketInfo.setBuffer(this.d);
        }
        ClientboundLevelChunkPacketData.extractChunkData(new PacketDataSerializer(this.c()), levelChunk, chunkPacketInfo);
        this.e = Lists.newArrayList();
        int totalTileEntities = 0;
        for (Map.Entry<BlockPosition, TileEntity> entry : levelChunk.J().entrySet()) {
            Packet<PacketListenerPlayOut> packet;
            if (++totalTileEntities > BLOCK_ENTITY_LIMIT && (packet = entry.getValue().ax_()) != null) {
                this.extraPackets.add(packet);
                continue;
            }
            this.e.add(net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.a(entry.getValue()));
        }
    }

    public ClientboundLevelChunkPacketData(RegistryFriendlyByteBuf buffer, int x2, int z2) {
        this.c = (Map)a.decode(buffer);
        int varInt = buffer.l();
        if (varInt > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.d = new byte[varInt];
        buffer.b(this.d);
        this.e = (List)net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.b.decode(buffer);
    }

    public void a(RegistryFriendlyByteBuf buffer) {
        a.encode(buffer, this.c);
        buffer.c(this.d.length);
        buffer.c(this.d);
        net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData$a.b.encode(buffer, this.e);
    }

    private static int a(Chunk chunk) {
        int i2 = 0;
        for (ChunkSection levelChunkSection : chunk.d()) {
            i2 += levelChunkSection.j();
        }
        return i2;
    }

    private ByteBuf c() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.d);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    @Deprecated
    @DoNotUse
    public static void a(PacketDataSerializer buffer, Chunk chunk) {
        ClientboundLevelChunkPacketData.extractChunkData(buffer, chunk, null);
    }

    public static void extractChunkData(PacketDataSerializer buffer, Chunk chunk, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        int chunkSectionIndex = 0;
        for (ChunkSection levelChunkSection : chunk.d()) {
            levelChunkSection.write(buffer, chunkPacketInfo, chunkSectionIndex);
            ++chunkSectionIndex;
        }
        if (buffer.writerIndex() != buffer.capacity()) {
            throw new IllegalStateException("Didn't fill chunk buffer: expected " + buffer.capacity() + " bytes, got " + buffer.writerIndex());
        }
    }

    public Consumer<b> a(int chunkX, int chunkZ) {
        return blockEntityTagOutput -> this.a((b)blockEntityTagOutput, chunkX, chunkZ);
    }

    private void a(b output, int chunkX, int chunkZ) {
        int i2 = 16 * chunkX;
        int i1 = 16 * chunkZ;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (a blockEntityInfo : this.e) {
            int i22 = i2 + SectionPosition.b(blockEntityInfo.c >> 4);
            int i3 = i1 + SectionPosition.b(blockEntityInfo.c);
            mutableBlockPos.d(i22, blockEntityInfo.d, i3);
            output.accept(mutableBlockPos, blockEntityInfo.e, blockEntityInfo.f);
        }
    }

    public PacketDataSerializer a() {
        return new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])this.d));
    }

    public Map<HeightMap.Type, long[]> b() {
        return this.c;
    }

    static class a {
        public static final StreamCodec<RegistryFriendlyByteBuf, a> a = StreamCodec.a(a::a, a::new);
        public static final StreamCodec<RegistryFriendlyByteBuf, List<a>> b = a.a(ByteBufCodecs.a());
        final int c;
        final int d;
        final TileEntityTypes<?> e;
        final @Nullable NBTTagCompound f;

        private a(int packedXZ, int y2, TileEntityTypes<?> type, @Nullable NBTTagCompound tag) {
            this.c = packedXZ;
            this.d = y2;
            this.e = type;
            this.f = tag;
        }

        private a(RegistryFriendlyByteBuf buffer) {
            this.c = buffer.readByte();
            this.d = buffer.readShort();
            this.e = (TileEntityTypes)ByteBufCodecs.a(Registries.e).decode(buffer);
            this.f = buffer.o();
        }

        private void a(RegistryFriendlyByteBuf buffer) {
            buffer.l(this.c);
            buffer.m(this.d);
            ByteBufCodecs.a(Registries.e).encode(buffer, this.e);
            buffer.a(this.f);
        }

        static a a(TileEntity blockEntity) {
            NBTTagCompound updateTag = blockEntity.a(blockEntity.j().J_());
            BlockPosition blockPos = blockEntity.aD_();
            int i2 = SectionPosition.b(blockPos.u()) << 4 | SectionPosition.b(blockPos.w());
            blockEntity.sanitizeSentNbt(updateTag);
            return new a(i2, blockPos.v(), blockEntity.s(), updateTag.j() ? null : updateTag);
        }
    }

    @FunctionalInterface
    public static interface b {
        public void accept(BlockPosition var1, TileEntityTypes<?> var2, @Nullable NBTTagCompound var3);
    }
}

