/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import org.jspecify.annotations.Nullable;

public class PacketPlayOutCommands
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutCommands> a = Packet.a(PacketPlayOutCommands::a, PacketPlayOutCommands::new);
    private static final byte b = 3;
    private static final byte c = 4;
    private static final byte d = 8;
    private static final byte e = 16;
    private static final byte f = 32;
    private static final byte g = 0;
    private static final byte h = 1;
    private static final byte i = 2;
    private final int j;
    private final List<b> k;

    public <S> PacketPlayOutCommands(RootCommandNode<S> root, e<S> nodeInspector) {
        Object2IntMap<CommandNode<S>> map = PacketPlayOutCommands.a(root);
        this.k = PacketPlayOutCommands.a(map, nodeInspector);
        this.j = map.getInt(root);
    }

    private PacketPlayOutCommands(PacketDataSerializer buffer) {
        this.k = buffer.a(PacketPlayOutCommands::b);
        this.j = buffer.l();
        PacketPlayOutCommands.a(this.k);
    }

    @Override
    private void a(PacketDataSerializer buffer) {
        buffer.a(this.k, (? super PacketDataSerializer buffer1, T value) -> value.a((PacketDataSerializer)((Object)buffer1)));
        buffer.c(this.j);
    }

    private static void a(List<b> entries, BiPredicate<b, IntSet> validator) {
        IntOpenHashSet set = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)entries.size()));
        while (!set.isEmpty()) {
            boolean flag = set.removeIf(arg_0 -> PacketPlayOutCommands.a(validator, entries, (IntSet)set, arg_0));
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void a(List<b> entries) {
        PacketPlayOutCommands.a(entries, b::a);
        PacketPlayOutCommands.a(entries, b::b);
    }

    private static <S> Object2IntMap<CommandNode<S>> a(RootCommandNode<S> rootNode) {
        CommandNode commandNode;
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(rootNode);
        while ((commandNode = (CommandNode)queue.poll()) != null) {
            if (map.containsKey((Object)commandNode)) continue;
            int size = map.size();
            map.put((Object)commandNode, size);
            queue.addAll(commandNode.getChildren());
            if (commandNode.getRedirect() == null) continue;
            queue.add(commandNode.getRedirect());
        }
        return map;
    }

    private static <S> List<b> a(Object2IntMap<CommandNode<S>> nodes, e<S> nodeInspector) {
        ObjectArrayList list = new ObjectArrayList(nodes.size());
        list.size(nodes.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(nodes)) {
            list.set(entry.getIntValue(), (Object)PacketPlayOutCommands.a((CommandNode)entry.getKey(), nodeInspector, nodes));
        }
        return list;
    }

    private static b b(PacketDataSerializer buffer) {
        byte _byte = buffer.readByte();
        int[] varIntArray = buffer.c();
        int i2 = (_byte & 8) != 0 ? buffer.l() : 0;
        g nodeStub = PacketPlayOutCommands.a(buffer, _byte);
        return new b(nodeStub, _byte, i2, varIntArray);
    }

    private static @Nullable g a(PacketDataSerializer buffer, byte flags) {
        int i2 = flags & 3;
        if (i2 == 2) {
            String utf = buffer.p();
            int varInt = buffer.l();
            ArgumentTypeInfo argumentTypeInfo = (ArgumentTypeInfo)BuiltInRegistries.v.a(varInt);
            if (argumentTypeInfo == null) {
                return null;
            }
            Object template = argumentTypeInfo.b(buffer);
            MinecraftKey identifier = (flags & 0x10) != 0 ? buffer.q() : null;
            return new a(utf, (ArgumentTypeInfo.a<?>)template, identifier);
        }
        if (i2 == 1) {
            String utf = buffer.p();
            return new c(utf);
        }
        return null;
    }

    private static <S> b a(CommandNode<S> node, e<S> nodeInspector, Object2IntMap<CommandNode<S>> nodes) {
        Record nodeStub;
        int _int;
        int i2 = 0;
        if (node.getRedirect() != null) {
            i2 |= 8;
            _int = nodes.getInt(node.getRedirect());
        } else {
            _int = 0;
        }
        if (nodeInspector.a(node)) {
            i2 |= 4;
        }
        if (nodeInspector.b(node)) {
            i2 |= 0x20;
        }
        CommandNode<S> commandNode = node;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, ArgumentCommandNode.class, LiteralCommandNode.class}, commandNode2, n2)) {
            case 0: {
                RootCommandNode rootCommandNode = (RootCommandNode)commandNode2;
                i2 |= 0;
                nodeStub = null;
                break;
            }
            case 1: {
                ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)commandNode2;
                MinecraftKey identifier = nodeInspector.a(argumentCommandNode);
                nodeStub = new a(argumentCommandNode.getName(), ArgumentTypeInfos.b(argumentCommandNode.getType()), identifier);
                i2 |= 2;
                if (identifier != null) {
                    i2 |= 0x10;
                }
                break;
            }
            case 2: {
                LiteralCommandNode literalCommandNode = (LiteralCommandNode)commandNode2;
                nodeStub = new c(literalCommandNode.getLiteral());
                i2 |= 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(node));
            }
        }
        int[] ints = node.getChildren().stream().mapToInt(arg_0 -> nodes.getInt(arg_0)).toArray();
        return new b((g)((Object)nodeStub), i2, _int, ints);
    }

    @Override
    public PacketType<PacketPlayOutCommands> a() {
        return GamePacketTypes.r;
    }

    @Override
    public void a(PacketListenerPlayOut handler) {
        handler.a(this);
    }

    public <S> RootCommandNode<S> a(CommandBuildContext context, d<S> nodeBuilder) {
        return (RootCommandNode)new f<S>(context, nodeBuilder, this.k).a(this.j);
    }

    private static /* synthetic */ boolean a(BiPredicate validator, List entries, IntSet set, int i2) {
        return validator.test((b)entries.get(i2), set);
    }

    public static interface e<S> {
        public @Nullable MinecraftKey a(ArgumentCommandNode<S, ?> var1);

        public boolean a(CommandNode<S> var1);

        public boolean b(CommandNode<S> var1);
    }

    record b(@Nullable g a, int b, int c, int[] d) {
        public void a(PacketDataSerializer buffer) {
            buffer.l(this.b);
            buffer.a(this.d);
            if ((this.b & 8) != 0) {
                buffer.c(this.c);
            }
            if (this.a != null) {
                this.a.a(buffer);
            }
        }

        public boolean a(IntSet children) {
            return (this.b & 8) == 0 || !children.contains(this.c);
        }

        public boolean b(IntSet children) {
            for (int i2 : this.d) {
                if (!children.contains(i2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "stub;flags;redirect;children", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "stub;flags;redirect;children", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "stub;flags;redirect;children", "a", "b", "c", "d"}, this, o2);
        }
    }

    static interface g {
        public <S> ArgumentBuilder<S, ?> a(CommandBuildContext var1, d<S> var2);

        public void a(PacketDataSerializer var1);
    }

    record a(String a, ArgumentTypeInfo.a<?> b, @Nullable MinecraftKey c) implements g
    {
        @Override
        public <S> ArgumentBuilder<S, ?> a(CommandBuildContext context, d<S> nodeBuilder) {
            Object argumentType = this.b.b(context);
            return nodeBuilder.a(this.a, (ArgumentType<?>)argumentType, this.c);
        }

        @Override
        public void a(PacketDataSerializer buffer) {
            buffer.a(this.a);
            net.minecraft.network.protocol.game.PacketPlayOutCommands$a.a(buffer, this.b);
            if (this.c != null) {
                buffer.a(this.c);
            }
        }

        private static <A extends ArgumentType<?>> void a(PacketDataSerializer buffer, ArgumentTypeInfo.a<A> argumentInfoTemplate) {
            net.minecraft.network.protocol.game.PacketPlayOutCommands$a.a(buffer, argumentInfoTemplate.a(), argumentInfoTemplate);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> void a(PacketDataSerializer buffer, ArgumentTypeInfo<A, T> argumentInfo, ArgumentTypeInfo.a<A> argumentInfoTemplate) {
            buffer.c(BuiltInRegistries.v.a(argumentInfo));
            argumentInfo.a(argumentInfoTemplate, buffer);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;argumentType;suggestionId", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;argumentType;suggestionId", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;argumentType;suggestionId", "a", "b", "c"}, this, o2);
        }
    }

    record c(String a) implements g
    {
        @Override
        public <S> ArgumentBuilder<S, ?> a(CommandBuildContext context, d<S> nodeBuilder) {
            return nodeBuilder.a(this.a);
        }

        @Override
        public void a(PacketDataSerializer buffer) {
            buffer.a(this.a);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "id", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "id", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "id", "a"}, this, o2);
        }
    }

    static class f<S> {
        private final CommandBuildContext a;
        private final d<S> b;
        private final List<b> c;
        private final List<CommandNode<S>> d;

        f(CommandBuildContext context, d<S> builder, List<b> entries) {
            this.a = context;
            this.b = builder;
            this.c = entries;
            ObjectArrayList list = new ObjectArrayList();
            list.size(entries.size());
            this.d = list;
        }

        public CommandNode<S> a(int index) {
            Object commandNode1;
            CommandNode<S> commandNode = this.d.get(index);
            if (commandNode != null) {
                return commandNode;
            }
            b entry = this.c.get(index);
            if (entry.a == null) {
                commandNode1 = new RootCommandNode();
            } else {
                ArgumentBuilder<S, ?> argumentBuilder = entry.a.a(this.a, this.b);
                if ((entry.b & 8) != 0) {
                    argumentBuilder.redirect(this.a(entry.c));
                }
                boolean flag = (entry.b & 4) != 0;
                boolean flag1 = (entry.b & 0x20) != 0;
                commandNode1 = this.b.a(argumentBuilder, flag, flag1).build();
            }
            this.d.set(index, (CommandNode<S>)commandNode1);
            for (int i2 : entry.d) {
                CommandNode<S> commandNode2 = this.a(i2);
                if (commandNode2 instanceof RootCommandNode) continue;
                commandNode1.addChild(commandNode2);
            }
            return commandNode1;
        }
    }

    public static interface d<S> {
        public ArgumentBuilder<S, ?> a(String var1);

        public ArgumentBuilder<S, ?> a(String var1, ArgumentType<?> var2, @Nullable MinecraftKey var3);

        public ArgumentBuilder<S, ?> a(ArgumentBuilder<S, ?> var1, boolean var2, boolean var3);
    }
}

