/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.sanitizer.ItemObfuscationSession;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;

public class PacketPlayOutEntityEquipment
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutEntityEquipment> a = Packet.a(PacketPlayOutEntityEquipment::a, PacketPlayOutEntityEquipment::new);
    private static final byte b = -128;
    private final int c;
    private final List<Pair<EnumItemSlot, ItemStack>> d;
    private boolean sanitize;

    public PacketPlayOutEntityEquipment(int entity, List<Pair<EnumItemSlot, ItemStack>> slots) {
        this(entity, slots, false);
    }

    public PacketPlayOutEntityEquipment(int entity, List<Pair<EnumItemSlot, ItemStack>> slots, boolean sanitize) {
        this.sanitize = sanitize;
        this.c = entity;
        this.d = slots;
    }

    private PacketPlayOutEntityEquipment(RegistryFriendlyByteBuf buffer) {
        byte _byte;
        this.c = buffer.l();
        this.d = Lists.newArrayList();
        do {
            _byte = buffer.readByte();
            EnumItemSlot equipmentSlot = EnumItemSlot.j.get(_byte & 0x7F);
            ItemStack itemStack = (ItemStack)ItemStack.h.decode(buffer);
            this.d.add((Pair<EnumItemSlot, ItemStack>)Pair.of((Object)equipmentSlot, (Object)itemStack));
        } while ((_byte & 0xFFFFFF80) != 0);
    }

    @Override
    private void a(RegistryFriendlyByteBuf buffer) {
        buffer.c(this.c);
        int size = this.d.size();
        try (ItemObfuscationSession ignored = ItemObfuscationSession.start(this.sanitize ? GlobalConfiguration.get().anticheat.obfuscation.items.binding.level : ItemObfuscationSession.ObfuscationLevel.NONE);){
            for (int i2 = 0; i2 < size; ++i2) {
                Pair<EnumItemSlot, ItemStack> pair = this.d.get(i2);
                EnumItemSlot equipmentSlot = (EnumItemSlot)pair.getFirst();
                boolean flag = i2 != size - 1;
                int ordinal = equipmentSlot.ordinal();
                buffer.l(flag ? ordinal | 0xFFFFFF80 : ordinal);
                ItemStack.h.encode(buffer, (ItemStack)pair.getSecond());
            }
        }
    }

    @Override
    public PacketType<PacketPlayOutEntityEquipment> a() {
        return GamePacketTypes.aN;
    }

    @Override
    public void a(PacketListenerPlayOut handler) {
        handler.a(this);
    }

    public int b() {
        return this.c;
    }

    public List<Pair<EnumItemSlot, ItemStack>> e() {
        return this.d;
    }
}

