/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import io.netty.buffer.ByteBuf;
import io.papermc.paper.util.SafeAutoClosable;
import io.papermc.paper.util.sanitizer.ItemObfuscationSession;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.util.RegistryID;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.cow.CowVariant;
import net.minecraft.world.entity.animal.feline.CatVariant;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.golem.CopperGolemState;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.animal.pig.PigVariant;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.decoration.painting.PaintingVariant;
import net.minecraft.world.entity.npc.villager.VillagerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.IBlockData;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class DataWatcherRegistry {
    private static final RegistryID<DataWatcherSerializer<?>> N = RegistryID.c(16);
    public static final DataWatcherSerializer<Byte> a = DataWatcherSerializer.a(ByteBufCodecs.c);
    public static final DataWatcherSerializer<Integer> b = DataWatcherSerializer.a(ByteBufCodecs.h);
    public static final DataWatcherSerializer<Long> c = DataWatcherSerializer.a(ByteBufCodecs.k);
    public static final DataWatcherSerializer<Float> d = DataWatcherSerializer.a(ByteBufCodecs.l);
    public static final DataWatcherSerializer<String> e = DataWatcherSerializer.a(ByteBufCodecs.p);
    public static final DataWatcherSerializer<IChatBaseComponent> f = DataWatcherSerializer.a(ComponentSerialization.d);
    public static final DataWatcherSerializer<Optional<IChatBaseComponent>> g = DataWatcherSerializer.a(ComponentSerialization.e);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OVERSIZED_ITEM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

        @Override
        public ItemStack decode(RegistryFriendlyByteBuf buffer) {
            return (ItemStack)ItemStack.h.decode(buffer);
        }

        @Override
        public void encode(RegistryFriendlyByteBuf buffer, ItemStack value) {
            try (SafeAutoClosable ignored = ItemObfuscationSession.withContext(c2 -> c2.level(ItemObfuscationSession.ObfuscationLevel.OVERSIZED));){
                ItemStack.h.encode(buffer, value);
            }
        }
    };
    public static final DataWatcherSerializer<ItemStack> h = new DataWatcherSerializer<ItemStack>(){

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, ItemStack> codec() {
            return OVERSIZED_ITEM_CODEC;
        }

        @Override
        public ItemStack copy(ItemStack value) {
            return value.v();
        }
    };
    public static final DataWatcherSerializer<IBlockData> i = DataWatcherSerializer.a(ByteBufCodecs.a(Block.k));
    private static final StreamCodec<ByteBuf, Optional<IBlockData>> O = new StreamCodec<ByteBuf, Optional<IBlockData>>(){

        @Override
        public void encode(ByteBuf buffer, Optional<IBlockData> value) {
            if (value.isPresent()) {
                VarInt.a(buffer, Block.j(value.get()));
            } else {
                VarInt.a(buffer, 0);
            }
        }

        @Override
        public Optional<IBlockData> decode(ByteBuf buffer) {
            int i2 = VarInt.a(buffer);
            return i2 == 0 ? Optional.empty() : Optional.of(Block.a(i2));
        }
    };
    public static final DataWatcherSerializer<Optional<IBlockData>> j = DataWatcherSerializer.a(O);
    public static final DataWatcherSerializer<Boolean> k = DataWatcherSerializer.a(ByteBufCodecs.b);
    public static final DataWatcherSerializer<ParticleParam> l = DataWatcherSerializer.a(Particles.bm);
    public static final DataWatcherSerializer<List<ParticleParam>> m = DataWatcherSerializer.a(Particles.bm.a(ByteBufCodecs.a()));
    public static final DataWatcherSerializer<Vector3f> n = DataWatcherSerializer.a(Vector3f.b);
    public static final DataWatcherSerializer<BlockPosition> o = DataWatcherSerializer.a(BlockPosition.b);
    public static final DataWatcherSerializer<Optional<BlockPosition>> p = DataWatcherSerializer.a(BlockPosition.b.a(ByteBufCodecs::a));
    public static final DataWatcherSerializer<EnumDirection> q = DataWatcherSerializer.a(EnumDirection.j);
    public static final DataWatcherSerializer<Optional<EntityReference<EntityLiving>>> r = DataWatcherSerializer.a(EntityReference.b().a(ByteBufCodecs::a));
    public static final DataWatcherSerializer<Optional<GlobalPos>> s = DataWatcherSerializer.a(GlobalPos.c.a(ByteBufCodecs::a));
    public static final DataWatcherSerializer<VillagerData> t = DataWatcherSerializer.a(VillagerData.d);
    private static final StreamCodec<ByteBuf, OptionalInt> P = new StreamCodec<ByteBuf, OptionalInt>(){

        @Override
        public OptionalInt decode(ByteBuf buffer) {
            int i2 = VarInt.a(buffer);
            return i2 == 0 ? OptionalInt.empty() : OptionalInt.of(i2 - 1);
        }

        @Override
        public void encode(ByteBuf buffer, OptionalInt value) {
            VarInt.a(buffer, value.orElse(-1) + 1);
        }
    };
    public static final DataWatcherSerializer<OptionalInt> u = DataWatcherSerializer.a(P);
    public static final DataWatcherSerializer<EntityPose> v = DataWatcherSerializer.a(EntityPose.u);
    public static final DataWatcherSerializer<Holder<CatVariant>> w = DataWatcherSerializer.a(CatVariant.d);
    public static final DataWatcherSerializer<Holder<ChickenVariant>> x = DataWatcherSerializer.a(ChickenVariant.d);
    public static final DataWatcherSerializer<Holder<CowVariant>> y = DataWatcherSerializer.a(CowVariant.d);
    public static final DataWatcherSerializer<Holder<WolfVariant>> z = DataWatcherSerializer.a(WolfVariant.d);
    public static final DataWatcherSerializer<Holder<WolfSoundVariant>> A = DataWatcherSerializer.a(WolfSoundVariant.d);
    public static final DataWatcherSerializer<Holder<FrogVariant>> B = DataWatcherSerializer.a(FrogVariant.d);
    public static final DataWatcherSerializer<Holder<PigVariant>> C = DataWatcherSerializer.a(PigVariant.d);
    public static final DataWatcherSerializer<Holder<ZombieNautilusVariant>> D = DataWatcherSerializer.a(ZombieNautilusVariant.d);
    public static final DataWatcherSerializer<Holder<PaintingVariant>> E = DataWatcherSerializer.a(PaintingVariant.d);
    public static final DataWatcherSerializer<Armadillo.a> F = DataWatcherSerializer.a(Armadillo.a.e);
    public static final DataWatcherSerializer<Sniffer.State> G = DataWatcherSerializer.a(Sniffer.State.i);
    public static final DataWatcherSerializer<WeatheringCopper.a> H = DataWatcherSerializer.a(WeatheringCopper.a.g);
    public static final DataWatcherSerializer<CopperGolemState> I = DataWatcherSerializer.a(CopperGolemState.g);
    public static final DataWatcherSerializer<Vector3fc> J = DataWatcherSerializer.a(ByteBufCodecs.v);
    public static final DataWatcherSerializer<Quaternionfc> K = DataWatcherSerializer.a(ByteBufCodecs.w);
    public static final DataWatcherSerializer<ResolvableProfile> L = DataWatcherSerializer.a(ResolvableProfile.b);
    public static final DataWatcherSerializer<EnumMainHand> M = DataWatcherSerializer.a(EnumMainHand.d);

    public static void a(DataWatcherSerializer<?> serializer) {
        N.d(serializer);
    }

    public static @Nullable DataWatcherSerializer<?> a(int id) {
        return N.a(id);
    }

    public static int b(DataWatcherSerializer<?> serializer) {
        return N.a(serializer);
    }

    private DataWatcherRegistry() {
    }

    static {
        DataWatcherRegistry.a(a);
        DataWatcherRegistry.a(b);
        DataWatcherRegistry.a(c);
        DataWatcherRegistry.a(d);
        DataWatcherRegistry.a(e);
        DataWatcherRegistry.a(f);
        DataWatcherRegistry.a(g);
        DataWatcherRegistry.a(h);
        DataWatcherRegistry.a(k);
        DataWatcherRegistry.a(n);
        DataWatcherRegistry.a(o);
        DataWatcherRegistry.a(p);
        DataWatcherRegistry.a(q);
        DataWatcherRegistry.a(r);
        DataWatcherRegistry.a(i);
        DataWatcherRegistry.a(j);
        DataWatcherRegistry.a(l);
        DataWatcherRegistry.a(m);
        DataWatcherRegistry.a(t);
        DataWatcherRegistry.a(u);
        DataWatcherRegistry.a(v);
        DataWatcherRegistry.a(w);
        DataWatcherRegistry.a(y);
        DataWatcherRegistry.a(z);
        DataWatcherRegistry.a(A);
        DataWatcherRegistry.a(B);
        DataWatcherRegistry.a(C);
        DataWatcherRegistry.a(x);
        DataWatcherRegistry.a(D);
        DataWatcherRegistry.a(s);
        DataWatcherRegistry.a(E);
        DataWatcherRegistry.a(G);
        DataWatcherRegistry.a(F);
        DataWatcherRegistry.a(I);
        DataWatcherRegistry.a(H);
        DataWatcherRegistry.a(J);
        DataWatcherRegistry.a(K);
        DataWatcherRegistry.a(L);
        DataWatcherRegistry.a(M);
    }
}

