/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.UnaryOperator;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class MinecraftKey
implements Comparable<MinecraftKey> {
    public static final Codec<MinecraftKey> a = Codec.STRING.comapFlatMap(MinecraftKey::d, MinecraftKey::toString).stable();
    public static final StreamCodec<ByteBuf, MinecraftKey> b = ByteBufCodecs.p.a(MinecraftKey::a, MinecraftKey::toString);
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.id.invalid"));
    public static final char d = ':';
    public static final String e = "minecraft";
    public static final String f = "realms";
    public static final String PAPER_NAMESPACE = "paper";
    private final String h;
    private final String i;

    private MinecraftKey(String namespace, String path) {
        assert (MinecraftKey.j(namespace));
        assert (MinecraftKey.i(path));
        String resourceLocation = namespace + ":" + path;
        if (resourceLocation.length() > Short.MAX_VALUE || ByteBufUtil.utf8MaxBytes((CharSequence)resourceLocation) > 65535) {
            throw new ResourceKeyInvalidException("Resource location too long: " + resourceLocation);
        }
        this.h = namespace;
        this.i = path;
    }

    private static MinecraftKey d(String namespace, String path) {
        return new MinecraftKey(MinecraftKey.e(namespace, path), MinecraftKey.f(namespace, path));
    }

    public static MinecraftKey a(String namespace, String path) {
        return MinecraftKey.d(namespace, path);
    }

    public static MinecraftKey a(String location) {
        return MinecraftKey.a(location, ':');
    }

    public static MinecraftKey b(String location) {
        return new MinecraftKey(e, MinecraftKey.f(e, location));
    }

    public static @Nullable MinecraftKey c(String location) {
        return MinecraftKey.b(location, ':');
    }

    public static @Nullable MinecraftKey b(String namespace, String path) {
        return MinecraftKey.j(namespace) && MinecraftKey.i(path) ? new MinecraftKey(namespace, path) : null;
    }

    public static MinecraftKey a(String location, char separator) {
        int index = location.indexOf(separator);
        if (index >= 0) {
            String sub = location.substring(index + 1);
            if (index != 0) {
                String sub1 = location.substring(0, index);
                return MinecraftKey.d(sub1, sub);
            }
            return MinecraftKey.b(sub);
        }
        return MinecraftKey.b(location);
    }

    public static @Nullable MinecraftKey b(String location, char separator) {
        int index = location.indexOf(separator);
        if (index >= 0) {
            String sub = location.substring(index + 1);
            if (!MinecraftKey.i(sub)) {
                return null;
            }
            if (index != 0) {
                String sub1 = location.substring(0, index);
                return MinecraftKey.j(sub1) ? new MinecraftKey(sub1, sub) : null;
            }
            return new MinecraftKey(e, sub);
        }
        return MinecraftKey.i(location) ? new MinecraftKey(e, location) : null;
    }

    public static DataResult<MinecraftKey> d(String location) {
        try {
            return DataResult.success((Object)MinecraftKey.a(location));
        }
        catch (ResourceKeyInvalidException var2) {
            return DataResult.error(() -> "Not a valid resource location: " + location + " " + var2.getMessage());
        }
    }

    public String a() {
        return this.i;
    }

    public String b() {
        return this.h;
    }

    public MinecraftKey e(String path) {
        return new MinecraftKey(this.h, MinecraftKey.f(this.h, path));
    }

    public MinecraftKey a(UnaryOperator<String> pathOperator) {
        return this.e((String)pathOperator.apply(this.i));
    }

    public MinecraftKey f(String pathPrefix) {
        return this.e(pathPrefix + this.i);
    }

    public MinecraftKey g(String pathSuffix) {
        return this.e(this.i + pathSuffix);
    }

    public String toString() {
        return this.h + ":" + this.i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof MinecraftKey)) return false;
        MinecraftKey identifier = (MinecraftKey)other;
        if (!this.h.equals(identifier.h)) return false;
        if (!this.i.equals(identifier.i)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.h.hashCode() + this.i.hashCode();
    }

    public int a(MinecraftKey other) {
        int i2 = this.i.compareTo(other.i);
        if (i2 == 0) {
            i2 = this.h.compareTo(other.h);
        }
        return i2;
    }

    public String c() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String d() {
        return this.h + "." + this.i;
    }

    public String e() {
        return this.h.equals(e) ? this.i : this.d();
    }

    public String f() {
        return this.h.equals(e) ? this.i : this.toString();
    }

    public String h(String type) {
        return type + "." + this.d();
    }

    public String c(String type, String key) {
        return type + "." + this.d() + "." + key;
    }

    private static String c(StringReader reader) {
        int cursor = reader.getCursor();
        while (reader.canRead() && MinecraftKey.a(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(cursor, reader.getCursor());
    }

    public static MinecraftKey a(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String greedy = MinecraftKey.c(reader);
        try {
            return MinecraftKey.a(greedy);
        }
        catch (ResourceKeyInvalidException var4) {
            reader.setCursor(cursor);
            throw c.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static MinecraftKey b(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String greedy = MinecraftKey.c(reader);
        if (greedy.isEmpty()) {
            throw c.createWithContext((ImmutableStringReader)reader);
        }
        try {
            return MinecraftKey.a(greedy);
        }
        catch (ResourceKeyInvalidException var4) {
            reader.setCursor(cursor);
            throw c.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean a(char character) {
        return character >= '0' && character <= '9' || character >= 'a' && character <= 'z' || character == '_' || character == ':' || character == '/' || character == '.' || character == '-';
    }

    public static boolean i(String path) {
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (MinecraftKey.b(path.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean j(String namespace) {
        for (int i2 = 0; i2 < namespace.length(); ++i2) {
            if (MinecraftKey.c(namespace.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static String e(String namespace, String path) {
        if (!MinecraftKey.j(namespace)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9_.-] character in namespace of location: " + StringUtils.normalizeSpace((String)namespace) + ":" + StringUtils.normalizeSpace((String)path));
        }
        return namespace;
    }

    public static boolean b(char pathChar) {
        return pathChar == '_' || pathChar == '-' || pathChar >= 'a' && pathChar <= 'z' || pathChar >= '0' && pathChar <= '9' || pathChar == '/' || pathChar == '.';
    }

    private static boolean c(char namespaceChar) {
        return namespaceChar == '_' || namespaceChar == '-' || namespaceChar >= 'a' && namespaceChar <= 'z' || namespaceChar >= '0' && namespaceChar <= '9' || namespaceChar == '.';
    }

    private static String f(String namespace, String path) {
        if (!MinecraftKey.i(path)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9/._-] character in path of location: " + namespace + ":" + StringUtils.normalizeSpace((String)path));
        }
        return path;
    }
}

